/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MTable;
import org.compiere.model.MValRule;
import org.compiere.model.X_AD_Reference;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ReferenceInfo;

public class ReferenceUtil {
    private static ReferenceUtil instance = null;
    private Properties context;
    private Map<String, ReferenceInfo> referenceInfoMap;

    public static ReferenceUtil getInstance(Properties context) {
        if (instance == null) {
            instance = new ReferenceUtil(context);
        }
        return instance;
    }

    private ReferenceUtil(Properties context) {
        this.context = context;
        this.referenceInfoMap = new HashMap<String, ReferenceInfo>();
    }

    public static boolean validateReference(int referenceId, int referenceValueId, String columnName) {
        return DisplayType.isLookup((int)referenceId);
    }

    public ReferenceInfo getReferenceInfo(int referenceId, int referenceValueId, String columnName, String language, String tableName) {
        if (!ReferenceUtil.validateReference(referenceId, referenceValueId, columnName)) {
            return null;
        }
        String key = referenceId + "|" + referenceValueId + "|" + columnName + "|" + language;
        ReferenceInfo referenceInfo = this.referenceInfoMap.get(key);
        Language languageValue = Language.getLanguage((String)Env.getAD_Language((Properties)Env.getCtx()));
        if (referenceInfo == null) {
            if (19 == referenceId || referenceValueId == 0) {
                referenceInfo = new ReferenceInfo();
                referenceInfo.setColumnName(columnName);
                referenceInfo.setDisplayColumnValue("(" + MLookupFactory.getLookup_TableDirEmbed((Language)languageValue, (String)columnName, (String)tableName) + ")");
                referenceInfo.setHasJoinValue(false);
            } else {
                MLookupInfo lookupInfo = MLookupFactory.getLookupInfo((Properties)this.context, (int)0, (int)0, (int)referenceId, (Language)languageValue, (String)columnName, (int)referenceValueId, (boolean)false, null, (boolean)false);
                if (lookupInfo != null) {
                    referenceInfo = new ReferenceInfo();
                    referenceInfo.setColumnName(columnName);
                    referenceInfo.setDisplayColumnValue((lookupInfo.DisplayColumn == null ? "" : lookupInfo.DisplayColumn).replace(lookupInfo.TableName + ".", ""));
                    referenceInfo.setJoinColumnName((lookupInfo.KeyColumn == null ? "" : lookupInfo.KeyColumn).replace(lookupInfo.TableName + ".", ""));
                    referenceInfo.setTableName(lookupInfo.TableName);
                    if (17 == referenceId && referenceValueId != 0) {
                        referenceInfo.setReferenceId(referenceValueId);
                    }
                    if (MTable.hasTranslation((String)lookupInfo.TableName)) {
                        referenceInfo.setLanguage(language);
                    }
                }
            }
        }
        return referenceInfo;
    }

    public static MLookupInfo getReferenceLookupInfo(int referenceId, int referenceValueId, String columnName, int validationRuleId) {
        if (!ReferenceUtil.validateReference(referenceId, referenceValueId, columnName)) {
            return null;
        }
        MLookupInfo lookupInformation = null;
        lookupInformation = 19 == referenceId || referenceValueId == 0 ? ReferenceUtil.getLookupInfoFromColumnName(columnName) : ReferenceUtil.getLookupInfoFromReference(referenceValueId);
        MValRule validationRule = null;
        if (validationRuleId > 0) {
            validationRule = MValRule.get((Properties)Env.getCtx(), (int)validationRuleId);
        }
        if (lookupInformation != null) {
            String queryForLookup = lookupInformation.Query;
            int positionFrom = queryForLookup.lastIndexOf(" FROM ");
            boolean hasWhereClause = queryForLookup.indexOf(" WHERE ", positionFrom) != -1;
            int positionOrder = queryForLookup.lastIndexOf(" ORDER BY ");
            queryForLookup = positionOrder != -1 ? queryForLookup.substring(0, positionOrder) + (!Util.isEmpty((String)lookupInformation.ValidationCode) ? (hasWhereClause ? " AND " : " WHERE ") + lookupInformation.ValidationCode : "") + (validationRule != null ? (hasWhereClause ? " AND " : " WHERE ") + validationRule.getCode() : "") + queryForLookup.substring(positionOrder) : queryForLookup + (!Util.isEmpty((String)lookupInformation.ValidationCode) ? (hasWhereClause ? " AND " : " WHERE ") + lookupInformation.ValidationCode : "") + (validationRule != null ? (hasWhereClause ? " AND " : " WHERE ") + validationRule.getCode() : "");
            lookupInformation.Query = queryForLookup = ReferenceUtil.getQueryWithUuid(lookupInformation.TableName, queryForLookup);
        }
        return lookupInformation;
    }

    private static MLookupInfo getLookupInfoFromReference(int referenceId) {
        MLookupInfo lookupInformation = null;
        X_AD_Reference reference = (X_AD_Reference)RecordUtil.getEntity(Env.getCtx(), "AD_Reference", null, referenceId, null);
        if (reference.getValidationType().equals("T")) {
            lookupInformation = MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)0, (int)0, (int)30, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)Env.getCtx())), null, (int)reference.getAD_Reference_ID(), (boolean)false, null, (boolean)false);
        } else if (reference.getValidationType().equals("L")) {
            lookupInformation = MLookupFactory.getLookup_List((Language)Language.getLanguage((String)Env.getAD_Language((Properties)Env.getCtx())), (int)reference.getAD_Reference_ID());
        }
        return lookupInformation;
    }

    private static String getQueryWithUuid(String tableName, String query) {
        int positionFrom = query.indexOf(" FROM ");
        return query.substring(0, positionFrom) + ", " + tableName + ".UUID" + query.substring(positionFrom);
    }

    private static MLookupInfo getLookupInfoFromColumnName(String columnName) {
        return MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)0, (int)0, (int)19, (Language)Language.getLanguage((String)Env.getAD_Language((Properties)Env.getCtx())), (String)columnName, (int)0, (boolean)false, null, (boolean)false);
    }
}

