/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import org.compiere.util.Util;

public class ReferenceInfo {
    private String displayColumnValue = "";
    private String displayColumnAlias = "";
    private String columnName = "";
    private String joinColumnName = "";
    private String tableName = "";
    private String tableAlias = "";
    private String language = "en_US";
    private int referenceId = 0;
    private boolean hasJoinValue = false;
    private final String DISPLAY_COLUMN_ALIAS = "DisplayColumn";

    public boolean isHasJoinValue() {
        return this.hasJoinValue;
    }

    public void setHasJoinValue(boolean hasJoinValue) {
        this.hasJoinValue = hasJoinValue;
    }

    public int getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(int referenceId) {
        this.referenceId = referenceId;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public boolean isTranslated() {
        return !this.language.equals("en_US");
    }

    public String getDisplayColumnValue() {
        return this.getDisplayColumnValue(false);
    }

    private String getDisplayColumnValue(boolean withTable) {
        if (withTable) {
            return this.getTableAlias(this.isTranslated()) + "." + this.displayColumnValue;
        }
        return this.displayColumnValue;
    }

    public void setDisplayColumnValue(String displayColumnValue) {
        this.displayColumnValue = displayColumnValue;
    }

    private String getDisplayColumnAlias() {
        return this.displayColumnAlias;
    }

    public void setDisplayColumnAlias(String displayColumnAlias) {
        this.displayColumnAlias = displayColumnAlias;
    }

    public String getJoinColumnName() {
        return this.getJoinColumnName(false);
    }

    private String getJoinColumnName(boolean withTable) {
        if (withTable) {
            return this.getTableAlias() + "." + this.joinColumnName;
        }
        return this.joinColumnName;
    }

    public void setJoinColumnName(String joinColumnName) {
        this.joinColumnName = joinColumnName;
        this.setHasJoinValue(true);
    }

    private String getTableName() {
        return this.getTableName(false);
    }

    private String getTableName(boolean translated) {
        if (translated) {
            return this.tableName + "_Trl";
        }
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private String getTableAlias(boolean translated) {
        if (translated) {
            return this.tableAlias + "_Trl";
        }
        return this.tableAlias;
    }

    private String getTableAlias() {
        return this.getTableAlias(false);
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    private void buildAlias() {
        this.buildAlias(null);
    }

    private void buildAlias(String columnName) {
        if (Util.isEmpty((String)this.tableAlias)) {
            this.setTableAlias(this.getColumnName() + "_" + this.getTableName());
        }
        if (Util.isEmpty((String)this.displayColumnAlias)) {
            if (Util.isEmpty((String)columnName)) {
                this.setDisplayColumnAlias("DisplayColumn_" + this.getColumnName());
            } else {
                this.setDisplayColumnAlias("DisplayColumn_" + columnName);
            }
        }
    }

    public String getDisplayValue() {
        this.buildAlias();
        return this.getDisplayColumnValue(this.isHasJoinValue()) + " AS \"" + this.getDisplayColumnAlias() + "\"";
    }

    public String getDisplayValue(String columnName) {
        this.buildAlias(columnName);
        return this.getDisplayColumnValue(this.isHasJoinValue()) + " AS \"" + this.getDisplayColumnAlias() + "\"";
    }

    public String getJoinValue(String baseColumnName, String baseTable) {
        this.buildAlias();
        if (!this.isHasJoinValue()) {
            return "";
        }
        StringBuffer join = new StringBuffer();
        join.append(" LEFT JOIN ").append(this.getTableName()).append(" AS ").append(this.getTableAlias()).append(" ON(").append(this.getJoinColumnName(true)).append(" = ").append(baseTable).append(".").append(baseColumnName);
        if (this.getReferenceId() > 0) {
            join.append(" AND ").append(this.getTableAlias() + ".AD_Reference_ID = ").append(this.getReferenceId());
        }
        join.append(")");
        if (this.isTranslated()) {
            join.append(" LEFT JOIN ").append(this.getTableName(true)).append(" AS ").append(this.getTableAlias(true)).append(" ON(").append(this.getTableAlias(true) + "." + this.getTableName() + "_ID").append(" = ").append(this.getTableAlias() + "." + this.getTableName() + "_ID");
            join.append(" AND ").append(this.getTableAlias(true)).append(".").append("AD_Language = '").append(this.getLanguage()).append("'").append(")");
        }
        return join.toString();
    }

    public String toString() {
        return "ReferenceInfo [displayColumnValue=" + this.displayColumnValue + ", displayColumnAlias=" + this.displayColumnAlias + ", columnName=" + this.columnName + ", joinColumnName=" + this.joinColumnName + ", tableName=" + this.tableName + ", tableAlias=" + this.tableAlias + ", language=" + this.language + ", referenceId=" + this.referenceId + "]";
    }
}

