/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo.IDFinder;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.model.MADAttachmentReference;
import org.spin.util.AttachmentUtil;

public class RecordUtil {
    public static final int PAGE_SIZE = 50;

    public static int getPageNumber(String sessionUuid, String pageToken) {
        int page = 0;
        String pagePrefix = RecordUtil.getPagePrefix(sessionUuid);
        if (!Util.isEmpty((String)pageToken) && pageToken.startsWith(pagePrefix)) {
            try {
                page = Integer.parseInt(pageToken.replace(pagePrefix, ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return page;
    }

    public static String getPagePrefix(String sessionUuid) {
        return sessionUuid + "-";
    }

    public static boolean isValidNextPageToken(int count, int offset, int limit) {
        return count > offset + limit && count > limit;
    }

    public static PO getEntity(Properties context, String tableName, String uuid, int recordId, String transactionName) {
        if (recordId == 0 && Util.isEmpty((String)uuid)) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
        if (Util.isEmpty((String)tableName)) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        if (!Util.isEmpty((String)uuid)) {
            whereClause.append("UUID = ?");
            params.add(uuid);
        } else if (recordId > 0) {
            whereClause.append(tableName + "_ID = ?");
            params.add(recordId);
        } else {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
        return new Query(context, tableName, whereClause.toString(), transactionName).setParameters(params).first();
    }

    public static PO getEntity(Properties context, String tableName, String whereClause, List<Object> parameters, String transactionName) {
        if (Util.isEmpty((String)whereClause)) {
            throw new AdempiereException("@WhereClause@ @NotFound@");
        }
        if (Util.isEmpty((String)tableName)) {
            throw new AdempiereException("@AD_Table_ID@ @NotFound@");
        }
        return new Query(context, tableName, whereClause, transactionName).setParameters(parameters).first();
    }

    public static int getIdFromUuid(String tableName, String uuid, String transactionName) {
        if (Util.isEmpty((String)tableName) || Util.isEmpty((String)uuid)) {
            return -1;
        }
        return IDFinder.getIdFromUUID((Properties)Env.getCtx(), (String)tableName, (String)uuid, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)transactionName);
    }

    public static String getUuidFromId(String tableName, int id) {
        if (Util.isEmpty((String)tableName) || id <= 0) {
            return null;
        }
        return IDFinder.getUUIDFromId((String)tableName, (int)id, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), null);
    }

    public static String getUuidFromId(String tableName, int id, String transactionName) {
        if (Util.isEmpty((String)tableName) || id <= 0) {
            return null;
        }
        return IDFinder.getUUIDFromId((String)tableName, (int)id, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)transactionName);
    }

    public static String getResourceUuidFromImageId(int imageId) {
        MADAttachmentReference reference = RecordUtil.getResourceFromImageId(imageId);
        if (reference == null) {
            return null;
        }
        return reference.getUUID();
    }

    public static MADAttachmentReference getResourceFromImageId(int imageId) {
        if (!AttachmentUtil.getInstance().isValidForClient(Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            return null;
        }
        return MADAttachmentReference.getByImageId((Properties)Env.getCtx(), (int)MClientInfo.get((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx())).getFileHandler_ID(), (int)imageId, null);
    }

    public static MConversionRate getConversionRate(int organizationId, int conversionTypeId, int currencyFromId, int currencyToId, Timestamp conversionDate) {
        int conversionRateId;
        if (conversionTypeId <= 0 || currencyFromId <= 0 || currencyToId <= 0) {
            return null;
        }
        conversionDate = TimeUtil.getDay((Timestamp)Optional.ofNullable(conversionDate).orElse(new Timestamp(System.currentTimeMillis())));
        if (organizationId < 0) {
            organizationId = 0;
        }
        if ((conversionRateId = MConversionRate.getConversionRateId((int)currencyFromId, (int)currencyToId, (Timestamp)conversionDate, (int)conversionTypeId, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)organizationId)) > 0) {
            return MConversionRate.get((Properties)Env.getCtx(), (int)conversionRateId);
        }
        return null;
    }

    public static int countRecords(String sql, String tableName, List<Object> parameters) {
        Matcher matcher = Pattern.compile("\\b(?:FROM+)+\\s+" + tableName + " AS " + tableName, 34).matcher(sql);
        int positionFrom = -1;
        if (!matcher.find()) {
            return 0;
        }
        positionFrom = matcher.start();
        String queryCount = "SELECT COUNT(*) " + sql.substring(positionFrom, sql.length());
        return DB.getSQLValueEx(null, (String)queryCount, parameters);
    }

    public static Timestamp getDate() {
        return TimeUtil.getDay((long)System.currentTimeMillis());
    }
}

