/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MViewColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.spin.base.util.ReferenceInfo;
import org.spin.base.util.ReferenceUtil;
import org.spin.util.ASPUtil;

public class DictionaryUtil {
    public static String getQueryWithReferencesFromTab(MTab tab) {
        MTable table = MTable.get((Properties)Env.getCtx(), (int)tab.getAD_Table_ID());
        String originalQuery = "SELECT " + table.getTableName() + ".* FROM " + table.getTableName() + " AS " + table.getTableName() + " ";
        int fromIndex = originalQuery.toUpperCase().indexOf(" FROM ");
        StringBuffer queryToAdd = new StringBuffer(originalQuery.substring(0, fromIndex));
        StringBuffer joinsToAdd = new StringBuffer(originalQuery.substring(fromIndex, originalQuery.length() - 1));
        Language language = Language.getLanguage((String)Env.getAD_Language((Properties)Env.getCtx()));
        for (MField field : tab.getFields(false, null)) {
            if (!field.isDisplayed()) continue;
            MColumn column = MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID());
            int displayTypeId = field.getAD_Reference_ID();
            if (displayTypeId == 0) {
                displayTypeId = column.getAD_Reference_ID();
            }
            if (!DisplayType.isLookup((int)displayTypeId)) continue;
            int referenceValueId = field.getAD_Reference_Value_ID();
            if (referenceValueId == 0) {
                referenceValueId = column.getAD_Reference_Value_ID();
            }
            String columnName = column.getColumnName();
            String tableName = table.getTableName();
            queryToAdd.append(", ");
            ReferenceInfo referenceInfo = ReferenceUtil.getInstance(Env.getCtx()).getReferenceInfo(displayTypeId, referenceValueId, columnName, language.getAD_Language(), tableName);
            if (referenceInfo == null) continue;
            queryToAdd.append(referenceInfo.getDisplayValue(columnName));
            joinsToAdd.append(referenceInfo.getJoinValue(columnName, tableName));
        }
        queryToAdd.append(joinsToAdd);
        return queryToAdd.toString();
    }

    public static List<String> getContextColumnNames(String context) {
        if (context == null) {
            return new ArrayList<String>();
        }
        String START = "\\@";
        String END = "\\@";
        String patternValue = START + "(#|$){0,1}(\\w+)" + END;
        Pattern pattern = Pattern.compile(patternValue);
        Matcher matcher = pattern.matcher(context);
        HashMap<String, Boolean> columnNamesMap = new HashMap<String, Boolean>();
        while (matcher.find()) {
            columnNamesMap.put(matcher.group().replace("@", "").replace("@", ""), true);
        }
        return new ArrayList<String>(columnNamesMap.keySet());
    }

    public static String getSQLFromBrowser(MBrowse browser) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT ");
        AtomicBoolean co = new AtomicBoolean(false);
        ASPUtil.getInstance().getBrowseDisplayFields(browser.getAD_Browse_ID()).forEach(field -> {
            MViewColumn viewColumn;
            if (co.get()) {
                sql.append(",");
            }
            if ((viewColumn = field.getAD_View_Column()).getColumnSQL() != null && viewColumn.getColumnSQL().length() > 0) {
                sql.append(viewColumn.getColumnSQL());
                co.set(true);
            }
            sql.append(" AS \"" + viewColumn.getColumnName() + "\"");
        });
        sql.append(" FROM ").append(browser.getAD_View().getFromClause());
        return sql.toString();
    }

    public static String addQueryReferencesFromBrowser(MBrowse browser) {
        String originalQuery = DictionaryUtil.getSQLFromBrowser(browser);
        int fromIndex = originalQuery.toUpperCase().indexOf(" FROM ");
        StringBuffer queryToAdd = new StringBuffer(originalQuery.substring(0, fromIndex));
        StringBuffer joinsToAdd = new StringBuffer(originalQuery.substring(fromIndex, originalQuery.length() - 1));
        for (MBrowseField browseField : ASPUtil.getInstance().getBrowseDisplayFields(browser.getAD_Browse_ID())) {
            int displayTypeId = browseField.getAD_Reference_ID();
            if (!DisplayType.isLookup((int)displayTypeId)) continue;
            int referenceValueId = browseField.getAD_Reference_Value_ID();
            String columnName = browseField.getAD_Element().getColumnName();
            String tableName = browseField.getAD_View_Column().getAD_View_Definition().getTableAlias();
            if (browseField.getAD_View_Column().getAD_Column_ID() > 0) {
                columnName = browseField.getAD_View_Column().getAD_Column().getColumnName();
            }
            queryToAdd.append(", ");
            ReferenceInfo referenceInfo = ReferenceUtil.getInstance(Env.getCtx()).getReferenceInfo(displayTypeId, referenceValueId, columnName, Env.getAD_Language((Properties)Env.getCtx()), tableName);
            if (referenceInfo == null) continue;
            queryToAdd.append(referenceInfo.getDisplayValue(browseField.getAD_View_Column().getColumnName()));
            joinsToAdd.append(referenceInfo.getJoinValue(columnName, tableName));
        }
        queryToAdd.append(joinsToAdd);
        return queryToAdd.toString();
    }

    public static String getSQLOrderBy(MBrowse browser) {
        StringBuilder sqlOrderBy = new StringBuilder();
        for (MBrowseField field : ASPUtil.getInstance().getBrowseOrderByFields(browser.getAD_Browse_ID())) {
            if (sqlOrderBy.length() > 0) {
                sqlOrderBy.append(",");
            }
            sqlOrderBy.append(field.getAD_View_Column().getColumnSQL());
        }
        return sqlOrderBy.length() > 0 ? sqlOrderBy.toString() : "";
    }

    public static int getOrderByPosition(MBrowse browser, MBrowseField BrowserField) {
        int colOffset = 1;
        int col = 0;
        for (MBrowseField field : browser.getFields()) {
            int sortBySqlNo = col + colOffset;
            if (BrowserField.getAD_Browse_Field_ID() == field.getAD_Browse_Field_ID()) {
                return sortBySqlNo;
            }
            ++col;
        }
        return -1;
    }
}

