/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.compiere.model.MAttachment;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCharge;
import org.compiere.model.MChatEntry;
import org.compiere.model.MCity;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MLanguage;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPOS;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPOSKeyLayout;
import org.compiere.model.MPayment;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MRefList;
import org.compiere.model.MRegion;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.compiere.util.Util;
import org.spin.base.util.RecordUtil;
import org.spin.base.util.ValueUtil;
import org.spin.grpc.util.Address;
import org.spin.grpc.util.Attachment;
import org.spin.grpc.util.AvailableSeller;
import org.spin.grpc.util.BankAccount;
import org.spin.grpc.util.BusinessPartner;
import org.spin.grpc.util.Charge;
import org.spin.grpc.util.ChatEntry;
import org.spin.grpc.util.City;
import org.spin.grpc.util.ConversionRate;
import org.spin.grpc.util.Country;
import org.spin.grpc.util.Currency;
import org.spin.grpc.util.Customer;
import org.spin.grpc.util.CustomerBankAccount;
import org.spin.grpc.util.DocumentAction;
import org.spin.grpc.util.DocumentStatus;
import org.spin.grpc.util.DocumentType;
import org.spin.grpc.util.Entity;
import org.spin.grpc.util.Key;
import org.spin.grpc.util.KeyLayout;
import org.spin.grpc.util.Language;
import org.spin.grpc.util.Order;
import org.spin.grpc.util.OrderLine;
import org.spin.grpc.util.Organization;
import org.spin.grpc.util.Payment;
import org.spin.grpc.util.PriceList;
import org.spin.grpc.util.Product;
import org.spin.grpc.util.Region;
import org.spin.grpc.util.ResourceReference;
import org.spin.grpc.util.SalesRepresentative;
import org.spin.grpc.util.Shipment;
import org.spin.grpc.util.ShipmentLine;
import org.spin.grpc.util.TaxRate;
import org.spin.grpc.util.Value;
import org.spin.grpc.util.Warehouse;
import org.spin.model.MADAttachmentReference;
import org.spin.util.AttachmentUtil;

public class ConvertUtil {
    public static AvailableSeller.Builder convertSeller(MUser user) {
        AvailableSeller.Builder sellerInfo = AvailableSeller.newBuilder();
        sellerInfo.setId(user.getAD_User_ID());
        sellerInfo.setUuid(ValueUtil.validateNull(user.getUUID()));
        sellerInfo.setName(ValueUtil.validateNull(user.getName()));
        sellerInfo.setDescription(ValueUtil.validateNull(user.getDescription()));
        sellerInfo.setComments(ValueUtil.validateNull(user.getComments()));
        if (user.getLogo_ID() > 0 && AttachmentUtil.getInstance().isValidForClient(user.getAD_Client_ID())) {
            MClientInfo clientInfo = MClientInfo.get((Properties)Env.getCtx(), (int)user.getAD_Client_ID());
            MADAttachmentReference attachmentReference = MADAttachmentReference.getByImageId((Properties)user.getCtx(), (int)clientInfo.getFileHandler_ID(), (int)user.getLogo_ID(), null);
            if (attachmentReference != null && attachmentReference.getAD_AttachmentReference_ID() > 0) {
                sellerInfo.setImage(ValueUtil.validateNull(attachmentReference.getValidFileName()));
            }
        }
        return sellerInfo;
    }

    public static ChatEntry.Builder convertChatEntry(MChatEntry chatEntry) {
        ChatEntry.Builder builder = ChatEntry.newBuilder();
        builder.setUuid(ValueUtil.validateNull(chatEntry.getUUID()));
        builder.setId(chatEntry.getCM_ChatEntry_ID());
        builder.setChatUuid(ValueUtil.validateNull(chatEntry.getCM_Chat().getUUID()));
        builder.setSubject(ValueUtil.validateNull(chatEntry.getSubject()));
        builder.setCharacterData(ValueUtil.validateNull(chatEntry.getCharacterData()));
        if (chatEntry.getAD_User_ID() != 0) {
            MUser user = MUser.get((Properties)chatEntry.getCtx(), (int)chatEntry.getAD_User_ID());
            builder.setUserUuid(ValueUtil.validateNull(user.getUUID()));
            builder.setUserName(ValueUtil.validateNull(user.getName()));
        }
        builder.setLogDate(chatEntry.getCreated().getTime());
        if (!Util.isEmpty((String)chatEntry.getConfidentialType())) {
            if (chatEntry.getConfidentialType().equals("A")) {
                builder.setConfidentialType(ChatEntry.ConfidentialType.PUBLIC);
            } else if (chatEntry.getConfidentialType().equals("C")) {
                builder.setConfidentialType(ChatEntry.ConfidentialType.PARTER);
            } else if (chatEntry.getConfidentialType().equals("I")) {
                builder.setConfidentialType(ChatEntry.ConfidentialType.INTERNAL);
            }
        }
        if (!Util.isEmpty((String)chatEntry.getModeratorStatus())) {
            if (chatEntry.getModeratorStatus().equals("N")) {
                builder.setModeratorStatus(ChatEntry.ModeratorStatus.NOT_DISPLAYED);
            } else if (chatEntry.getModeratorStatus().equals("P")) {
                builder.setModeratorStatus(ChatEntry.ModeratorStatus.PUBLISHED);
            } else if (chatEntry.getModeratorStatus().equals("S")) {
                builder.setModeratorStatus(ChatEntry.ModeratorStatus.SUSPICIUS);
            } else if (chatEntry.getModeratorStatus().equals("R")) {
                builder.setModeratorStatus(ChatEntry.ModeratorStatus.TO_BE_REVIEWED);
            }
        }
        if (!Util.isEmpty((String)chatEntry.getChatEntryType())) {
            if (chatEntry.getChatEntryType().equals("N")) {
                builder.setChatEntryType(ChatEntry.ChatEntryType.NOTE_FLAT);
            } else if (chatEntry.getChatEntryType().equals("F")) {
                builder.setChatEntryType(ChatEntry.ChatEntryType.NOTE_FLAT);
            } else if (chatEntry.getChatEntryType().equals("W")) {
                builder.setChatEntryType(ChatEntry.ChatEntryType.NOTE_FLAT);
            }
        }
        return builder;
    }

    public static Entity.Builder convertEntity(PO entity) {
        Entity.Builder builder = Entity.newBuilder();
        if (entity == null) {
            return builder;
        }
        builder.setUuid(ValueUtil.validateNull(entity.get_ValueAsString("UUID"))).setId(entity.get_ID());
        POInfo poInfo = POInfo.getPOInfo((Properties)Env.getCtx(), (int)entity.get_Table_ID());
        builder.setTableName(ValueUtil.validateNull(poInfo.getTableName()));
        for (int index = 0; index < poInfo.getColumnCount(); ++index) {
            Value.Builder builderValue;
            String columnName = poInfo.getColumnName(index);
            int referenceId = poInfo.getColumnDisplayType(index);
            Object value = entity.get_Value(index);
            if (value == null || (builderValue = ValueUtil.getValueFromReference(value, referenceId)) == null) continue;
            builder.putValues(columnName, builderValue.build());
        }
        return builder;
    }

    public static DocumentAction.Builder convertDocumentAction(String value, String name, String description) {
        return DocumentAction.newBuilder().setValue(ValueUtil.validateNull(value)).setName(ValueUtil.validateNull(name)).setDescription(ValueUtil.validateNull(description));
    }

    public static DocumentStatus.Builder convertDocumentStatus(String value, String name, String description) {
        return DocumentStatus.newBuilder().setValue(ValueUtil.validateNull(value)).setName(ValueUtil.validateNull(name)).setDescription(ValueUtil.validateNull(description));
    }

    public static DocumentType.Builder convertDocumentType(MDocType documentType) {
        return DocumentType.newBuilder().setUuid(ValueUtil.validateNull(documentType.getUUID())).setId(documentType.getC_DocType_ID()).setName(ValueUtil.validateNull(documentType.getName())).setDescription(ValueUtil.validateNull(documentType.getDescription())).setPrintName(ValueUtil.validateNull(documentType.getPrintName()));
    }

    public static BusinessPartner.Builder convertBusinessPartner(MBPartner businessPartner) {
        if (businessPartner == null) {
            return BusinessPartner.newBuilder();
        }
        return BusinessPartner.newBuilder().setUuid(ValueUtil.validateNull(businessPartner.getUUID())).setId(businessPartner.getC_BPartner_ID()).setValue(ValueUtil.validateNull(businessPartner.getValue())).setTaxId(ValueUtil.validateNull(businessPartner.getTaxID())).setDuns(ValueUtil.validateNull(businessPartner.getDUNS())).setNaics(ValueUtil.validateNull(businessPartner.getNAICS())).setName(ValueUtil.validateNull(businessPartner.getName())).setLastName(ValueUtil.validateNull(businessPartner.getName2())).setDescription(ValueUtil.validateNull(businessPartner.getDescription()));
    }

    public static Charge.Builder convertCharge(MCharge charge) {
        Charge.Builder builder = Charge.newBuilder();
        if (charge == null) {
            return builder;
        }
        return builder.setUuid(ValueUtil.validateNull(charge.getUUID())).setId(charge.getC_Charge_ID()).setName(ValueUtil.validateNull(charge.getName())).setDescription(ValueUtil.validateNull(charge.getDescription()));
    }

    public static ConversionRate.Builder convertConversionRate(MConversionRate conversionRate) {
        ConversionRate.Builder builder = ConversionRate.newBuilder();
        if (conversionRate == null) {
            return builder;
        }
        builder.setUuid(ValueUtil.validateNull(conversionRate.getUUID())).setId(conversionRate.getC_Conversion_Rate_ID()).setValidFrom(ValueUtil.validateNull(ValueUtil.convertDateToString(conversionRate.getValidFrom()))).setConversionTypeUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_ConversionType", conversionRate.getC_ConversionType_ID()))).setCurrencyFrom(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)conversionRate.getC_Currency_ID()))).setCurrencyTo(ConvertUtil.convertCurrency(MCurrency.get((Properties)Env.getCtx(), (int)conversionRate.getC_Currency_ID_To()))).setMultiplyRate(ValueUtil.getDecimalFromBigDecimal(conversionRate.getMultiplyRate())).setDivideRate(ValueUtil.getDecimalFromBigDecimal(conversionRate.getDivideRate()));
        if (conversionRate.getValidTo() != null) {
            builder.setValidTo(ValueUtil.validateNull(ValueUtil.convertDateToString(conversionRate.getValidTo())));
        }
        return builder;
    }

    public static Product.Builder convertProduct(MProduct product) {
        Product.Builder builder = Product.newBuilder();
        builder.setUuid(ValueUtil.validateNull(product.getUUID())).setId(product.getM_Product_ID()).setValue(ValueUtil.validateNull(product.getValue())).setName(ValueUtil.validateNull(product.getName())).setDescription(ValueUtil.validateNull(product.getDescription())).setHelp(ValueUtil.validateNull(product.getHelp())).setDocumentNote(ValueUtil.validateNull(product.getDocumentNote())).setUomName(ValueUtil.validateNull(MUOM.get((Properties)product.getCtx(), (int)product.getC_UOM_ID()).getName())).setDescriptionUrl(ValueUtil.validateNull(product.getDescriptionURL())).setIsStocked(product.isStocked()).setIsDropShip(product.isDropShip()).setIsPurchased(product.isPurchased()).setIsSold(product.isSold()).setImageUrl(ValueUtil.validateNull(product.getImageURL())).setUpc(ValueUtil.validateNull(product.getUPC())).setSku(ValueUtil.validateNull(product.getSKU())).setVersionNo(ValueUtil.validateNull(product.getVersionNo())).setGuaranteeDays(product.getGuaranteeDays()).setWeight(ValueUtil.getDecimalFromBigDecimal(product.getWeight())).setVolume(ValueUtil.getDecimalFromBigDecimal(product.getVolume())).setShelfDepth(product.getShelfDepth()).setShelfHeight(ValueUtil.getDecimalFromBigDecimal(product.getShelfHeight())).setShelfWidth(product.getShelfWidth()).setUnitsPerPallet(ValueUtil.getDecimalFromBigDecimal(product.getUnitsPerPallet())).setUnitsPerPack(product.getUnitsPerPack()).setTaxCategory(ValueUtil.validateNull(product.getC_TaxCategory().getName())).setProductCategoryName(ValueUtil.validateNull(MProductCategory.get((Properties)product.getCtx(), (int)product.getM_Product_Category_ID()).getName()));
        if (product.getM_Product_Group_ID() != 0) {
            builder.setProductGroupName(ValueUtil.validateNull(product.getM_Product_Group().getName()));
        }
        if (product.getM_Product_Class_ID() != 0) {
            builder.setProductClassName(ValueUtil.validateNull(product.getM_Product_Class().getName()));
        }
        if (product.getM_Product_Classification_ID() != 0) {
            builder.setProductClassificationName(ValueUtil.validateNull(product.getM_Product_Classification().getName()));
        }
        return builder;
    }

    public static Language.Builder convertLanguage(MLanguage language) {
        org.compiere.util.Language staticLanguage;
        String datePattern = language.getDatePattern();
        String timePattern = language.getTimePattern();
        if (Util.isEmpty((String)datePattern)) {
            staticLanguage = org.compiere.util.Language.getLanguage((String)language.getAD_Language());
            if (staticLanguage != null) {
                datePattern = staticLanguage.getDateFormat().toPattern();
            }
            if (Util.isEmpty((String)datePattern)) {
                datePattern = language.getDateFormat().toPattern();
            }
        }
        if (Util.isEmpty((String)timePattern) && (staticLanguage = org.compiere.util.Language.getLanguage((String)language.getAD_Language())) != null) {
            timePattern = staticLanguage.getTimeFormat().toPattern();
        }
        return Language.newBuilder().setLanguage(ValueUtil.validateNull(language.getAD_Language())).setCountryCode(ValueUtil.validateNull(language.getCountryCode())).setLanguageIso(ValueUtil.validateNull(language.getLanguageISO())).setLanguageName(ValueUtil.validateNull(language.getName())).setDatePattern(ValueUtil.validateNull(datePattern)).setTimePattern(ValueUtil.validateNull(timePattern)).setIsBaseLanguage(language.isBaseLanguage()).setIsSystemLanguage(language.isSystemLanguage()).setIsDecimalPoint(language.isDecimalPoint());
    }

    public static Country.Builder convertCountry(Properties context, MCountry country) {
        Country.Builder builder = Country.newBuilder();
        if (country == null) {
            return builder;
        }
        builder.setUuid(ValueUtil.validateNull(country.getUUID())).setId(country.getC_Country_ID()).setCountryCode(ValueUtil.validateNull(country.getCountryCode())).setName(ValueUtil.validateNull(country.getName())).setDescription(ValueUtil.validateNull(country.getDescription())).setHasRegion(country.isHasRegion()).setRegionName(ValueUtil.validateNull(country.getRegionName())).setDisplaySequence(ValueUtil.validateNull(country.getDisplaySequence())).setIsAddressLinesReverse(country.isAddressLinesReverse()).setCaptureSequence(ValueUtil.validateNull(country.getCaptureSequence())).setDisplaySequenceLocal(ValueUtil.validateNull(country.getDisplaySequenceLocal())).setIsAddressLinesLocalReverse(country.isAddressLinesLocalReverse()).setHasPostalAdd(country.isHasPostal_Add()).setExpressionPhone(ValueUtil.validateNull(country.getExpressionPhone())).setMediaSize(ValueUtil.validateNull(country.getMediaSize())).setExpressionBankRoutingNo(ValueUtil.validateNull(country.getExpressionBankRoutingNo())).setExpressionBankAccountNo(ValueUtil.validateNull(country.getExpressionBankAccountNo())).setAllowCitiesOutOfList(country.isAllowCitiesOutOfList()).setIsPostcodeLookup(country.isPostcodeLookup()).setLanguage(ValueUtil.validateNull(country.getAD_Language()));
        if (country.getC_Currency_ID() != 0) {
            builder.setCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)context, (int)country.getC_Currency_ID())));
        }
        return builder;
    }

    public static Currency.Builder convertCurrency(MCurrency currency) {
        Currency.Builder builder = Currency.newBuilder();
        if (currency == null) {
            return builder;
        }
        return builder.setUuid(ValueUtil.validateNull(currency.getUUID())).setId(currency.getC_Currency_ID()).setIsoCode(ValueUtil.validateNull(currency.getISO_Code())).setCurSymbol(ValueUtil.validateNull(currency.getCurSymbol())).setDescription(ValueUtil.validateNull(currency.getDescription())).setStandardPrecision(currency.getStdPrecision()).setCostingPrecision(currency.getCostingPrecision());
    }

    public static PriceList.Builder convertPriceList(MPriceList priceList) {
        PriceList.Builder builder = PriceList.newBuilder();
        if (priceList == null) {
            return builder;
        }
        return builder.setUuid(ValueUtil.validateNull(priceList.getUUID())).setId(priceList.getM_PriceList_ID()).setName(ValueUtil.validateNull(priceList.getName())).setDescription(ValueUtil.validateNull(priceList.getDescription())).setCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)priceList.getCtx(), (int)priceList.getC_Currency_ID()))).setIsDefault(priceList.isDefault()).setIsTaxIncluded(priceList.isTaxIncluded()).setIsEnforcePriceLimit(priceList.isEnforcePriceLimit()).setIsNetPrice(priceList.isNetPrice()).setPricePrecision(priceList.getPricePrecision());
    }

    private static List<PO> getPaymentReferences(MOrder order) {
        if (MTable.get((Properties)Env.getCtx(), (String)"C_POSPaymentReference") == null) {
            return new ArrayList<PO>();
        }
        return new Query(order.getCtx(), "C_POSPaymentReference", "C_Order_ID = ?", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
    }

    public static Order.Builder convertOrder(MOrder order) {
        Order.Builder builder = Order.newBuilder();
        if (order == null) {
            return builder;
        }
        MPOS pos = new MPOS(Env.getCtx(), order.getC_POS_ID(), order.get_TrxName());
        int defaultDiscountChargeId = pos.get_ValueAsInt("DefaultDiscountCharge_ID");
        MRefList reference = MRefList.get((Properties)Env.getCtx(), (int)131, (String)order.getDocStatus(), null);
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)order.getM_PriceList_ID(), (String)order.get_TrxName());
        List<MOrderLine> orderLines = Arrays.asList(order.getLines());
        BigDecimal totalLines = orderLines.stream().filter(orderLine -> orderLine.getC_Charge_ID() != defaultDiscountChargeId || defaultDiscountChargeId == 0).map(orderLine -> Optional.ofNullable(orderLine.getLineNetAmt()).orElse(Env.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountAmount = orderLines.stream().filter(orderLine -> orderLine.getC_Charge_ID() > 0 && orderLine.getC_Charge_ID() == defaultDiscountChargeId).map(orderLine -> Optional.ofNullable(orderLine.getLineNetAmt()).orElse(Env.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        Optional paidAmount = MPayment.getOfOrder((MOrder)order).stream().map(payment -> {
            BigDecimal paymentAmount = payment.getPayAmt();
            if (!payment.isReceipt()) {
                paymentAmount = payment.getPayAmt().negate();
            }
            return ConvertUtil.getConvetedAmount(order, payment, paymentAmount);
        }).collect(Collectors.reducing(BigDecimal::add));
        Optional paymentReferenceAmount = ConvertUtil.getPaymentReferences(order).stream().filter(paymentReference -> !paymentReference.get_ValueAsBoolean("Processed") && !paymentReference.get_ValueAsBoolean("IsPaid")).map(paymentReference -> {
            BigDecimal amount = (BigDecimal)paymentReference.get_Value("Amount");
            if (paymentReference.get_ValueAsBoolean("IsReceipt")) {
                amount = amount.negate();
            }
            return ConvertUtil.getConvetedAmount(order, paymentReference, amount);
        }).collect(Collectors.reducing(BigDecimal::add));
        BigDecimal grandTotal = order.getGrandTotal();
        BigDecimal paymentAmount = Env.ZERO;
        if (paidAmount.isPresent()) {
            paymentAmount = (BigDecimal)paidAmount.get();
        }
        if (paymentReferenceAmount.isPresent()) {
            paymentAmount = paymentAmount.subtract((BigDecimal)paymentReferenceAmount.get());
        }
        BigDecimal openAmount = grandTotal.subtract(paymentAmount).compareTo(Env.ZERO) < 0 ? Env.ZERO : grandTotal.subtract(paymentAmount);
        BigDecimal refundAmount = grandTotal.subtract(paymentAmount).compareTo(Env.ZERO) > 0 ? Env.ZERO : grandTotal.subtract(paymentAmount).negate();
        BigDecimal displayCurrencyRate = ConvertUtil.getDisplayConversionRateFromOrder(order);
        return builder.setUuid(ValueUtil.validateNull(order.getUUID())).setId(order.getC_Order_ID()).setDocumentType(ConvertUtil.convertDocumentType(MDocType.get((Properties)Env.getCtx(), (int)order.getC_DocTypeTarget_ID()))).setDocumentNo(ValueUtil.validateNull(order.getDocumentNo())).setSalesRepresentative(ConvertUtil.convertSalesRepresentative(MUser.get((Properties)Env.getCtx(), (int)order.getSalesRep_ID()))).setDescription(ValueUtil.validateNull(order.getDescription())).setOrderReference(ValueUtil.validateNull(order.getPOReference())).setDocumentStatus(ConvertUtil.convertDocumentStatus(ValueUtil.validateNull(order.getDocStatus()), ValueUtil.validateNull(ValueUtil.getTranslation((PO)reference, "Name")), ValueUtil.validateNull(ValueUtil.getTranslation((PO)reference, "Description")))).setPriceList(ConvertUtil.convertPriceList(MPriceList.get((Properties)Env.getCtx(), (int)order.getM_PriceList_ID(), (String)order.get_TrxName()))).setWarehouse(ConvertUtil.convertWarehouse(order.getM_Warehouse_ID())).setIsDelivered(order.isDelivered()).setDiscountAmount(ValueUtil.getDecimalFromBigDecimal(Optional.ofNullable(discountAmount).orElse(Env.ZERO).setScale(priceList.getStandardPrecision(), 4))).setTaxAmount(ValueUtil.getDecimalFromBigDecimal(grandTotal.subtract(totalLines.add(discountAmount)).setScale(priceList.getStandardPrecision(), 4))).setTotalLines(ValueUtil.getDecimalFromBigDecimal(totalLines.setScale(priceList.getStandardPrecision(), 4))).setGrandTotal(ValueUtil.getDecimalFromBigDecimal(grandTotal.setScale(priceList.getStandardPrecision(), 4))).setDisplayCurrencyRate(ValueUtil.getDecimalFromBigDecimal(displayCurrencyRate.setScale(priceList.getStandardPrecision(), 4))).setPaymentAmount(ValueUtil.getDecimalFromBigDecimal(paymentAmount.setScale(priceList.getStandardPrecision(), 4))).setOpenAmount(ValueUtil.getDecimalFromBigDecimal(openAmount.setScale(priceList.getStandardPrecision(), 4))).setRefundAmount(ValueUtil.getDecimalFromBigDecimal(refundAmount.setScale(priceList.getStandardPrecision(), 4))).setDateOrdered(ValueUtil.convertDateToString(order.getDateOrdered())).setCustomer(ConvertUtil.convertCustomer((MBPartner)order.getC_BPartner())).setCampaignUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_Campaign", order.getC_Campaign_ID())));
    }

    private static BigDecimal getConvetedAmount(MOrder order, PO payment, BigDecimal amount) {
        if (payment.get_ValueAsInt("C_Currency_ID") == order.getC_Currency_ID() || amount == null || amount.compareTo(Env.ZERO) == 0) {
            return amount;
        }
        BigDecimal convertedAmount = MConversionRate.convert((Properties)payment.getCtx(), (BigDecimal)amount, (int)payment.get_ValueAsInt("C_Currency_ID"), (int)order.getC_Currency_ID(), (Timestamp)order.getDateAcct(), (int)payment.get_ValueAsInt("C_ConversionType_ID"), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
        return Optional.ofNullable(convertedAmount).orElse(Env.ZERO);
    }

    private static BigDecimal getConvetedAmount(MOrder order, MPayment payment, BigDecimal amount) {
        if (payment.getC_Currency_ID() == order.getC_Currency_ID() || amount == null || amount.compareTo(Env.ZERO) == 0) {
            return amount;
        }
        BigDecimal convertedAmount = MConversionRate.convert((Properties)payment.getCtx(), (BigDecimal)amount, (int)payment.getC_Currency_ID(), (int)order.getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
        return Optional.ofNullable(convertedAmount).orElse(Env.ZERO);
    }

    private static BigDecimal getDisplayConversionRateFromOrder(MOrder order) {
        MPOS pos = MPOS.get((Properties)order.getCtx(), (int)order.getC_POS_ID());
        if (order.getC_Currency_ID() == pos.get_ValueAsInt("DisplayCurrency_ID") || pos.get_ValueAsInt("DisplayCurrency_ID") <= 0) {
            return Env.ONE;
        }
        BigDecimal conversionRate = MConversionRate.getRate((int)order.getC_Currency_ID(), (int)pos.get_ValueAsInt("DisplayCurrency_ID"), (Timestamp)order.getDateAcct(), (int)order.getC_ConversionType_ID(), (int)order.getAD_Client_ID(), (int)order.getAD_Org_ID());
        return Optional.ofNullable(conversionRate).orElse(Env.ZERO);
    }

    public static Payment.Builder convertPayment(MPayment payment) {
        MInvoice creditMemo;
        Payment.Builder builder = Payment.newBuilder();
        if (payment == null) {
            return builder;
        }
        MRefList reference = MRefList.get((Properties)Env.getCtx(), (int)131, (String)payment.getDocStatus(), (String)payment.get_TrxName());
        int presicion = MCurrency.getStdPrecision((Properties)payment.getCtx(), (int)payment.getC_Currency_ID());
        BigDecimal orderConversionRate = ConvertUtil.getOrderConversionRateFromPayment(payment);
        BigDecimal paymentAmount = payment.getPayAmt();
        if (payment.getTenderType().equals("M") && paymentAmount.compareTo(Env.ZERO) == 0 && (creditMemo = (MInvoice)new Query(payment.getCtx(), "C_Invoice", "C_Payment_ID = ?", payment.get_TrxName()).setParameters(new Object[]{payment.getC_Payment_ID()}).first()) != null) {
            paymentAmount = creditMemo.getGrandTotal();
        }
        paymentAmount = paymentAmount.setScale(presicion, 4);
        builder.setId(payment.getC_Payment_ID()).setUuid(ValueUtil.validateNull(payment.getUUID())).setOrderUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_Order", payment.getC_Order_ID()))).setDocumentNo(ValueUtil.validateNull(payment.getDocumentNo())).setTenderTypeCode(ValueUtil.validateNull(payment.getTenderType())).setPaymentMethodUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_PaymentMethod", payment.get_ValueAsInt("C_PaymentMethod_ID")))).setReferenceNo(ValueUtil.validateNull(Optional.ofNullable(payment.getCheckNo()).orElse(payment.getDocumentNo()))).setDescription(ValueUtil.validateNull(payment.getDescription())).setAmount(ValueUtil.getDecimalFromBigDecimal(paymentAmount)).setOrderCurrencyRate(ValueUtil.getDecimalFromBigDecimal(orderConversionRate)).setBankUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_Bank", payment.getC_Bank_ID()))).setCustomer(ConvertUtil.convertCustomer((MBPartner)payment.getC_BPartner())).setCurrencyUuid(RecordUtil.getUuidFromId("C_Currency", payment.getC_Currency_ID())).setPaymentDate(ValueUtil.convertDateToString(payment.getDateTrx())).setIsRefund(!payment.isReceipt()).setPaymentAccountDate(ValueUtil.convertDateToString(payment.getDateAcct())).setDocumentStatus(ConvertUtil.convertDocumentStatus(ValueUtil.validateNull(payment.getDocStatus()), ValueUtil.validateNull(ValueUtil.getTranslation((PO)reference, "Name")), ValueUtil.validateNull(ValueUtil.getTranslation((PO)reference, "Description"))));
        return builder;
    }

    private static BigDecimal getOrderConversionRateFromPayment(MPayment payment) {
        if (payment.getC_Order_ID() <= 0) {
            return Env.ONE;
        }
        MOrder order = (MOrder)payment.getC_Order();
        if (payment.getC_Currency_ID() == order.getC_Currency_ID()) {
            return Env.ONE;
        }
        BigDecimal conversionRate = MConversionRate.getRate((int)payment.getC_Currency_ID(), (int)order.getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
        return Optional.ofNullable(conversionRate).orElse(Env.ZERO);
    }

    public static CustomerBankAccount.Builder convertCustomerBankAccount(MBPBankAccount customerBankAccount) {
        CustomerBankAccount.Builder builder = CustomerBankAccount.newBuilder();
        builder.setCustomerBankAccountUuid(ValueUtil.validateNull(customerBankAccount.getUUID())).setCity(ValueUtil.validateNull(customerBankAccount.getA_City())).setCountry(ValueUtil.validateNull(customerBankAccount.getA_Country())).setEmail(ValueUtil.validateNull(customerBankAccount.getA_EMail())).setDriverLicense(ValueUtil.validateNull(customerBankAccount.getA_Ident_DL())).setSocialSecurityNumber(ValueUtil.validateNull(customerBankAccount.getA_Ident_SSN())).setName(ValueUtil.validateNull(customerBankAccount.getA_Name())).setState(ValueUtil.validateNull(customerBankAccount.getA_State())).setStreet(ValueUtil.validateNull(customerBankAccount.getA_Street())).setZip(ValueUtil.validateNull(customerBankAccount.getA_Zip())).setBankAccountType(ValueUtil.validateNull(customerBankAccount.getBankAccountType()));
        if (customerBankAccount.getC_Bank_ID() > 0) {
            MBank bank = MBank.get((Properties)Env.getCtx(), (int)customerBankAccount.getC_Bank_ID());
            builder.setBankUuid(ValueUtil.validateNull(bank.getUUID()));
        }
        MBPartner customer = MBPartner.get((Properties)Env.getCtx(), (int)customerBankAccount.getC_BPartner_ID());
        builder.setCustomerUuid(ValueUtil.validateNull(customer.getUUID()));
        builder.setAddressVerified(ValueUtil.validateNull(customerBankAccount.getR_AvsAddr())).setZipVerified(ValueUtil.validateNull(customerBankAccount.getR_AvsZip())).setRoutingNo(ValueUtil.validateNull(customerBankAccount.getRoutingNo())).setAccountNo(ValueUtil.validateNull(customerBankAccount.getAccountNo())).setIban(ValueUtil.validateNull(customerBankAccount.getIBAN()));
        return builder;
    }

    public static Shipment.Builder convertShipment(MInOut shipment) {
        Shipment.Builder builder = Shipment.newBuilder();
        if (shipment == null) {
            return builder;
        }
        MRefList reference = MRefList.get((Properties)Env.getCtx(), (int)131, (String)shipment.getDocStatus(), null);
        MOrder order = (MOrder)shipment.getC_Order();
        return builder.setUuid(ValueUtil.validateNull(shipment.getUUID())).setOrderUuid(ValueUtil.validateNull(order.getUUID())).setId(shipment.getM_InOut_ID()).setDocumentType(ConvertUtil.convertDocumentType(MDocType.get((Properties)Env.getCtx(), (int)shipment.getC_DocType_ID()))).setDocumentNo(ValueUtil.validateNull(shipment.getDocumentNo())).setSalesRepresentative(ConvertUtil.convertSalesRepresentative(MUser.get((Properties)Env.getCtx(), (int)shipment.getSalesRep_ID()))).setDocumentStatus(ConvertUtil.convertDocumentStatus(ValueUtil.validateNull(shipment.getDocStatus()), ValueUtil.validateNull(ValueUtil.getTranslation((PO)reference, "Name")), ValueUtil.validateNull(ValueUtil.getTranslation((PO)reference, "Description")))).setWarehouse(ConvertUtil.convertWarehouse(shipment.getM_Warehouse_ID())).setMovementDate(ValueUtil.convertDateToString(shipment.getMovementDate()));
    }

    public static OrderLine.Builder convertOrderLine(MOrderLine orderLine) {
        OrderLine.Builder builder = OrderLine.newBuilder();
        if (orderLine == null) {
            return builder;
        }
        MTax tax = MTax.get((Properties)Env.getCtx(), (int)orderLine.getC_Tax_ID());
        MOrder order = orderLine.getParent();
        MPriceList priceList = MPriceList.get((Properties)Env.getCtx(), (int)order.getM_PriceList_ID(), (String)order.get_TrxName());
        BigDecimal quantityOrdered = orderLine.getQtyOrdered();
        BigDecimal priceListAmount = orderLine.getPriceList();
        BigDecimal priceActualAmount = orderLine.getPriceActual();
        BigDecimal discountRate = orderLine.getDiscount();
        BigDecimal discountAmount = Optional.ofNullable(orderLine.getPriceList()).orElse(Env.ZERO).subtract(Optional.ofNullable(orderLine.getPriceActual()).orElse(Env.ZERO));
        BigDecimal taxAmount = tax.calculateTax(orderLine.getPriceActual(), priceList.isTaxIncluded(), priceList.getStandardPrecision());
        BigDecimal priceListWithTaxAmount = priceListAmount.add(taxAmount);
        BigDecimal priceActualWithTaxmount = priceActualAmount.add(taxAmount);
        BigDecimal totalDiscountAmount = discountAmount.multiply(quantityOrdered);
        BigDecimal totalAmount = orderLine.getLineNetAmt();
        BigDecimal totalBaseAmount = totalAmount.subtract(totalDiscountAmount);
        BigDecimal totalTaxAmount = tax.calculateTax(totalAmount, priceList.isTaxIncluded(), priceList.getStandardPrecision());
        BigDecimal totalBaseAmountWithTax = totalBaseAmount.add(totalTaxAmount);
        BigDecimal totalAmountWithTax = totalAmount.add(totalTaxAmount);
        return builder.setUuid(ValueUtil.validateNull(orderLine.getUUID())).setOrderUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_Order", orderLine.getC_Order_ID()))).setLine(orderLine.getLine()).setDescription(ValueUtil.validateNull(orderLine.getDescription())).setLineDescription(ValueUtil.validateNull(orderLine.getName())).setProduct(ConvertUtil.convertProduct(orderLine.getM_Product_ID())).setCharge(ConvertUtil.convertCharge(orderLine.getC_Charge_ID())).setWarehouse(ConvertUtil.convertWarehouse(orderLine.getM_Warehouse_ID())).setQuantity(ValueUtil.getDecimalFromBigDecimal(quantityOrdered.setScale(priceList.getStandardPrecision(), 4))).setPriceList(ValueUtil.getDecimalFromBigDecimal(priceListAmount.setScale(priceList.getStandardPrecision(), 4))).setPrice(ValueUtil.getDecimalFromBigDecimal(priceActualAmount.setScale(priceList.getStandardPrecision(), 4))).setDiscountAmount(ValueUtil.getDecimalFromBigDecimal(discountAmount.setScale(priceList.getStandardPrecision(), 4))).setDiscountRate(ValueUtil.getDecimalFromBigDecimal(discountRate.setScale(priceList.getStandardPrecision(), 4))).setTaxAmount(ValueUtil.getDecimalFromBigDecimal(taxAmount.setScale(priceList.getStandardPrecision(), 4))).setTaxRate(ConvertUtil.convertTaxRate(tax)).setPriceListWithTax(ValueUtil.getDecimalFromBigDecimal(priceListWithTaxAmount.setScale(priceList.getStandardPrecision(), 4))).setPriceWithTax(ValueUtil.getDecimalFromBigDecimal(priceActualWithTaxmount.setScale(priceList.getStandardPrecision(), 4))).setTotalDiscountAmount(ValueUtil.getDecimalFromBigDecimal(totalDiscountAmount.setScale(priceList.getStandardPrecision(), 4))).setTotalTaxAmount(ValueUtil.getDecimalFromBigDecimal(totalTaxAmount.setScale(priceList.getStandardPrecision(), 4))).setTotalBaseAmount(ValueUtil.getDecimalFromBigDecimal(totalBaseAmount.setScale(priceList.getStandardPrecision(), 4))).setTotalBaseAmountWithTax(ValueUtil.getDecimalFromBigDecimal(totalBaseAmountWithTax.setScale(priceList.getStandardPrecision(), 4))).setTotalAmount(ValueUtil.getDecimalFromBigDecimal(totalAmount.setScale(priceList.getStandardPrecision(), 4))).setTotalAmountWithTax(ValueUtil.getDecimalFromBigDecimal(totalAmountWithTax.setScale(priceList.getStandardPrecision(), 4)));
    }

    public static ShipmentLine.Builder convertShipmentLine(MInOutLine shipmentLine) {
        ShipmentLine.Builder builder = ShipmentLine.newBuilder();
        if (shipmentLine == null) {
            return builder;
        }
        MOrderLine orderLine = (MOrderLine)shipmentLine.getC_OrderLine();
        return builder.setUuid(ValueUtil.validateNull(shipmentLine.getUUID())).setOrderLineUuid(ValueUtil.validateNull(orderLine.getUUID())).setId(shipmentLine.getM_InOutLine_ID()).setLine(shipmentLine.getLine()).setDescription(ValueUtil.validateNull(shipmentLine.getDescription())).setProduct(ConvertUtil.convertProduct(shipmentLine.getM_Product_ID())).setCharge(ConvertUtil.convertCharge(shipmentLine.getC_Charge_ID())).setQuantity(ValueUtil.getDecimalFromBigDecimal(shipmentLine.getMovementQty()));
    }

    public static Product.Builder convertProduct(int productId) {
        Product.Builder builder = Product.newBuilder();
        if (productId <= 0) {
            return builder;
        }
        return ConvertUtil.convertProduct(MProduct.get((Properties)Env.getCtx(), (int)productId));
    }

    public static Charge.Builder convertCharge(int chargeId) {
        Charge.Builder builder = Charge.newBuilder();
        if (chargeId <= 0) {
            return builder;
        }
        return ConvertUtil.convertCharge(MCharge.get((Properties)Env.getCtx(), (int)chargeId));
    }

    public static Warehouse.Builder convertWarehouse(int warehouseId) {
        Warehouse.Builder builder = Warehouse.newBuilder();
        if (warehouseId <= 0) {
            return builder;
        }
        return ConvertUtil.convertWarehouse(MWarehouse.get((Properties)Env.getCtx(), (int)warehouseId));
    }

    public static KeyLayout.Builder convertKeyLayout(int keyLayoutId) {
        KeyLayout.Builder builder = KeyLayout.newBuilder();
        if (keyLayoutId <= 0) {
            return builder;
        }
        return ConvertUtil.convertKeyLayout(MPOSKeyLayout.get((Properties)Env.getCtx(), (int)keyLayoutId));
    }

    public static KeyLayout.Builder convertKeyLayout(MPOSKeyLayout keyLayout) {
        KeyLayout.Builder builder = KeyLayout.newBuilder().setUuid(ValueUtil.validateNull(keyLayout.getUUID())).setId(keyLayout.getC_POSKeyLayout_ID()).setName(ValueUtil.validateNull(keyLayout.getName())).setDescription(ValueUtil.validateNull(keyLayout.getDescription())).setHelp(ValueUtil.validateNull(keyLayout.getHelp())).setLayoutType(ValueUtil.validateNull(keyLayout.getPOSKeyLayoutType())).setColumns(keyLayout.getColumns());
        Arrays.asList(keyLayout.getKeys(false)).stream().filter(key -> key.isActive()).forEach(key -> builder.addKeys(ConvertUtil.convertKey(key)));
        return builder;
    }

    public static Key.Builder convertKey(MPOSKey key) {
        String productValue = null;
        if (key.getM_Product_ID() > 0) {
            productValue = MProduct.get((Properties)Env.getCtx(), (int)key.getM_Product_ID()).getValue();
        }
        return Key.newBuilder().setUuid(ValueUtil.validateNull(key.getUUID())).setId(key.getC_POSKeyLayout_ID()).setName(ValueUtil.validateNull(key.getName())).setSequence(key.getSeqNo()).setSpanX(key.getSpanX()).setSpanY(key.getSpanY()).setSubKeyLayoutUuid(ValueUtil.validateNull(RecordUtil.getUuidFromId("C_POSKeyLayout", key.getSubKeyLayout_ID()))).setQuantity(ValueUtil.getDecimalFromBigDecimal(Optional.ofNullable(key.getQty()).orElse(Env.ZERO))).setProductValue(ValueUtil.validateNull(productValue)).setResourceReference(ConvertUtil.convertResourceReference(RecordUtil.getResourceFromImageId(key.getAD_Image_ID())));
    }

    public static SalesRepresentative.Builder convertSalesRepresentative(MUser salesRepresentative) {
        return SalesRepresentative.newBuilder().setUuid(ValueUtil.validateNull(salesRepresentative.getUUID())).setId(salesRepresentative.getAD_User_ID()).setName(ValueUtil.validateNull(salesRepresentative.getName())).setDescription(ValueUtil.validateNull(salesRepresentative.getDescription()));
    }

    public static Customer.Builder convertCustomer(MBPartner businessPartner) {
        if (businessPartner == null) {
            return Customer.newBuilder();
        }
        Customer.Builder customer = Customer.newBuilder().setUuid(ValueUtil.validateNull(businessPartner.getUUID())).setId(businessPartner.getC_BPartner_ID()).setValue(ValueUtil.validateNull(businessPartner.getValue())).setTaxId(ValueUtil.validateNull(businessPartner.getTaxID())).setDuns(ValueUtil.validateNull(businessPartner.getDUNS())).setNaics(ValueUtil.validateNull(businessPartner.getNAICS())).setName(ValueUtil.validateNull(businessPartner.getName())).setLastName(ValueUtil.validateNull(businessPartner.getName2())).setDescription(ValueUtil.validateNull(businessPartner.getDescription()));
        MTable.get((Properties)Env.getCtx(), (int)businessPartner.get_Table_ID()).getColumnsAsList().stream().map(column -> column.getColumnName()).filter(columnName -> !columnName.equals("UUID") && !columnName.equals("Value") && !columnName.equals("TaxID") && !columnName.equals("DUNS") && !columnName.equals("NAICS") && !columnName.equals("Name") && !columnName.equals("Name2") && !columnName.equals("Description")).forEach(columnName -> customer.putAdditionalAttributes((String)columnName, ValueUtil.getValueFromObject(businessPartner.get_Value(columnName)).build()));
        Arrays.asList(businessPartner.getLocations(true)).stream().filter(customerLocation -> customerLocation.isActive()).forEach(address -> customer.addAddresses(ConvertUtil.convertCustomerAddress(address)));
        return customer;
    }

    public static Address.Builder convertCustomerAddress(MBPartnerLocation businessPartnerLocation) {
        if (businessPartnerLocation == null) {
            return Address.newBuilder();
        }
        MLocation location = businessPartnerLocation.getLocation(true);
        Address.Builder builder = Address.newBuilder().setUuid(ValueUtil.validateNull(businessPartnerLocation.getUUID())).setId(businessPartnerLocation.getC_BPartner_Location_ID()).setPostalCode(ValueUtil.validateNull(location.getPostal())).setAddress1(ValueUtil.validateNull(location.getAddress1())).setAddress2(ValueUtil.validateNull(location.getAddress2())).setAddress3(ValueUtil.validateNull(location.getAddress3())).setAddress4(ValueUtil.validateNull(location.getAddress4())).setPostalCode(ValueUtil.validateNull(location.getPostal())).setDescription(ValueUtil.validateNull(businessPartnerLocation.get_ValueAsString("Description"))).setFirstName(ValueUtil.validateNull(businessPartnerLocation.getName())).setLastName(ValueUtil.validateNull(businessPartnerLocation.get_ValueAsString("Name2"))).setContactName(ValueUtil.validateNull(businessPartnerLocation.get_ValueAsString("ContactName"))).setEmail(ValueUtil.validateNull(businessPartnerLocation.getEMail())).setPhone(ValueUtil.validateNull(businessPartnerLocation.getPhone())).setIsDefaultShipping(businessPartnerLocation.get_ValueAsBoolean("IsDefaultShipping")).setIsDefaultBilling(businessPartnerLocation.get_ValueAsBoolean("IsDefaultBilling"));
        MUser user = (MUser)new Query(Env.getCtx(), "AD_User", "C_BPartner_Location_ID = ?", businessPartnerLocation.get_TrxName()).setParameters(new Object[]{businessPartnerLocation.getC_BPartner_Location_ID()}).setOnlyActiveRecords(true).first();
        String phone = null;
        if (user != null && user.getAD_User_ID() > 0) {
            if (!Util.isEmpty((String)user.getPhone())) {
                phone = user.getPhone();
            }
            if (!Util.isEmpty((String)user.getName()) && Util.isEmpty((String)builder.getContactName())) {
                builder.setContactName(user.getName());
            }
        }
        builder.setPhone(ValueUtil.validateNull(Optional.ofNullable(businessPartnerLocation.getPhone()).orElse(Optional.ofNullable(phone).orElse(""))));
        MCountry country = MCountry.get((Properties)Env.getCtx(), (int)location.getC_Country_ID());
        builder.setCountryCode(ValueUtil.validateNull(country.getCountryCode())).setCountryUuid(ValueUtil.validateNull(country.getUUID())).setCountryId(country.getC_Country_ID());
        if (location.getC_City_ID() > 0) {
            MCity city = MCity.get((Properties)Env.getCtx(), (int)location.getC_City_ID());
            builder.setCity(City.newBuilder().setId(city.getC_City_ID()).setUuid(ValueUtil.validateNull(city.getUUID())).setName(ValueUtil.validateNull(city.getName())));
        } else {
            builder.setCity(City.newBuilder().setName(ValueUtil.validateNull(location.getCity())));
        }
        if (location.getC_Region_ID() > 0) {
            MRegion region = MRegion.get((Properties)Env.getCtx(), (int)location.getC_Region_ID());
            builder.setRegion(Region.newBuilder().setId(region.getC_Region_ID()).setUuid(ValueUtil.validateNull(region.getUUID())).setName(ValueUtil.validateNull(region.getName())));
        }
        MTable.get((Properties)Env.getCtx(), (int)businessPartnerLocation.get_Table_ID()).getColumnsAsList().stream().map(column -> column.getColumnName()).filter(columnName -> !columnName.equals("UUID") && !columnName.equals("Phone") && !columnName.equals("Name")).forEach(columnName -> builder.putAdditionalAttributes((String)columnName, ValueUtil.getValueFromObject(businessPartnerLocation.get_Value(columnName)).build()));
        return builder;
    }

    public static BankAccount.Builder convertBankAccount(MBankAccount bankAccount) {
        BankAccount.Builder builder = BankAccount.newBuilder();
        if (bankAccount == null) {
            return builder;
        }
        return builder.setUuid(ValueUtil.validateNull(bankAccount.getUUID())).setId(bankAccount.getAD_Org_ID()).setAccountNo(ValueUtil.validateNull(bankAccount.getAccountNo())).setName(ValueUtil.validateNull(bankAccount.getName())).setDescription(ValueUtil.validateNull(bankAccount.getDescription())).setIsDefault(bankAccount.isDefault()).setBban(ValueUtil.validateNull(bankAccount.getBBAN())).setIban(ValueUtil.validateNull(bankAccount.getIBAN())).setBankAccountType(bankAccount.getBankAccountType().equals("C") ? BankAccount.BankAccountType.CHECKING : BankAccount.BankAccountType.SAVINGS).setCreditLimit(ValueUtil.getDecimalFromBigDecimal(bankAccount.getCreditLimit())).setCurrentBalance(ValueUtil.getDecimalFromBigDecimal(bankAccount.getCurrentBalance())).setCurrency(ConvertUtil.convertCurrency(MCurrency.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Currency_ID()))).setBusinessPartner(ConvertUtil.convertBusinessPartner(MBPartner.get((Properties)Env.getCtx(), (int)bankAccount.getC_BPartner_ID())));
    }

    public static Organization.Builder convertOrganization(MOrg organization) {
        MOrgInfo organizationInfo = MOrgInfo.get((Properties)Env.getCtx(), (int)organization.getAD_Org_ID(), null);
        AtomicReference<String> corporateImageBranding = new AtomicReference<String>();
        if (organizationInfo.getCorporateBrandingImage_ID() > 0 && AttachmentUtil.getInstance().isValidForClient(organizationInfo.getAD_Client_ID())) {
            MClientInfo clientInfo = MClientInfo.get((Properties)Env.getCtx(), (int)organizationInfo.getAD_Client_ID());
            MADAttachmentReference attachmentReference = MADAttachmentReference.getByImageId((Properties)Env.getCtx(), (int)clientInfo.getFileHandler_ID(), (int)organizationInfo.getCorporateBrandingImage_ID(), null);
            if (attachmentReference != null && attachmentReference.getAD_AttachmentReference_ID() > 0) {
                corporateImageBranding.set(attachmentReference.getValidFileName());
            }
        }
        return Organization.newBuilder().setCorporateBrandingImage(ValueUtil.validateNull((String)corporateImageBranding.get())).setUuid(ValueUtil.validateNull(organization.getUUID())).setId(organization.getAD_Org_ID()).setName(ValueUtil.validateNull(organization.getName())).setDescription(ValueUtil.validateNull(organization.getDescription())).setDuns(ValueUtil.validateNull(organizationInfo.getDUNS())).setTaxId(ValueUtil.validateNull(organizationInfo.getTaxID())).setPhone(ValueUtil.validateNull(organizationInfo.getPhone())).setPhone2(ValueUtil.validateNull(organizationInfo.getPhone2())).setFax(ValueUtil.validateNull(organizationInfo.getFax())).setIsReadOnly(false);
    }

    public static Warehouse.Builder convertWarehouse(MWarehouse warehouse) {
        return Warehouse.newBuilder().setUuid(ValueUtil.validateNull(warehouse.getUUID())).setId(warehouse.getM_Warehouse_ID()).setName(ValueUtil.validateNull(warehouse.getName())).setDescription(ValueUtil.validateNull(warehouse.getDescription()));
    }

    public static ResourceReference.Builder convertResourceReference(MADAttachmentReference reference) {
        if (reference == null) {
            return ResourceReference.newBuilder();
        }
        return ResourceReference.newBuilder().setResourceUuid(ValueUtil.validateNull(reference.getUUID())).setFileName(ValueUtil.validateNull(reference.getValidFileName())).setDescription(ValueUtil.validateNull(reference.getDescription())).setTextMsg(ValueUtil.validateNull(reference.getTextMsg())).setContentType(ValueUtil.validateNull(MimeType.getMimeType((String)reference.getFileName()))).setFileSize(ValueUtil.getDecimalFromBigDecimal(reference.getFileSize()));
    }

    public static Attachment.Builder convertAttachment(MAttachment attachment) {
        if (attachment == null) {
            return Attachment.newBuilder();
        }
        Attachment.Builder builder = Attachment.newBuilder().setAttachmentUuid(ValueUtil.validateNull(attachment.getUUID())).setTitle(ValueUtil.validateNull(attachment.getTitle())).setTextMsg(ValueUtil.validateNull(attachment.getTextMsg()));
        MClientInfo clientInfo = MClientInfo.get((Properties)attachment.getCtx());
        if (clientInfo.getFileHandler_ID() != 0) {
            MADAttachmentReference.getListByAttachmentId((Properties)attachment.getCtx(), (int)clientInfo.getFileHandler_ID(), (int)attachment.getAD_Attachment_ID(), (String)attachment.get_TrxName()).forEach(attachmentReference -> builder.addResourceReferences(ConvertUtil.convertResourceReference(attachmentReference)));
        }
        return builder;
    }

    public static TaxRate.Builder convertTaxRate(MTax tax) {
        return TaxRate.newBuilder().setName(ValueUtil.validateNull(tax.getName())).setDescription(ValueUtil.validateNull(tax.getDescription())).setTaxIndicator(ValueUtil.validateNull(tax.getTaxIndicator())).setRate(ValueUtil.getDecimalFromBigDecimal(tax.getRate()));
    }
}

