/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.util;

import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MCountry;
import org.compiere.model.MLanguage;
import org.compiere.model.MOrg;
import org.compiere.model.MSession;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ContextManager {
    private static CCache<String, Properties> sessionsContext = new CCache("Session-gRPC-Service", 30, 0);
    private static CCache<String, String> languageCache = new CCache("Language-gRPC-Service", 30, 0);
    private static CCache<String, MOrg> organizationCache = new CCache("AD_Org-gRPC-Service", 30, 0);
    private static CCache<String, MWarehouse> warehouseCache = new CCache("M_Warehouse-gRPC-Service", 30, 0);

    public static Properties getContext(String sessionUuid, String language) {
        return ContextManager.getContext(sessionUuid, language, null, null);
    }

    public static Properties getContext(String sessionUuid, String language, String organizationUuid, String warehouseUuid) {
        Properties context = (Properties)sessionsContext.get((Object)sessionUuid);
        if (context != null && context.size() > 0) {
            Env.setContext((Properties)context, (String)"#AD_Language", (String)ContextManager.getDefaultLanguage(language));
            ContextManager.setDefault(context, Env.getAD_Org_ID((Properties)context), organizationUuid, warehouseUuid);
            Env.setCtx((Properties)((Properties)context.clone()));
            return context;
        }
        context = (Properties)Env.getCtx().clone();
        DB.validateSupportedUUIDFromDB();
        MSession session = (MSession)new Query(context, "AD_Session", "UUID = ?", null).setParameters(new Object[]{sessionUuid}).first();
        if (session == null || session.getAD_Session_ID() <= 0) {
            throw new AdempiereException("@AD_Session_ID@ @NotFound@");
        }
        Env.setContext((Properties)context, (String)"#AD_Session_ID", (int)session.getAD_Session_ID());
        Env.setContext((Properties)context, (String)"#AD_User_ID", (int)session.getCreatedBy());
        Env.setContext((Properties)context, (String)"#AD_Role_ID", (int)session.getAD_Role_ID());
        Env.setContext((Properties)context, (String)"#AD_Client_ID", (int)session.getAD_Client_ID());
        ContextManager.setDefault(context, session.getAD_Org_ID(), organizationUuid, warehouseUuid);
        Env.setContext((Properties)context, (String)"#Date", (Timestamp)new Timestamp(System.currentTimeMillis()));
        Env.setContext((Properties)context, (String)"#AD_Language", (String)ContextManager.getDefaultLanguage(language));
        sessionsContext.put((Object)sessionUuid, (Object)context);
        Env.setCtx((Properties)((Properties)context.clone()));
        return context;
    }

    private static void setDefault(Properties context, int defaultOrganizationId, String organizationUuid, String warehouseUuid) {
        int organizationId = defaultOrganizationId;
        if (!Util.isEmpty((String)organizationUuid)) {
            MOrg organization = (MOrg)organizationCache.get((Object)organizationUuid);
            if (organization == null) {
                organization = (MOrg)new Query(context, "AD_Org", "UUID = ?", null).setParameters(new Object[]{organizationUuid}).first();
            }
            if (organization != null) {
                organizationId = organization.getAD_Org_ID();
                organizationCache.put((Object)organizationUuid, (Object)organization);
            }
        }
        if (!Util.isEmpty((String)warehouseUuid)) {
            MWarehouse warehouse = (MWarehouse)warehouseCache.get((Object)warehouseUuid);
            if (warehouse == null) {
                warehouse = (MWarehouse)new Query(context, "M_Warehouse", "UUID = ?", null).setParameters(new Object[]{warehouseUuid}).first();
            }
            if (warehouse != null) {
                warehouseCache.put((Object)warehouseUuid, (Object)warehouse);
                Env.setContext((Properties)context, (String)"#M_Warehouse_ID", (int)organizationId);
            }
        }
        Env.setContext((Properties)context, (String)"#AD_Org_ID", (int)organizationId);
    }

    public static MCountry getDefaultCountry() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MLanguage language = MLanguage.get((Properties)Env.getCtx(), (String)client.getAD_Language());
        MCountry country = MCountry.get((Properties)Env.getCtx(), (String)language.getCountryCode());
        if (country != null) {
            return country;
        }
        return MCountry.getDefault((Properties)Env.getCtx());
    }

    public static String getDefaultLanguage(String language) {
        MClient client = MClient.get((Properties)Env.getCtx());
        String clientLanguage = client.getAD_Language();
        if (!Util.isEmpty((String)clientLanguage) && Util.isEmpty((String)language)) {
            return clientLanguage;
        }
        String defaultLanguage = language;
        if (Util.isEmpty((String)language)) {
            language = "en_US";
        }
        if (language.length() == 2) {
            defaultLanguage = (String)languageCache.get((Object)language);
            if (!Util.isEmpty((String)defaultLanguage)) {
                return defaultLanguage;
            }
            defaultLanguage = DB.getSQLValueString(null, (String)"SELECT AD_Language FROM AD_Language WHERE LanguageISO = ? AND (IsSystemLanguage = 'Y' OR IsBaseLanguage = 'Y')", (Object[])new Object[]{language});
            languageCache.put((Object)language, (Object)defaultLanguage);
        }
        if (Util.isEmpty((String)defaultLanguage)) {
            defaultLanguage = "en_US";
        }
        return defaultLanguage;
    }
}

