/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.setup;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.compiere.db.CConnection;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Ini;
import org.spin.base.setup.Database;
import org.spin.base.setup.Server;
import org.spin.base.setup.SetupWrapper;

public class SetupLoader {
    private static SetupLoader instance;
    private SetupWrapper setup;

    private SetupLoader(String filePath) throws JsonParseException, JsonMappingException, IOException {
        File setupFile = new File(filePath);
        ObjectMapper fileMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.setup = (SetupWrapper)fileMapper.readValue(setupFile, SetupWrapper.class);
    }

    public void validateLoad() throws Exception {
        if (this.setup == null) {
            throw new Exception("Setup not found");
        }
        if (this.setup.getDatabase().getType() == null) {
            throw new Exception("Database Type Not Found");
        }
        if (!this.setup.getDatabase().getType().equals(org.compiere.db.Database.DB_POSTGRESQL) && !this.setup.getDatabase().getType().equals(org.compiere.db.Database.DB_ORACLE)) {
            throw new Exception("Database Type Unsupported");
        }
        if (this.setup.getDatabase().getHost() == null) {
            throw new Exception("Database Host Not Found");
        }
        if (this.setup.getDatabase().getPort() == 0) {
            throw new Exception("Database Port Not Found");
        }
        if (this.setup.getDatabase().getName() == null) {
            throw new Exception("Database Name Not Found");
        }
        if (this.setup.getDatabase().getPassword() == null) {
            throw new Exception("Database Password Not Found");
        }
        CConnection connection = CConnection.get((String)this.setup.getDatabase().getType(), (String)this.setup.getDatabase().getHost(), (int)this.setup.getDatabase().getPort(), (String)this.setup.getDatabase().getName(), (String)this.setup.getDatabase().getUser(), (String)this.setup.getDatabase().getPassword());
        connection.setAppsHost("MyAppsServer");
        connection.setAppsPort(0);
        Ini.setProperty((String)"Connection", (String)connection.toStringLong());
        Ini.setClient((boolean)false);
        Level logLevel = Level.parse(this.setup.getServer().getLog_level().toUpperCase());
        Ini.setProperty((String)"TraceFile", (String)logLevel.getName());
        CLogMgt.setLevel((Level)logLevel);
        DB.setDBTarget((CConnection)connection);
    }

    public final Database getDatabase() {
        return this.setup.getDatabase();
    }

    public final Server getServer() {
        return this.setup.getServer();
    }

    public static SetupLoader getInstance() {
        return instance;
    }

    public static void loadSetup(String filePath) throws JsonParseException, JsonMappingException, IOException {
        instance = new SetupLoader(filePath);
    }
}

