/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.setup;

import java.util.List;
import java.util.logging.Level;

public class Server {
    private String host;
    private int port;
    private String certificate_chain_file;
    private String private_key_file;
    private String trust_certificate_collection_file;
    private String log_level;
    private List<String> services;

    public Server(String host, int port, String certificate_chain_file, String private_key_file, String trust_certificate_collection_file, String log_level, List<String> services) {
        this.host = host;
        this.port = port;
        this.certificate_chain_file = certificate_chain_file;
        this.private_key_file = private_key_file;
        this.trust_certificate_collection_file = trust_certificate_collection_file;
        this.log_level = log_level;
        this.services = services;
        if (this.log_level == null || this.log_level.trim().length() == 0) {
            this.log_level = Level.WARNING.getName();
        }
    }

    public Server() {
        this.log_level = Level.WARNING.getName();
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getCertificate_chain_file() {
        return this.certificate_chain_file;
    }

    public final String getPrivate_key_file() {
        return this.private_key_file;
    }

    public final String getTrust_certificate_collection_file() {
        return this.trust_certificate_collection_file;
    }

    public final boolean isTlsEnabled() {
        return this.getCertificate_chain_file() != null && this.getPrivate_key_file() != null;
    }

    public final List<String> getServices() {
        return this.services;
    }

    public final String getLog_level() {
        return this.log_level;
    }

    public final boolean isValidService(String service) {
        if (service == null || service.trim().length() == 0 || this.services == null) {
            return false;
        }
        return this.getServices().stream().filter(serviceToFind -> serviceToFind != null && serviceToFind.equals(service)).findFirst().isPresent();
    }

    public String toString() {
        return "Server [host=" + this.host + ", port=" + this.port + ", certificate_chain_file=" + this.certificate_chain_file + ", private_key_file=" + this.private_key_file + ", trust_certificate_collection_file=" + this.trust_certificate_collection_file + ", log_level=" + this.log_level + ", services=" + this.services + "]";
    }
}

