/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.terminal;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.support.ITerminal;
import org.spin.support.ITerminalInfo;
import org.spin.util.support.IAppSupport;

public class EDestinos
implements IAppSupport,
ITerminalInfo {
    private int registrationId = 0;
    private String serviceURL = "";
    private int combinations = 0;
    private List<ITerminal> airportList;
    private final String SERVICE_URL_KEY = "SERVICE_URL";
    private final String COMBINATIONS_KEY = "COMBINATIONS";
    private final int DEFAULT_COMBINATIONS = 10;
    private final String SOURCE = "_source";
    private final String IATA_CODE = "code";
    private final String AIRPORT_NAME = "name";
    private final String COUNTRY_CODE = "countryCode";
    private final String COUNTRY_NAME = "countryName";
    private final String CITY_CODE = "cityCode";
    private final String CITY_NAME = "cityName";
    private final String POPULARITY = "popularity";
    private final String SUGGESTION = "suggestion";
    private final String SHORT_SUGGESTION = "short_suggestion";
    private final String LOCATION = "location";
    private final String LATITUDE = "lat";
    private final String LONGITUDE = "lon";
    protected transient CLogger log = CLogger.getCLogger(this.getClass());

    private MADAppRegistration getRegistrationInstance() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        if (Util.isEmpty((String)registration.getParameterValue("SERVICE_URL"))) {
            throw new AdempiereException("SERVICE_URL @NotFound@");
        }
        this.serviceURL = registration.getParameterValue("SERVICE_URL");
        if (!Util.isEmpty((String)registration.getParameterValue("COMBINATIONS"))) {
            try {
                this.combinations = Integer.parseInt(registration.getParameterValue("COMBINATIONS"));
            }
            catch (Exception e) {
                this.log.severe(e.getLocalizedMessage());
            }
        }
        if (this.combinations == 0) {
            this.combinations = 10;
        }
        this.airportList = new ArrayList<ITerminal>();
        return registration;
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public String testConnection() {
        try {
            return "";
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }

    @Override
    public List<ITerminal> getTerminalList() {
        this.getRegistrationInstance();
        this.getCombinationsList().forEach(combinations -> this.requestList((String)combinations));
        return this.airportList;
    }

    private void requestList(String combinations) {
    }

    private List<String> getCombinationsList() {
        int carry;
        ArrayList<String> letters = new ArrayList<String>();
        for (int i = 65; i < 91; ++i) {
            letters.add(String.valueOf((char)i));
        }
        int[] indices = new int[3];
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> combinationsList = new ArrayList<String>();
        int combination = 1;
        do {
            for (int index : indices) {
                buffer.append((String)letters.get(index));
            }
            if (combination >= this.combinations) {
                combinationsList.add(buffer.toString());
                buffer = new StringBuffer();
                combination = 1;
            } else {
                buffer.append(",");
                ++combination;
            }
            carry = 1;
            for (int i = indices.length - 1; i >= 0 && carry != 0; --i) {
                int n = i;
                indices[n] = indices[n] + carry;
                carry = 0;
                if (indices[i] != letters.size()) continue;
                carry = 1;
                indices[i] = 0;
            }
        } while (carry != true);
        return combinationsList;
    }

    @Override
    public String getTerminalType() {
        return "A";
    }
}

