/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCity;
import org.compiere.model.MCountry;
import org.compiere.model.Query;
import org.compiere.util.Util;
import org.spin.model.MTAMTerminal;
import org.spin.support.ITerminal;

public abstract class Terminal
implements ITerminal {
    private String name;
    private String description;
    private String comments;
    private String value;
    private String countryCode;
    private String countryName;
    private String cityCode;
    private String cityName;
    private BigDecimal latitude;
    private BigDecimal longitude;
    private int popularity;

    public Terminal(String value) {
        if (Util.isEmpty((String)value)) {
            throw new AdempiereException("@Value@ @IsMandatory@");
        }
        this.value = value;
    }

    public final Terminal withName(String name) {
        this.name = name;
        return this;
    }

    public final Terminal withDescription(String description) {
        this.description = description;
        return this;
    }

    public final Terminal withComments(String comments) {
        this.comments = comments;
        return this;
    }

    public final Terminal withValue(String value) {
        this.value = value;
        return this;
    }

    public final Terminal withCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public final Terminal withCountryName(String countryName) {
        this.countryName = countryName;
        return this;
    }

    public final Terminal withCityCode(String cityCode) {
        this.cityCode = cityCode;
        return this;
    }

    public final Terminal withCityName(String cityName) {
        this.cityName = cityName;
        return this;
    }

    public final Terminal withLatitude(BigDecimal latitude) {
        this.latitude = latitude;
        return this;
    }

    public final Terminal withLongitude(BigDecimal longitude) {
        this.longitude = longitude;
        return this;
    }

    public final Terminal withPopularity(int popularity) {
        this.popularity = popularity;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getCountryName() {
        return this.countryName;
    }

    @Override
    public String getCityCode() {
        return this.cityCode;
    }

    @Override
    public String getCityName() {
        return this.cityName;
    }

    @Override
    public BigDecimal getLatitude() {
        return this.latitude;
    }

    @Override
    public BigDecimal getLongitude() {
        return this.longitude;
    }

    @Override
    public int getPopularity() {
        return this.popularity;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public MTAMTerminal fillTerminal(Properties context, String trxName) {
        MCountry country;
        MTAMTerminal terminal = this.getTerminal(context, trxName);
        if (terminal == null || terminal.getTAM_Terminal_ID() == 0) {
            terminal = new MTAMTerminal(context, 0, trxName);
        }
        if (!Util.isEmpty((String)this.getValue())) {
            terminal.setValue(this.getValue());
        }
        if (!Util.isEmpty((String)this.getName())) {
            terminal.setName(this.getName());
        }
        if (!Util.isEmpty((String)this.getDescription())) {
            terminal.setDescription(this.getDescription());
        }
        int countryId = 0;
        if (!Util.isEmpty((String)this.getCountryCode()) && (country = MCountry.get((Properties)context, (String)this.getCountryCode().toUpperCase())) != null) {
            countryId = country.getC_Country_ID();
            terminal.setC_Country_ID(countryId);
        }
        if (!Util.isEmpty((String)this.getCityName())) {
            MCity city;
            terminal.setCity(this.getCityName());
            if (countryId > 0 && (city = (MCity)new Query(context, "C_City", "C_Country_ID = ? AND UPPER(TRIM(Name)) = UPPER(TRIM(?))", trxName).setParameters(new Object[]{countryId, this.getCityName()}).setOnlyActiveRecords(true).first()) != null && city.getC_City_ID() > 0) {
                terminal.setC_City_ID(city.getC_City_ID());
            }
        }
        if (this.getLatitude() != null) {
            terminal.setLatitude(this.getLatitude());
        }
        if (this.getLongitude() != null) {
            terminal.setLongitude(this.getLongitude());
        }
        terminal.setPopularity(new BigDecimal(this.getPopularity()));
        return terminal;
    }

    public String toString() {
        return "Terminal [name=" + this.name + ", description=" + this.description + ", comments=" + this.comments + ", value=" + this.value + ", countryCode=" + this.countryCode + ", countryName=" + this.countryName + ", cityCode=" + this.cityCode + ", cityName=" + this.cityName + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", popularity=" + this.popularity + "]";
    }
}

