/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support;

import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.Util;
import org.spin.model.MTAMTerminal;
import org.spin.support.IAirport;
import org.spin.support.Terminal;

public class Airport
extends Terminal
implements IAirport {
    private String iataCode;
    private String icaoCode;

    public Airport(String iataCode) {
        super(iataCode);
        this.iataCode = iataCode;
    }

    public final Airport withIataCode(String iataCode) {
        this.iataCode = iataCode;
        return this;
    }

    public final Airport withIcaoCode(String icaoCode) {
        this.icaoCode = icaoCode;
        return this;
    }

    @Override
    public String getIataCode() {
        return this.iataCode;
    }

    @Override
    public String getIcaoCode() {
        return this.icaoCode;
    }

    @Override
    public MTAMTerminal fillTerminal(Properties context, String trxName) {
        MTAMTerminal airport = super.fillTerminal(context, trxName);
        if (!Util.isEmpty((String)this.getIataCode())) {
            airport.setIATACode(this.getIataCode());
        }
        if (!Util.isEmpty((String)this.getIcaoCode())) {
            airport.setICAOCode(this.getIcaoCode());
        }
        return airport;
    }

    @Override
    public String toString() {
        return "Airport [iataCode=" + this.iataCode + ", icaoCode=" + this.icaoCode + ", getName()=" + this.getName() + "]";
    }

    @Override
    public MTAMTerminal getTerminal(Properties context, String trxName) {
        return (MTAMTerminal)new Query(context, "TAM_Terminal", "IATACode = ? AND TerminalType = ?", trxName).setParameters(new Object[]{this.getIataCode(), "A"}).setClient_ID().first();
    }
}

