/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.X_C_InvoiceLine;
import org.spin.process.InvoiceCreateFromTicketAbstract;

public class InvoiceCreateFromTicket
extends InvoiceCreateFromTicketAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
    }

    protected String doIt() throws Exception {
        AtomicInteger created = new AtomicInteger();
        AtomicInteger line = new AtomicInteger(10);
        MInvoice invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        Optional<MInvoiceLine> maybeInvoiceLine = Arrays.asList(invoice.getLines()).stream().sorted(Comparator.comparing(X_C_InvoiceLine::getLine).reversed()).findFirst();
        if (maybeInvoiceLine.isPresent()) {
            line.set(maybeInvoiceLine.get().getLine());
        }
        this.getSelectionKeys().forEach(key -> {
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.set_ValueOfColumn("TAM_Ticket_ID", key);
            invoiceLine.setLine(line.addAndGet(10));
            invoiceLine.saveEx();
            created.addAndGet(1);
        });
        return "@Created@: " + created.get();
    }
}

