/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model.validator;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MTAMTax;
import org.spin.model.MTAMTerminal;
import org.spin.model.MTAMTicket;
import org.spin.model.MTAMTicketLine;
import org.spin.model.MTAMTicketTax;
import org.spin.model.MTAMTicketType;
import org.spin.model.MTAMTicketTypeTax;
import org.spin.util.travel.Travel;

public class TravelAgencyManagement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(TravelAgencyManagement.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        MInvoiceLine invoiceLine;
        if (type == 1 || type == 2) {
            MInvoiceLine invoiceLine2;
            if (entity.get_Table_ID() == I_C_InvoiceLine.Table_ID && (invoiceLine2 = (MInvoiceLine)entity).is_ValueChanged("TAM_Ticket_ID") && invoiceLine2.get_ValueAsInt("TAM_Ticket_ID") != 0 && !invoiceLine2.get_ValueAsBoolean("IsTicketTax")) {
                int ticketId = invoiceLine2.get_ValueAsInt("TAM_Ticket_ID");
                MTAMTicket ticket = new MTAMTicket(invoiceLine2.getCtx(), ticketId, invoiceLine2.get_TrxName());
                MTAMTicketType ticketType = MTAMTicketType.getById(invoiceLine2.getCtx(), ticket.getTAM_TicketType_ID(), invoiceLine2.get_TrxName());
                if (!ticketType.isInvoiced()) {
                    throw new AdempiereException("@CannotInvoiceTicketType@: @TAM_TicketType_ID@: " + ticketType.getValue() + " - " + ticketType.getName());
                }
                invoiceLine2.setM_Product_ID(ticketType.getM_Product_ID());
                invoiceLine2.setQty(Env.ONE);
                if (ticketType.isTaxIncluded()) {
                    invoiceLine2.setPrice(ticket.getGrandTotal());
                } else {
                    invoiceLine2.setPrice(ticket.getAmount());
                }
                MBPartner traveler = MBPartner.get((Properties)ticket.getCtx(), (int)ticket.getTraveler_ID());
                String travelerName = traveler.getName() + (Util.isEmpty((String)traveler.getName2()) ? "" : " " + traveler.getName());
                StringBuffer invoiceLineDescription = new StringBuffer();
                invoiceLineDescription.append(Travel.getMessageWithParameters(invoiceLine2.getCtx(), "TicketTypeInvoiceLineMessage", ticket.getDocumentNo(), ticket.getDateDoc(), traveler.getValue(), travelerName));
                List<MTAMTicketLine> ticketLines = ticket.getLines(true);
                if (ticketLines == null || ticketLines.size() == 0) {
                    MTAMTerminal departurePlace = MTAMTerminal.getById(invoiceLine2.getCtx(), ticket.getDeparturePlace_ID(), invoiceLine2.get_TrxName());
                    MTAMTerminal arrivalPlace = MTAMTerminal.getById(invoiceLine2.getCtx(), ticket.getArrivalPlace_ID(), invoiceLine2.get_TrxName());
                    invoiceLineDescription.append(Env.NL);
                    invoiceLineDescription.append(Travel.getMessageWithParameters(invoiceLine2.getCtx(), "TicketTypeInvoiceLineTripMessage", departurePlace.getName(), arrivalPlace.getName(), ticket.getDepartureDate(), ticket.getReturnDate()));
                } else {
                    ticketLines.forEach(ticketLine -> {
                        MTAMTerminal departurePlace = MTAMTerminal.getById(invoiceLine2.getCtx(), ticket.getDeparturePlace_ID(), invoiceLine2.get_TrxName());
                        MTAMTerminal arrivalPlace = MTAMTerminal.getById(invoiceLine2.getCtx(), ticket.getArrivalPlace_ID(), invoiceLine2.get_TrxName());
                        String tripLineText = Travel.getMessageWithParameters(invoiceLine2.getCtx(), "TicketTypeInvoiceLineTripMessage", departurePlace.getName(), arrivalPlace.getName(), ticket.getDepartureDate(), ticket.getReturnDate());
                        invoiceLineDescription.append(Env.NL);
                        invoiceLineDescription.append(tripLineText);
                    });
                }
                invoiceLine2.addDescription(invoiceLineDescription.toString());
                invoiceLine2.setTax();
                invoiceLine2.setLineNetAmt();
                AtomicInteger line2 = new AtomicInteger(invoiceLine2.getLine());
                if (!ticketType.isTaxIncluded()) {
                    StringBuffer taxNames = new StringBuffer();
                    AtomicReference<BigDecimal> ticketTaxAmount = new AtomicReference<BigDecimal>(Env.ZERO);
                    List<MTAMTicketTax> ticketTaxList = ticket.getTaxes(false);
                    ticketTaxList.forEach(ticketTax -> {
                        MTAMTax tax = MTAMTax.getById(invoiceLine2.getCtx(), ticketTax.getTAM_Tax_ID(), invoiceLine2.get_TrxName());
                        MTAMTicketTypeTax ticketTypeTax = ticketType.getTicketTypeTaxFromTaxId(tax.getTAM_Tax_ID());
                        if (ticketTypeTax.isSplitTaxOnInvoice()) {
                            MInvoiceLine invoiceTaxLine = new MInvoiceLine(invoiceLine2.getParent());
                            invoiceTaxLine.set_ValueOfColumn("TAM_Ticket_ID", (Object)ticketId);
                            invoiceTaxLine.set_ValueOfColumn("TAM_TicketTypeTax_ID", (Object)ticketTax.getTAM_TicketTax_ID());
                            invoiceTaxLine.set_ValueOfColumn("IsTicketTax", (Object)true);
                            invoiceTaxLine.setC_Charge_ID(ticketTypeTax.getInvoiceCharge_ID());
                            invoiceTaxLine.setQty(Env.ONE);
                            if (tax.isCalculated()) {
                                invoiceTaxLine.setPrice(ticketTax.getTaxBaseAmt());
                                invoiceTaxLine.setC_Tax_ID(tax.getC_Tax_ID());
                            } else {
                                invoiceTaxLine.setPrice(ticket.getTaxAmt());
                                invoiceTaxLine.setTax();
                            }
                            invoiceTaxLine.setLine(line2.addAndGet(10));
                            invoiceTaxLine.addDescription(Travel.getMessageWithParameters(invoiceLine2.getCtx(), "TicketTypeTaxInvoiceLineSplitMessage", tax.getTaxIndicator() + " - " + tax.getName(), Util.isEmpty((String)ticketTypeTax.getDescription()) ? "" : ticketTypeTax.getDescription()));
                            invoiceTaxLine.setLineNetAmt();
                            invoiceTaxLine.saveEx();
                        } else {
                            ticketTaxAmount.updateAndGet(amount -> amount.add(ticketTax.getTaxAmt()));
                            if (taxNames.length() > 0) {
                                taxNames.append(Env.NL);
                            }
                            taxNames.append(tax.getTaxIndicator() + " - " + tax.getName());
                        }
                    });
                    if (!ticketTaxAmount.get().equals(Env.ZERO)) {
                        MInvoiceLine invoiceTaxLine = new MInvoiceLine(invoiceLine2.getParent());
                        invoiceTaxLine.set_ValueOfColumn("TAM_Ticket_ID", (Object)ticketId);
                        invoiceTaxLine.set_ValueOfColumn("IsTicketTax", (Object)true);
                        invoiceTaxLine.setC_Charge_ID(ticketType.getInvoiceCharge_ID());
                        invoiceTaxLine.setQty(Env.ONE);
                        invoiceTaxLine.setPrice(ticketTaxAmount.get());
                        invoiceTaxLine.setLine(line2.addAndGet(10));
                        invoiceTaxLine.addDescription(Travel.getMessageWithParameters(invoiceLine2.getCtx(), "TicketTypeTaxInvoiceLineMessage", taxNames.toString()));
                        invoiceTaxLine.setTax();
                        invoiceTaxLine.setLineNetAmt();
                        invoiceTaxLine.saveEx();
                    }
                }
            }
        } else if (type == 6 && (invoiceLine = (MInvoiceLine)entity).get_ValueAsInt("TAM_Ticket_ID") != 0) {
            MTAMTicket ticket = new MTAMTicket(invoiceLine.getCtx(), invoiceLine.get_ValueAsInt("TAM_Ticket_ID"), invoiceLine.get_TrxName());
            List<MInvoiceLine> linesToDelete = this.getLinesFromTicketId(invoiceLine.getCtx(), invoiceLine.getC_Invoice_ID(), ticket.getTAM_Ticket_ID(), invoiceLine.get_TrxName());
            if (linesToDelete != null) {
                linesToDelete.forEach(line -> line.deleteEx(true));
            }
        }
        return null;
    }

    private List<MInvoiceLine> getLinesFromTicketId(Properties context, int invoiceId, int ticketId, String transactionName) {
        return new Query(context, "C_InvoiceLine", "C_Invoice_ID = ? AND TAM_Ticket_ID = ?", transactionName).setParameters(new Object[]{invoiceId, ticketId}).list();
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 7) {
            // empty if block
        }
        return null;
    }
}

