/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.spin.model.X_TAM_Traveler;
import org.spin.util.travel.Travel;

public class MTAMTraveler
extends X_TAM_Traveler {
    private static final long serialVersionUID = 5448641333159848635L;

    public MTAMTraveler(Properties ctx, int travelerId, String trxName) {
        super(ctx, travelerId, trxName);
    }

    public MTAMTraveler(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getExpirationDate().compareTo(new Timestamp(System.currentTimeMillis())) <= 0) {
            throw new AdempiereException(Travel.getMessageWithParameters(this.getCtx(), "TravelerDocumentExpired", new Timestamp(System.currentTimeMillis()), this.getExpirationDate()));
        }
        if (this.getExpirationDate().compareTo(this.getIssueDate()) <= 0) {
            throw new AdempiereException(Travel.getMessageWithParameters(this.getCtx(), "TravelerDocumentInvalid", this.getIssueDate(), this.getExpirationDate()));
        }
        this.setIsValid(true);
        return super.beforeSave(newRecord);
    }

    public static MTAMTraveler getValidTravelerFromBusinessPartner(Properties context, int businessPartnerId, String trxName) {
        return (MTAMTraveler)new Query(context, "TAM_Traveler", "C_BPartner_ID = ? AND IsValid = 'Y'", trxName).setParameters(new Object[]{businessPartnerId}).setOrderBy("ExpirationDate DESC").first();
    }
}

