/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.model.X_TAM_TravelReason;

public class MTAMTravelReason
extends X_TAM_TravelReason {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MTAMTravelReason> travelReasonCacheIds = new CCache("TAM_TravelReason", 30);
    private static CCache<String, MTAMTravelReason> travelReasonCodes = new CCache("TAM_TravelReason", 30);

    public MTAMTravelReason(Properties ctx, int travelReasonId, String trxName) {
        super(ctx, travelReasonId, trxName);
    }

    public MTAMTravelReason(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MTAMTravelReason getById(Properties ctx, int taxId, String trxName) {
        if (taxId <= 0) {
            return null;
        }
        MTAMTravelReason travelReason = (MTAMTravelReason)travelReasonCacheIds.get((Object)taxId);
        if (travelReason != null && travelReason.get_ID() > 0) {
            return travelReason;
        }
        travelReason = (MTAMTravelReason)new Query(ctx, "TAM_TravelReason", "TAM_TravelReason_ID=?", trxName).setParameters(new Object[]{taxId}).first();
        if (travelReason != null && travelReason.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + travelReason.getValue();
            travelReasonCodes.put((Object)key, (Object)travelReason);
            travelReasonCacheIds.put((Object)travelReason.get_ID(), (Object)travelReason);
        }
        return travelReason;
    }

    public static MTAMTravelReason getByValue(Properties ctx, String value, String trxName) {
        String key;
        MTAMTravelReason travelReason;
        if (value == null) {
            return null;
        }
        if (travelReasonCodes.size() == 0) {
            MTAMTravelReason.getAll(ctx, true, trxName);
        }
        if ((travelReason = (MTAMTravelReason)travelReasonCodes.get((Object)(key = value))) != null && travelReason.get_ID() > 0) {
            return travelReason;
        }
        travelReason = (MTAMTravelReason)new Query(ctx, "TAM_TravelReason", "Value=?", trxName).setParameters(new Object[]{value}).first();
        if (travelReason != null && travelReason.get_ID() > 0) {
            travelReasonCodes.put((Object)key, (Object)travelReason);
            travelReasonCacheIds.put((Object)travelReason.get_ID(), (Object)travelReason);
        }
        return travelReason;
    }

    public static List<MTAMTravelReason> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || travelReasonCacheIds.size() > 0) {
            List travelReasonList = new Query(Env.getCtx(), "TAM_TravelReason", null, trxName).setClient_ID().setOrderBy("Name").list();
            travelReasonList.stream().forEach(airport -> {
                String key = airport.getValue();
                travelReasonCacheIds.put((Object)airport.getTAM_TravelReason_ID(), airport);
                travelReasonCodes.put((Object)key, airport);
            });
            return travelReasonList;
        }
        List<MTAMTravelReason> travelReasonList = travelReasonCacheIds.entrySet().stream().map(applicationType -> (MTAMTravelReason)applicationType.getValue()).collect(Collectors.toList());
        return travelReasonList;
    }

    @Override
    public String toString() {
        return "MTAMTravelReason [getName()=" + this.getName() + ", getTAM_TravelReason_ID()=" + this.getTAM_TravelReason_ID() + ", getValue()=" + this.getValue() + "]";
    }
}

