/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.model.X_TAM_TicketTypeTax;

public class MTAMTicketTypeTax
extends X_TAM_TicketTypeTax {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MTAMTicketTypeTax> ticketTypeaTaxCacheIds = new CCache("TAM_TicketTypeTax", 30);

    public MTAMTicketTypeTax(Properties ctx, int ticketTypeTaxId, String trxName) {
        super(ctx, ticketTypeTaxId, trxName);
    }

    public MTAMTicketTypeTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MTAMTicketTypeTax getById(Properties ctx, int taxId, String trxName) {
        if (taxId <= 0) {
            return null;
        }
        MTAMTicketTypeTax ticketType = (MTAMTicketTypeTax)ticketTypeaTaxCacheIds.get((Object)taxId);
        if (ticketType != null && ticketType.get_ID() > 0) {
            return ticketType;
        }
        ticketType = (MTAMTicketTypeTax)new Query(ctx, "TAM_TicketTypeTax", "TAM_TicketTypeTax_ID=?", trxName).setParameters(new Object[]{taxId}).first();
        if (ticketType != null && ticketType.get_ID() > 0) {
            ticketTypeaTaxCacheIds.put((Object)ticketType.get_ID(), (Object)ticketType);
        }
        return ticketType;
    }

    public static List<MTAMTicketTypeTax> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || ticketTypeaTaxCacheIds.size() > 0) {
            List ticketTypeList = new Query(Env.getCtx(), "TAM_TicketTypeTax", null, trxName).setClient_ID().list();
            ticketTypeList.stream().forEach(airport -> ticketTypeaTaxCacheIds.put((Object)airport.getTAM_TicketTypeTax_ID(), airport));
            return ticketTypeList;
        }
        List<MTAMTicketTypeTax> ticketTypeList = ticketTypeaTaxCacheIds.entrySet().stream().map(applicationType -> (MTAMTicketTypeTax)applicationType.getValue()).collect(Collectors.toList());
        return ticketTypeList;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("IsSplitTaxOnInvoice") && !this.isSplitTaxOnInvoice()) {
            this.setInvoiceCharge_ID(-1);
        }
        return super.beforeSave(newRecord);
    }

    @Override
    public String toString() {
        return "MTAMTicketTypeTax [getDescription()=" + this.getDescription() + ", getTAM_Tax_ID()=" + this.getTAM_Tax_ID() + ", getTAM_TicketTypeTax_ID()=" + this.getTAM_TicketTypeTax_ID() + "]";
    }
}

