/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.model.MTAMTicketTypeTax;
import org.spin.model.X_TAM_TicketType;

public class MTAMTicketType
extends X_TAM_TicketType {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MTAMTicketType> ticketTypeCacheIds = new CCache("TAM_TicketType", 30);
    private static CCache<String, MTAMTicketType> ticketTypeCodes = new CCache("TAM_TicketType", 30);
    private List<MTAMTicketTypeTax> taxesList = null;

    public MTAMTicketType(Properties ctx, int ticketTypeId, String trxName) {
        super(ctx, ticketTypeId, trxName);
    }

    public MTAMTicketType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getLineDescription(String message, Object ... parameters) {
        return Msg.getMsg((Properties)this.getCtx(), (String)message, (Object[])parameters);
    }

    public static MTAMTicketType getById(Properties ctx, int taxId, String trxName) {
        if (taxId <= 0) {
            return null;
        }
        MTAMTicketType ticketType = (MTAMTicketType)ticketTypeCacheIds.get((Object)taxId);
        if (ticketType != null && ticketType.get_ID() > 0) {
            return ticketType;
        }
        ticketType = (MTAMTicketType)new Query(ctx, "TAM_TicketType", "TAM_TicketType_ID=?", trxName).setParameters(new Object[]{taxId}).first();
        if (ticketType != null && ticketType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + ticketType.getValue();
            ticketTypeCodes.put((Object)key, (Object)ticketType);
            ticketTypeCacheIds.put((Object)ticketType.get_ID(), (Object)ticketType);
        }
        return ticketType;
    }

    public static MTAMTicketType getByValue(Properties ctx, String value, String trxName) {
        String key;
        MTAMTicketType ticketType;
        if (value == null) {
            return null;
        }
        if (ticketTypeCodes.size() == 0) {
            MTAMTicketType.getAll(ctx, true, trxName);
        }
        if ((ticketType = (MTAMTicketType)ticketTypeCodes.get((Object)(key = value))) != null && ticketType.get_ID() > 0) {
            return ticketType;
        }
        ticketType = (MTAMTicketType)new Query(ctx, "TAM_TicketType", "Value=?", trxName).setParameters(new Object[]{value}).first();
        if (ticketType != null && ticketType.get_ID() > 0) {
            ticketTypeCodes.put((Object)key, (Object)ticketType);
            ticketTypeCacheIds.put((Object)ticketType.get_ID(), (Object)ticketType);
        }
        return ticketType;
    }

    public static List<MTAMTicketType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || ticketTypeCacheIds.size() > 0) {
            List ticketTypeList = new Query(Env.getCtx(), "TAM_TicketType", null, trxName).setClient_ID().setOrderBy("Name").list();
            ticketTypeList.stream().forEach(airport -> {
                String key = airport.getValue();
                ticketTypeCacheIds.put((Object)airport.getTAM_TicketType_ID(), airport);
                ticketTypeCodes.put((Object)key, airport);
            });
            return ticketTypeList;
        }
        List<MTAMTicketType> ticketTypeList = ticketTypeCacheIds.entrySet().stream().map(applicationType -> (MTAMTicketType)applicationType.getValue()).collect(Collectors.toList());
        return ticketTypeList;
    }

    public List<MTAMTicketTypeTax> getTaxes(boolean requery) {
        if (this.taxesList == null || requery) {
            this.taxesList = new Query(this.getCtx(), "TAM_TicketTypeTax", "TAM_TicketType_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getTAM_TicketType_ID()}).setOnlyActiveRecords(true).list();
        }
        return this.taxesList;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("IsTaxIncluded") || this.is_ValueChanged("IsSplitTaxOnInvoice")) {
            if (this.isTaxIncluded() || this.isSplitTaxOnInvoice()) {
                this.setInvoiceCharge_ID(-1);
            }
            if (this.isTaxIncluded()) {
                this.setIsSplitTaxOnInvoice(false);
            }
            if (this.isSplitTaxOnInvoice()) {
                this.setIsTaxIncluded(false);
            }
        }
        return super.beforeSave(newRecord);
    }

    @Override
    public void setIsSplitTaxOnInvoice(boolean isSplitTaxOnInvoice) {
        super.setIsSplitTaxOnInvoice(isSplitTaxOnInvoice);
        this.getTaxes(true).forEach(ticketTypeTax -> {
            ticketTypeTax.setIsSplitTaxOnInvoice(isSplitTaxOnInvoice);
            ticketTypeTax.saveEx();
        });
    }

    public MTAMTicketTypeTax getTicketTypeTaxFromTaxId(int taxId) {
        this.getTaxes(false);
        if (this.taxesList == null) {
            return null;
        }
        Optional<MTAMTicketTypeTax> maybeTax = this.taxesList.stream().filter(tax -> tax.getTAM_Tax_ID() == taxId).findFirst();
        if (!maybeTax.isPresent()) {
            return null;
        }
        return maybeTax.get();
    }

    @Override
    public String toString() {
        return "MTAMTicketType [isInvoiced()=" + this.isInvoiced() + ", getName()=" + this.getName() + ", getTAM_TicketType_ID()=" + this.getTAM_TicketType_ID() + ", getValue()=" + this.getValue() + "]";
    }
}

