/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.spin.model.MTAMTicket;
import org.spin.model.X_TAM_TicketTax;

public class MTAMTicketTax
extends X_TAM_TicketTax {
    private static final long serialVersionUID = 5448641333159848635L;
    private MTAMTicket parent = null;

    public MTAMTicketTax(Properties ctx, int ticketTaxId, String trxName) {
        super(ctx, ticketTaxId, trxName);
    }

    public MTAMTicketTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTAMTicketTax(MTAMTicket parent) {
        super(parent.getCtx(), 0, parent.get_TrxName());
        this.setTAM_Ticket_ID(parent.getTAM_Ticket_ID());
    }

    public MTAMTicket getParent() {
        if (this.parent == null) {
            this.parent = new MTAMTicket(this.getCtx(), this.getTAM_Ticket_ID(), this.get_TrxName());
        }
        return this.parent;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeaderTax();
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeaderTax();
    }

    private boolean updateHeaderTax() {
        if (this.getParent().isProcessed()) {
            return false;
        }
        AtomicReference<BigDecimal> taxAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        this.getParent().getTaxes(true).forEach(tax -> taxAmount.updateAndGet(amount -> amount.add(tax.getTaxAmt())));
        int updated = DB.executeUpdateEx((String)"UPDATE TAM_Ticket SET TaxAmt = ?, GrandTotal = (Amount + ?)  WHERE TAM_Ticket_ID = ?", (Object[])new Object[]{taxAmount.get(), taxAmount.get(), this.getTAM_Ticket_ID()}, (String)this.get_TrxName());
        this.parent = null;
        this.log.fine("Header updated = " + updated);
        return true;
    }

    @Override
    public String toString() {
        return "MTAMTicketTax [getDescription()=" + this.getDescription() + ", getTAM_TicketTax_ID()=" + this.getTAM_TicketTax_ID() + ", getTaxAmt()=" + this.getTaxAmt() + "]";
    }
}

