/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.model.MTAMTax;
import org.spin.model.MTAMTicketLine;
import org.spin.model.MTAMTicketTax;
import org.spin.model.MTAMTicketType;
import org.spin.model.MTAMTicketTypeTax;
import org.spin.model.MTAMTraveler;
import org.spin.model.X_TAM_Ticket;

public class MTAMTicket
extends X_TAM_Ticket
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20200717L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private List<MTAMTicketTax> taxesList = null;
    private List<MTAMTicketLine> linesList = null;

    public MTAMTicket(Properties ctx, int TAM_Ticket_ID, String trxName) {
        super(ctx, TAM_Ticket_ID, trxName);
    }

    public MTAMTicket(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public List<MTAMTicketTax> getTaxes(boolean requery) {
        if (this.taxesList == null || requery) {
            this.taxesList = new Query(this.getCtx(), "TAM_TicketTax", "TAM_Ticket_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getTAM_Ticket_ID()}).list();
        }
        return this.taxesList;
    }

    public List<MTAMTicketLine> getLines(boolean requery) {
        if (this.linesList == null || requery) {
            this.linesList = new Query(this.getCtx(), "TAM_TicketLine", "TAM_Ticket_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getTAM_Ticket_ID()}).list();
        }
        return this.linesList;
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        MTAMTraveler traveler;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.getTAM_Traveler_ID() == 0 && (traveler = MTAMTraveler.getValidTravelerFromBusinessPartner(this.getCtx(), this.getTraveler_ID(), this.get_TrxName())) != null && traveler.getTAM_Traveler_ID() > 0) {
            this.setTAM_Traveler_ID(traveler.getTAM_Traveler_ID());
            this.saveEx();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        this.getTaxes(true);
        if (this.taxesList != null) {
            this.taxesList.forEach(tax -> {
                tax.setProcessed(processed);
                tax.saveEx();
            });
        }
        this.getLines(true);
        if (this.linesList != null) {
            this.linesList.forEach(line -> {
                line.setProcessed(processed);
                line.saveEx();
            });
        }
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        MTAMTicketType ticketType;
        if (this.isProcessed()) {
            return true;
        }
        if ((newRecord || this.is_ValueChanged("TAM_TicketType_ID")) && (ticketType = MTAMTicketType.getById(this.getCtx(), this.getTAM_TicketType_ID(), this.get_TrxName())).isGenerateTax()) {
            List<MTAMTicketTypeTax> taxesList;
            this.getTaxes(true);
            if (this.taxesList != null) {
                this.taxesList.forEach(tax -> tax.deleteEx(true));
            }
            if ((taxesList = ticketType.getTaxes(true)) != null) {
                taxesList.forEach(ticketTypeTax -> {
                    MTAMTicketTax ticketTax = new MTAMTicketTax(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)ticketTypeTax, (PO)ticketTax);
                    ticketTax.setTAM_Ticket_ID(this.getTAM_Ticket_ID());
                    MTAMTax tax = MTAMTax.getById(this.getCtx(), ticketTax.getTAM_Tax_ID(), this.get_TrxName());
                    if (tax.isCalculated() && tax.getC_Tax_ID() != 0) {
                        MTax referencedTax = MTax.get((Properties)this.getCtx(), (int)tax.getC_Tax_ID());
                        ticketTax.setTaxBaseAmt(this.getAmount());
                        ticketTax.setTaxAmt(this.getAmount().multiply(referencedTax.getRate()).divide(Env.ONEHUNDRED));
                    } else {
                        ticketTax.setTaxBaseAmt(Env.ZERO);
                        ticketTax.setTaxAmt(Env.ZERO);
                    }
                    ticketTax.setIsCalculated(tax.isCalculated());
                    ticketTax.saveEx();
                });
            }
        }
        if (newRecord) {
            MTAMTicketLine departatureLine = new MTAMTicketLine(this);
            departatureLine.setDeparturePlace_ID(this.getDeparturePlace_ID());
            departatureLine.setArrivalPlace_ID(this.getArrivalPlace_ID());
            departatureLine.setDepartureTime(this.getDepartureDate() != null ? this.getDepartureDate() : this.getDateDoc());
            departatureLine.setArrivalTime(this.getDepartureDate() != null ? this.getDepartureDate() : this.getDateDoc());
            departatureLine.setLine(10);
            departatureLine.saveEx();
            if (this.isRoundTrip()) {
                MTAMTicketLine returnLine = new MTAMTicketLine(this);
                returnLine.setDeparturePlace_ID(this.getArrivalPlace_ID());
                returnLine.setArrivalPlace_ID(this.getDeparturePlace_ID());
                returnLine.setDepartureTime(this.getReturnDate() != null ? this.getReturnDate() : this.getDateDoc());
                returnLine.setArrivalTime(this.getReturnDate() != null ? this.getReturnDate() : this.getDateDoc());
                returnLine.setLine(20);
                returnLine.saveEx();
            }
        }
        return true;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isProcessed()) {
            return super.beforeSave(newRecord);
        }
        if (this.is_ValueChanged("TaxAmt") || this.is_ValueChanged("Amount")) {
            BigDecimal amount = this.getAmount();
            BigDecimal taxAmount = this.getTaxAmt();
            if (amount == null) {
                amount = Env.ZERO;
            }
            if (taxAmount == null) {
                taxAmount = Env.ZERO;
            }
            this.setGrandTotal(amount.add(taxAmount));
            if (this.is_ValueChanged("Amount")) {
                this.recalculateTaxes();
            }
        }
        return super.beforeSave(newRecord);
    }

    private void recalculateTaxes() {
        this.getTaxes(true).forEach(ticketTax -> {
            MTAMTax tax = MTAMTax.getById(this.getCtx(), ticketTax.getTAM_Tax_ID(), this.get_TrxName());
            if (tax.isCalculated() && tax.getC_Tax_ID() != 0) {
                MTax referencedTax = MTax.get((Properties)this.getCtx(), (int)tax.getC_Tax_ID());
                ticketTax.setTaxBaseAmt(this.getAmount());
                ticketTax.setTaxAmt(this.getAmount().multiply(referencedTax.getRate()).divide(Env.ONEHUNDRED));
                ticketTax.saveEx();
            }
        });
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    @Override
    public String toString() {
        return "MTAMTicket [getDescription()=" + this.getDescription() + ", getDocumentNo()=" + this.getDocumentNo() + ", getTAM_Ticket_ID()=" + this.getTAM_Ticket_ID() + "]";
    }
}

