/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.model.X_TAM_Terminal;

public class MTAMTerminal
extends X_TAM_Terminal {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MTAMTerminal> terminalCacheIds = new CCache("TAM_Terminal", 30);
    private static CCache<String, MTAMTerminal> terminalCodes = new CCache("TAM_Terminal", 30);

    public MTAMTerminal(Properties ctx, int terminalId, String trxName) {
        super(ctx, terminalId, trxName);
    }

    public MTAMTerminal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MTAMTerminal getById(Properties ctx, int terminalId, String trxName) {
        if (terminalId <= 0) {
            return null;
        }
        MTAMTerminal airport = (MTAMTerminal)terminalCacheIds.get((Object)terminalId);
        if (airport != null && airport.get_ID() > 0) {
            return airport;
        }
        airport = (MTAMTerminal)new Query(ctx, "TAM_Terminal", "TAM_Terminal_ID=?", trxName).setParameters(new Object[]{terminalId}).first();
        if (airport != null && airport.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + airport.getValue();
            terminalCodes.put((Object)key, (Object)airport);
            terminalCacheIds.put((Object)airport.get_ID(), (Object)airport);
        }
        return airport;
    }

    public static MTAMTerminal getByValue(Properties ctx, String value, String trxName) {
        String key;
        MTAMTerminal airport;
        if (value == null) {
            return null;
        }
        if (terminalCodes.size() == 0) {
            MTAMTerminal.getAll(ctx, true, trxName);
        }
        if ((airport = (MTAMTerminal)terminalCodes.get((Object)(key = value))) != null && airport.get_ID() > 0) {
            return airport;
        }
        airport = (MTAMTerminal)new Query(ctx, "TAM_Terminal", "Value=?", trxName).setParameters(new Object[]{value}).first();
        if (airport != null && airport.get_ID() > 0) {
            terminalCodes.put((Object)key, (Object)airport);
            terminalCacheIds.put((Object)airport.get_ID(), (Object)airport);
        }
        return airport;
    }

    public static List<MTAMTerminal> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || terminalCacheIds.size() > 0) {
            List airportList = new Query(Env.getCtx(), "TAM_Terminal", null, trxName).setClient_ID().setOrderBy("Name").list();
            airportList.stream().forEach(airport -> {
                String key = airport.getValue();
                terminalCacheIds.put((Object)airport.getTAM_Terminal_ID(), airport);
                terminalCodes.put((Object)key, airport);
            });
            return airportList;
        }
        List<MTAMTerminal> airportList = terminalCacheIds.entrySet().stream().map(applicationType -> (MTAMTerminal)applicationType.getValue()).collect(Collectors.toList());
        return airportList;
    }

    @Override
    public String toString() {
        return "MTAMTerminal [getName()=" + this.getName() + ", getTAM_Terminal_ID()=" + this.getTAM_Terminal_ID() + ", getTerminalType()=" + this.getTerminalType() + ", getValue()=" + this.getValue() + "]";
    }
}

