/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.model.X_TAM_Tax;

public class MTAMTax
extends X_TAM_Tax {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MTAMTax> taxCacheIds = new CCache("TAM_Tax", 30);
    private static CCache<String, MTAMTax> taxCodes = new CCache("TAM_Tax", 30);

    public MTAMTax(Properties ctx, int taxId, String trxName) {
        super(ctx, taxId, trxName);
    }

    public MTAMTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MTAMTax getById(Properties ctx, int taxId, String trxName) {
        if (taxId <= 0) {
            return null;
        }
        MTAMTax tax = (MTAMTax)taxCacheIds.get((Object)taxId);
        if (tax != null && tax.get_ID() > 0) {
            return tax;
        }
        tax = (MTAMTax)new Query(ctx, "TAM_Tax", "TAM_Tax_ID=?", trxName).setParameters(new Object[]{taxId}).first();
        if (tax != null && tax.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + tax.getTaxIndicator();
            taxCodes.put((Object)key, (Object)tax);
            taxCacheIds.put((Object)tax.get_ID(), (Object)tax);
        }
        return tax;
    }

    public static MTAMTax getByTaxIndicator(Properties ctx, String value, String trxName) {
        String key;
        MTAMTax tax;
        if (value == null) {
            return null;
        }
        if (taxCodes.size() == 0) {
            MTAMTax.getAll(ctx, true, trxName);
        }
        if ((tax = (MTAMTax)taxCodes.get((Object)(key = value))) != null && tax.get_ID() > 0) {
            return tax;
        }
        tax = (MTAMTax)new Query(ctx, "TAM_Tax", "TaxIndicator=?", trxName).setParameters(new Object[]{value}).first();
        if (tax != null && tax.get_ID() > 0) {
            taxCodes.put((Object)key, (Object)tax);
            taxCacheIds.put((Object)tax.get_ID(), (Object)tax);
        }
        return tax;
    }

    public static List<MTAMTax> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || taxCacheIds.size() > 0) {
            List taxList = new Query(Env.getCtx(), "TAM_Tax", null, trxName).setClient_ID().setOrderBy("Name").list();
            taxList.stream().forEach(airport -> {
                String key = airport.getTaxIndicator();
                taxCacheIds.put((Object)airport.getTAM_Tax_ID(), airport);
                taxCodes.put((Object)key, airport);
            });
            return taxList;
        }
        List<MTAMTax> taxList = taxCacheIds.entrySet().stream().map(applicationType -> (MTAMTax)applicationType.getValue()).collect(Collectors.toList());
        return taxList;
    }

    @Override
    public String toString() {
        return "MTAMTax [getC_Tax_ID()=" + this.getC_Tax_ID() + ", isCalculated()=" + this.isCalculated() + ", getName()=" + this.getName() + ", getTAM_Tax_ID()=" + this.getTAM_Tax_ID() + ", getTaxIndicator()=" + this.getTaxIndicator() + "]";
    }
}

