/*
 * Decompiled with CFR 0.152.
 */
package org.spin.retail.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCurrency;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductPO;
import org.compiere.model.MProductPrice;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Tax;
import org.compiere.process.M_PriceList_Create;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;

public class ProductSetupUtil {
    public static final String COLUMNNAME_IsAddDiscountAutomatically = "IsAddDiscountAutomatically";
    public static final String COLUMNNAME_SODefaultPriceList_ID = "SODefaultPriceList_ID";
    public static final String COLUMNNAME_PODefaultPriceList_ID = "PODefaultPriceList_ID";
    public static final String COLUMNNAME_DiscountBasePrice = "DiscountBasePrice";
    public static final String COLUMNNAME_DiscountFinalPrice = "DiscountFinalPrice";
    public static final String COLUMNNAME_DefaultListVersionSchema_ID = "DefaultListVersionSchema_ID";
    public static final String COLUMNNAME_DefaultDiscountSchema_ID = "DefaultDiscountSchema_ID";
    public static final String COLUMNNAME_DiscountBasePricePO = "DiscountBasePricePO";
    public static final String COLUMNNAME_DiscountTax_ID = "DiscountTax_ID";
    public static final String COLUMNNAME_DiscountTotalAmount = "DiscountTotalAmount";
    public static final String COLUMNNAME_DiscountTaxAmount = "DiscountTaxAmount";
    public static final String COLUMNNAME_DiscountMargin = "DiscountMargin";
    public static final String COLUMNNAME_DiscountPricePO = "DiscountPricePO";
    public static final String COLUMNNAME_BasePricePO = "BasePricePO";
    public static final String COLUMNNAME_FreightRatePO = "FreightRatePO";
    public static final String COLUMNNAME_ReplenishRatePO = "ReplenishRatePO";
    public static final String COLUMNNAME_MarketingRatePO = "MarketingRatePO";

    public static void setDefaultPriceListFromProductCategory(MProduct product) {
        if (product == null) {
            return;
        }
        MProductCategory productCategory = MProductCategory.get((Properties)product.getCtx(), (int)product.getM_Product_Category_ID());
        if (product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID) == 0 && productCategory.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID) > 0) {
            product.set_ValueOfColumn(COLUMNNAME_SODefaultPriceList_ID, (Object)productCategory.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID));
        }
        if (product.get_ValueAsInt(COLUMNNAME_PODefaultPriceList_ID) == 0 && productCategory.get_ValueAsInt(COLUMNNAME_PODefaultPriceList_ID) > 0) {
            product.set_ValueOfColumn(COLUMNNAME_PODefaultPriceList_ID, (Object)productCategory.get_ValueAsInt(COLUMNNAME_PODefaultPriceList_ID));
        }
    }

    public static void addProductToValidPriceListVersion(MProduct product) {
        MPriceList salesPriceList;
        MPriceList purchasePriceList;
        if (product.get_ValueAsInt(COLUMNNAME_PODefaultPriceList_ID) <= 0 && product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID) <= 0) {
            return;
        }
        Timestamp now = TimeUtil.getDay((long)System.currentTimeMillis());
        if (product.get_ValueAsInt(COLUMNNAME_PODefaultPriceList_ID) > 0 && (purchasePriceList = MPriceList.get((Properties)product.getCtx(), (int)product.get_ValueAsInt(COLUMNNAME_PODefaultPriceList_ID), (String)product.get_TrxName())) != null) {
            List<MProductPrice> productPrices;
            Optional maybeProductPrice;
            MPriceListVersion purchasePriceListVersion = purchasePriceList.getPriceListVersion(now);
            if (purchasePriceListVersion == null) {
                purchasePriceListVersion = new MPriceListVersion(purchasePriceList);
                if (purchasePriceList.get_ValueAsInt(COLUMNNAME_DefaultListVersionSchema_ID) > 0) {
                    purchasePriceListVersion.setM_Pricelist_Version_Base_ID(purchasePriceList.get_ValueAsInt(COLUMNNAME_DefaultListVersionSchema_ID));
                }
                if (purchasePriceList.get_ValueAsInt(COLUMNNAME_DefaultDiscountSchema_ID) > 0) {
                    purchasePriceListVersion.setM_DiscountSchema_ID(purchasePriceList.get_ValueAsInt(COLUMNNAME_DefaultDiscountSchema_ID));
                }
                purchasePriceListVersion.setValidFrom(now);
                purchasePriceListVersion.setName();
                purchasePriceListVersion.saveEx();
            }
            if (!(maybeProductPrice = (productPrices = Arrays.asList(purchasePriceListVersion.getProductPrice(" AND M_Product_ID = " + product.getM_Product_ID()))).stream().findAny()).isPresent()) {
                List<MProductPO> productPOs = Arrays.asList(MProductPO.getOfProduct((Properties)product.getCtx(), (int)product.getM_Product_ID(), (String)product.get_TrxName()));
                Optional<MProductPO> maybePurchase = productPOs.stream().filter(purchaseProduct -> purchaseProduct.getC_Currency_ID() == purchasePriceList.getC_Currency_ID() && purchaseProduct.isActive() && purchaseProduct.isCurrentVendor()).findFirst();
                MProductPrice productPrice = null;
                productPrice = maybePurchase.isPresent() ? new MProductPrice(product.getCtx(), purchasePriceListVersion.getM_PriceList_Version_ID(), product.getM_Product_ID(), maybePurchase.get().getPriceList(), maybePurchase.get().getPricePO(), maybePurchase.get().getPricePO(), product.get_TrxName()) : new MProductPrice(product.getCtx(), purchasePriceListVersion.getM_PriceList_Version_ID(), product.getM_Product_ID(), Env.ZERO, Env.ZERO, Env.ZERO, product.get_TrxName());
                productPrice.saveEx();
            }
        }
        if (product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID) > 0 && (salesPriceList = MPriceList.get((Properties)product.getCtx(), (int)product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID), (String)product.get_TrxName())) != null) {
            ProcessInfo processInformation;
            MPriceListVersion salesPriceListVersion = salesPriceList.getPriceListVersion(now);
            if (salesPriceListVersion == null) {
                salesPriceListVersion = new MPriceListVersion(salesPriceList);
                if (salesPriceList.get_ValueAsInt(COLUMNNAME_DefaultListVersionSchema_ID) > 0) {
                    salesPriceListVersion.setM_Pricelist_Version_Base_ID(salesPriceList.get_ValueAsInt(COLUMNNAME_DefaultListVersionSchema_ID));
                }
                if (salesPriceList.get_ValueAsInt(COLUMNNAME_DefaultDiscountSchema_ID) > 0) {
                    salesPriceListVersion.setM_DiscountSchema_ID(salesPriceList.get_ValueAsInt(COLUMNNAME_DefaultDiscountSchema_ID));
                }
                salesPriceListVersion.setValidFrom(now);
                salesPriceListVersion.setName();
                salesPriceListVersion.saveEx();
            }
            if ((processInformation = ProcessBuilder.create((Properties)product.getCtx()).process(Integer.valueOf(M_PriceList_Create.getProcessId())).withoutTransactionClose().withRecordId(Integer.valueOf(MPriceListVersion.Table_ID), Integer.valueOf(salesPriceListVersion.getM_PriceList_Version_ID())).withParameter("M_Product_ID", (Object)product.getM_Product_ID()).withParameter("DeleteOld", (Object)false).execute(product.get_TrxName())).isError()) {
                throw new AdempiereException(processInformation.getSummary());
            }
        }
    }

    public static void setDiscountSchemaBreakFromCategory(MProduct product) {
        if (product == null) {
            return;
        }
        MProductCategory productCategory = MProductCategory.get((Properties)product.getCtx(), (int)product.getM_Product_Category_ID());
        if (productCategory.get_ValueAsBoolean(COLUMNNAME_IsAddDiscountAutomatically)) {
            ProductSetupUtil.addProductToValidPriceListVersion(product);
            List<MDiscountSchemaBreak> discountForThisProduct = ProductSetupUtil.getDiscountSchemaBreakFromProduct(product);
            MProductPrice salesProductPrice = ProductSetupUtil.getSalesProductPriceFromProduct(product);
            AtomicReference<BigDecimal> priceStandard = new AtomicReference<BigDecimal>(Env.ZERO);
            if (salesProductPrice != null) {
                priceStandard.set(Optional.ofNullable(salesProductPrice.getPriceStd()).orElse(Env.ZERO));
            }
            MProductPO purchaseProduct = ProductSetupUtil.getPurchaseProduct(product);
            discountForThisProduct.stream().filter(discountSchemaBreak -> Optional.ofNullable(discountSchemaBreak.getBreakValue()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0).forEach(discountSchemaBreak -> discountSchemaBreak.delete(true));
            List<MDiscountSchemaBreak> discountForThisProductCategory = ProductSetupUtil.getDiscountSchemaBreakFromProductCategory(productCategory);
            discountForThisProductCategory.stream().filter(discountSchemaBreak -> Optional.ofNullable(discountSchemaBreak.getBreakValue()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0).forEach(discountSchemaBreak -> {
                MDiscountSchemaBreak productDiscountSchemaBreak = new MDiscountSchemaBreak(product.getCtx(), 0, product.get_TrxName());
                PO.copyValues((PO)discountSchemaBreak, (PO)productDiscountSchemaBreak, (boolean)true);
                BigDecimal basePrice = Optional.ofNullable(priceStandard.get()).orElse(Env.ZERO);
                BigDecimal purchasePrice = Env.ZERO;
                BigDecimal purchaseBasePrice = Env.ZERO;
                if (purchaseProduct != null) {
                    purchasePrice = Optional.ofNullable(purchaseProduct.getPricePO()).orElse(Env.ZERO);
                    purchaseBasePrice = Optional.ofNullable((BigDecimal)purchaseProduct.get_Value(COLUMNNAME_BasePricePO)).orElse(Env.ZERO);
                }
                productDiscountSchemaBreak.setM_Product_Category_ID(-1);
                productDiscountSchemaBreak.setM_Product_ID(product.getM_Product_ID());
                productDiscountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountBasePrice, (Object)basePrice);
                productDiscountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountPricePO, (Object)purchasePrice);
                productDiscountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountBasePricePO, (Object)purchaseBasePrice);
                productDiscountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountMargin, (Object)ProductSetupUtil.getDiscount(basePrice, purchasePrice));
                productDiscountSchemaBreak.saveEx();
            });
        }
    }

    public static MProductPO getPurchaseProduct(MProduct product) {
        Optional<MProductPO> purchasedProduct = Arrays.asList(MProductPO.getOfProduct((Properties)product.getCtx(), (int)product.getM_Product_ID(), (String)product.get_TrxName())).stream().filter(purchase -> !purchase.isDiscontinued()).sorted(Comparator.comparing(PO::getUpdated).reversed()).findFirst();
        if (purchasedProduct.isPresent()) {
            return purchasedProduct.get();
        }
        return null;
    }

    private static BigDecimal getAmountWithRate(BigDecimal baseAmount, BigDecimal rate) {
        baseAmount = Optional.ofNullable(baseAmount).orElse(Env.ZERO);
        rate = Optional.ofNullable(rate).orElse(Env.ZERO);
        return baseAmount.add(baseAmount.multiply(rate).divide(Env.ONEHUNDRED, MathContext.DECIMAL128));
    }

    private static BigDecimal getPurchasePriceFromRates(BigDecimal baseAmount, BigDecimal freightRate, BigDecimal replenishRate, BigDecimal marketingRate) {
        BigDecimal completeRate = Optional.ofNullable(freightRate).orElse(Env.ZERO).add(Optional.ofNullable(replenishRate).orElse(Env.ZERO)).add(Optional.ofNullable(marketingRate).orElse(Env.ZERO));
        return ProductSetupUtil.getAmountWithRate(baseAmount, completeRate);
    }

    public static void setPurchasePriceFromRates(MProductPO purchaseProduct) {
        BigDecimal basePurchasePrice = purchaseProduct.getPricePO();
        BigDecimal freightRate = (BigDecimal)purchaseProduct.get_Value(COLUMNNAME_FreightRatePO);
        BigDecimal replenishRate = (BigDecimal)purchaseProduct.get_Value(COLUMNNAME_ReplenishRatePO);
        BigDecimal marketingRate = (BigDecimal)purchaseProduct.get_Value(COLUMNNAME_MarketingRatePO);
        if (purchaseProduct.is_ValueChanged("PricePO") || purchaseProduct.get_Value(COLUMNNAME_BasePricePO) == null) {
            purchaseProduct.set_ValueOfColumn(COLUMNNAME_BasePricePO, (Object)basePurchasePrice);
        }
        BigDecimal basePrice = Optional.ofNullable((BigDecimal)purchaseProduct.get_Value(COLUMNNAME_BasePricePO)).orElse(Env.ZERO);
        purchaseProduct.setPricePO(ProductSetupUtil.getPurchasePriceFromRates(basePrice, freightRate, replenishRate, marketingRate).setScale(MCurrency.getStdPrecision((Properties)purchaseProduct.getCtx(), (int)purchaseProduct.getC_Currency_ID()), 4));
    }

    public static void updateSalesPriceListFromPurchaseProduct(MProductPO purchaseProduct) {
        if (purchaseProduct == null) {
            return;
        }
        MProduct product = (MProduct)purchaseProduct.getM_Product();
        MProductCategory productCategory = MProductCategory.get((Properties)product.getCtx(), (int)product.getM_Product_Category_ID());
        if (productCategory.get_ValueAsBoolean(COLUMNNAME_IsAddDiscountAutomatically)) {
            ProductSetupUtil.addProductToValidPriceListVersion(product);
        }
    }

    public static void updateDiscountSchemaBreakFromSalesPriceList(MProductPrice productPrice) {
        MProductPrice salesProductPrice;
        if (productPrice == null) {
            return;
        }
        MProduct product = (MProduct)productPrice.getM_Product();
        MProductCategory productCategory = MProductCategory.get((Properties)product.getCtx(), (int)product.getM_Product_Category_ID());
        if (productCategory.get_ValueAsBoolean(COLUMNNAME_IsAddDiscountAutomatically) && (salesProductPrice = ProductSetupUtil.getSalesProductPriceFromProduct(product)) != null) {
            MProductPO purchaseProduct = ProductSetupUtil.getPurchaseProduct(product);
            List<MDiscountSchemaBreak> discountForThisProduct = ProductSetupUtil.getDiscountSchemaBreakFromProduct(product);
            discountForThisProduct.stream().filter(discountSchemaBreak -> Optional.ofNullable(discountSchemaBreak.getBreakValue()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0).forEach(discountSchemaBreak -> {
                BigDecimal basePrice = Optional.ofNullable(salesProductPrice.getPriceStd()).orElse(Env.ZERO);
                BigDecimal purchasePrice = Env.ZERO;
                BigDecimal purchaseBasePrice = Env.ZERO;
                if (purchaseProduct != null) {
                    purchasePrice = Optional.ofNullable(purchaseProduct.getPricePO()).orElse(Env.ZERO);
                    purchaseBasePrice = Optional.ofNullable((BigDecimal)purchaseProduct.get_Value(COLUMNNAME_BasePricePO)).orElse(Env.ZERO);
                }
                discountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountBasePrice, (Object)basePrice);
                discountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountPricePO, (Object)purchasePrice);
                discountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountBasePricePO, (Object)purchaseBasePrice);
                discountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountMargin, (Object)ProductSetupUtil.getDiscount(basePrice, purchasePrice));
                discountSchemaBreak.saveEx();
            });
        }
    }

    private static MProductPrice getSalesProductPriceFromProduct(MProduct product) {
        if (product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID) > 0) {
            MPriceList salesPriceList = MPriceList.get((Properties)product.getCtx(), (int)product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID), (String)product.get_TrxName());
            salesPriceList.set_TrxName(product.get_TrxName());
            if (salesPriceList != null) {
                List<MProductPrice> productPrices;
                Optional maybeProductPrice;
                Timestamp now = TimeUtil.getDay((long)System.currentTimeMillis());
                MPriceListVersion salesPriceListVersion = salesPriceList.getPriceListVersion(now);
                salesPriceListVersion.set_TrxName(product.get_TrxName());
                if (salesPriceListVersion != null && (maybeProductPrice = (productPrices = Arrays.asList(salesPriceListVersion.getProductPrice(" AND M_Product_ID = " + product.getM_Product_ID()))).stream().findAny()).isPresent()) {
                    return (MProductPrice)maybeProductPrice.get();
                }
            }
        }
        return null;
    }

    public static List<MDiscountSchemaBreak> getDiscountSchemaBreakFromProduct(MProduct product) {
        return new Query(product.getCtx(), "M_DiscountSchemaBreak", "M_Product_ID = ?", product.get_TrxName()).setParameters(new Object[]{product.getM_Product_ID()}).setOnlyActiveRecords(true).list();
    }

    public static List<MDiscountSchemaBreak> getDiscountSchemaBreakFromProductCategory(MProductCategory productCategory) {
        return new Query(productCategory.getCtx(), "M_DiscountSchemaBreak", "M_Product_Category_ID = ?", productCategory.get_TrxName()).setParameters(new Object[]{productCategory.getM_Product_Category_ID()}).setOnlyActiveRecords(true).list();
    }

    public static void calculateTax(MDiscountSchemaBreak discountSchemaBreak) {
        MProduct product;
        MTax tax;
        BigDecimal basePrice = Optional.ofNullable((BigDecimal)discountSchemaBreak.get_Value(COLUMNNAME_DiscountFinalPrice)).orElse(Env.ZERO);
        BigDecimal taxAmount = Env.ZERO;
        BigDecimal totalAmount = Env.ZERO;
        int taxId = -1;
        int precision = MCurrency.getStdPrecision((Properties)discountSchemaBreak.getCtx(), (int)Env.getContextAsInt((Properties)discountSchemaBreak.getCtx(), (String)"$C_Currency_ID"));
        boolean isIncluded = false;
        if (discountSchemaBreak.getM_Product_ID() > 0 && (tax = ProductSetupUtil.getDefaultTax((product = MProduct.get((Properties)discountSchemaBreak.getCtx(), (int)discountSchemaBreak.getM_Product_ID())).getC_TaxCategory_ID())) != null) {
            if (product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID) > 0) {
                MPriceList salesPriceList = MPriceList.get((Properties)product.getCtx(), (int)product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID), (String)product.get_TrxName());
                precision = salesPriceList.getPricePrecision();
                isIncluded = salesPriceList.isTaxIncluded();
            }
            if (!isIncluded) {
                taxAmount = tax.calculateTax(basePrice, isIncluded, precision);
            }
            totalAmount = basePrice.add(taxAmount);
            taxId = tax.getC_Tax_ID();
        }
        discountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountTaxAmount, (Object)taxAmount);
        discountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountTotalAmount, (Object)totalAmount);
        discountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountTax_ID, (Object)taxId);
    }

    private static MTax getDefaultTax(int taxCategoryId) {
        Optional<MTax> optionalTax = Arrays.asList(MTax.getAll((Properties)Env.getCtx())).stream().filter(tax -> {
            if (!tax.isActive()) {
                return false;
            }
            if (tax.getC_TaxCategory_ID() != taxCategoryId) {
                return false;
            }
            if (!Util.isEmpty((String)tax.getSOPOType()) && tax.getSOPOType().equals("P")) {
                return false;
            }
            if (!Util.isEmpty((String)tax.getSOPOType()) && tax.getSOPOType().equals("S")) {
                return true;
            }
            if (!Util.isEmpty((String)tax.getSOPOType()) && tax.getSOPOType().equals("B")) {
                return true;
            }
            return tax.isSalesTax();
        }).sorted(Comparator.comparing(X_C_Tax::getValidFrom).reversed()).findFirst();
        if (optionalTax.isPresent()) {
            return optionalTax.get();
        }
        return null;
    }

    public static BigDecimal getFinalPrice(BigDecimal basePrice, BigDecimal discount, int precision) {
        basePrice = Optional.ofNullable(basePrice).orElse(Env.ZERO);
        discount = Optional.ofNullable(discount).orElse(Env.ZERO);
        BigDecimal multiplier = Env.ONE.subtract(discount.divide(Env.ONEHUNDRED, MathContext.DECIMAL128));
        BigDecimal finalPrice = basePrice.multiply(multiplier);
        finalPrice = finalPrice.setScale(precision, 4);
        return finalPrice;
    }

    public static BigDecimal getDiscount(BigDecimal basePrice, BigDecimal finalPrice) {
        finalPrice = Optional.ofNullable(finalPrice).orElse(Env.ZERO);
        basePrice = Optional.ofNullable(basePrice).orElse(Env.ZERO);
        BigDecimal discount = Env.ZERO;
        if (basePrice.compareTo(Env.ZERO) != 0) {
            discount = basePrice.subtract(finalPrice);
            discount = discount.divide(basePrice, MathContext.DECIMAL128);
            discount = discount.multiply(Env.ONEHUNDRED);
        }
        if (discount.scale() > 2) {
            discount = discount.setScale(2, 4);
        }
        return discount;
    }

    public static void calculateAmount(MDiscountSchemaBreak discountSchemaBreak) {
        if (discountSchemaBreak.getM_Product_ID() > 0 && (discountSchemaBreak.is_new() || discountSchemaBreak.is_ValueChanged("BreakDiscount") || discountSchemaBreak.is_ValueChanged(COLUMNNAME_DiscountBasePrice) || discountSchemaBreak.is_ValueChanged(COLUMNNAME_DiscountFinalPrice))) {
            MPriceList priceList;
            MProduct product = MProduct.get((Properties)discountSchemaBreak.getCtx(), (int)discountSchemaBreak.getM_Product_ID());
            AtomicInteger precision = new AtomicInteger(2);
            if (product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID) > 0 && (priceList = MPriceList.get((Properties)discountSchemaBreak.getCtx(), (int)product.get_ValueAsInt(COLUMNNAME_SODefaultPriceList_ID), (String)discountSchemaBreak.get_TrxName())) != null) {
                precision.set(priceList.getPricePrecision());
            }
            BigDecimal basePrice = Optional.ofNullable((BigDecimal)discountSchemaBreak.get_Value(COLUMNNAME_DiscountBasePrice)).orElse(Env.ZERO);
            BigDecimal discount = Optional.ofNullable(discountSchemaBreak.getBreakDiscount()).orElse(Env.ZERO);
            BigDecimal priceList2 = Optional.ofNullable((BigDecimal)discountSchemaBreak.get_Value(COLUMNNAME_DiscountFinalPrice)).orElse(Env.ZERO);
            if (discountSchemaBreak.is_ValueChanged(COLUMNNAME_DiscountBasePrice) || discountSchemaBreak.is_ValueChanged("BreakDiscount")) {
                discountSchemaBreak.set_ValueOfColumn(COLUMNNAME_DiscountFinalPrice, (Object)ProductSetupUtil.getFinalPrice(basePrice, discount, precision.get()));
            } else if (discountSchemaBreak.is_ValueChanged(COLUMNNAME_DiscountFinalPrice)) {
                discountSchemaBreak.setBreakDiscount(ProductSetupUtil.getDiscount(basePrice, priceList2));
            }
            ProductSetupUtil.calculateTax(discountSchemaBreak);
        }
    }
}

