/*
 * Decompiled with CFR 0.152.
 */
package org.spin.retail.process;

import java.util.Arrays;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.util.Util;
import org.spin.retail.process.ProductUnlockFromInventoryAbstract;
import org.spin.retail.util.ProductStorageUtil;

public class ProductUnlockFromInventory
extends ProductUnlockFromInventoryAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        return this.createInventoryUnlock();
    }

    private String createInventoryUnlock() {
        MInventory inventoryLock = new MInventory(this.getCtx(), this.getInventoryId(), this.get_TrxName());
        List<MInventoryLine> lines = Arrays.asList(inventoryLock.getLines(true));
        if (lines.size() > 1) {
            throw new AdempiereException("@Invalid@ @M_Inventory_ID@");
        }
        if (!Util.isEmpty((String)this.getDescription())) {
            inventoryLock.setDescription(this.getDescription());
        }
        inventoryLock.setMovementDate(this.getDateDoc());
        inventoryLock.setDocStatus("DR");
        inventoryLock.saveEx();
        MInventoryLine inventoryLine = (MInventoryLine)lines.stream().findAny().get();
        if (this.getAttributeSetInstance() > 0) {
            inventoryLine.setM_AttributeSetInstance_ID(this.getAttributeSetInstance());
        }
        if (!Util.isEmpty((String)this.getDescription())) {
            inventoryLine.setDescription(this.getDescription());
        }
        inventoryLine.setQtyCount(this.getQtyCount());
        ProductStorageUtil.setQuantityBook(inventoryLine);
        inventoryLine.saveEx();
        if (!inventoryLock.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + inventoryLock.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + inventoryLock.getDocumentInfo());
        }
        inventoryLock.saveEx();
        return "@Created@: " + inventoryLock.getDocumentNo();
    }
}

