/*
 * Decompiled with CFR 0.152.
 */
package org.spin.retail.process;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.exceptions.NoBPartnerLinkedforOrgException;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.spin.retail.process.ProductMovementAbstract;

public class ProductMovement
extends ProductMovementAbstract {
    private MLocator defaultCurrentLocator;
    private MLocator defaultLocatorTo;

    @Override
    protected void prepare() {
        super.prepare();
        this.defaultCurrentLocator = this.getCurrenLocatorId() > 0 ? MLocator.get((Properties)this.getCtx(), (int)this.getCurrenLocatorId()) : MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId()).getDefaultLocator();
        this.defaultLocatorTo = this.getLocatorToMoveId() > 0 ? MLocator.get((Properties)this.getCtx(), (int)this.getLocatorToMoveId()) : MWarehouse.get((Properties)this.getCtx(), (int)this.getWarehouseToMoveId()).getDefaultLocator();
        if (this.defaultCurrentLocator == null) {
            throw new AdempiereException("@ECA29_CurrenLocator_ID@ @NotFound@");
        }
        if (this.defaultLocatorTo == null) {
            throw new AdempiereException("@ECA29_LocatorToMove_ID@ @NotFound@");
        }
    }

    protected String doIt() throws Exception {
        if (this.isCreateDistribution()) {
            return this.createDistributionOrder();
        }
        return this.createMovement();
    }

    private String createDistributionOrder() {
        MWarehouse currentWarehouse = MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId());
        List<MWarehouse> transitWarehouse = Arrays.asList(MWarehouse.getInTransitForOrg((Properties)this.getCtx(), (int)currentWarehouse.getAD_Org_ID()));
        if (transitWarehouse.isEmpty()) {
            throw new AdempiereException("@M_Warehouse_ID@ @IsInTransit@ @NotFound@");
        }
        int warehouseId = ((MWarehouse)transitWarehouse.stream().findFirst().get()).get_ID();
        MLocator defaultLocator = MWarehouse.get((Properties)this.getCtx(), (int)warehouseId).getDefaultLocator();
        if (defaultLocator == null) {
            throw new AdempiereException("@M_Locator_ID@ @IsIntransit@ @NotFounds@");
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)currentWarehouse.getAD_Org_ID());
        int partnerId = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (partnerId <= 0) {
            throw new NoBPartnerLinkedforOrgException(org);
        }
        MBPartner partner = MBPartner.get((Properties)this.getCtx(), (int)partnerId);
        MDDOrder distributionOrder = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
        distributionOrder.setAD_Org_ID(currentWarehouse.getAD_Org_ID());
        distributionOrder.setC_BPartner_ID(partnerId);
        if (!Util.isEmpty((String)this.getDescription())) {
            distributionOrder.setDescription(this.getDescription());
        } else {
            distributionOrder.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@"));
        }
        distributionOrder.setM_Warehouse_ID(warehouseId);
        distributionOrder.setDocAction(Optional.ofNullable(this.getDocAction()).orElseGet(() -> "PR"));
        List<MUser> users = Arrays.asList(MUser.getOfBPartner((Properties)this.getCtx(), (int)partner.getC_BPartner_ID(), (String)this.get_TrxName()));
        if (users.isEmpty()) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@ @Value@ - @C_BPartner_ID@ : " + partner.getValue() + " - " + partner.getName());
        }
        distributionOrder.setAD_User_ID(((MUser)users.stream().findFirst().get()).getAD_User_ID());
        distributionOrder.setDateOrdered(this.getDateDoc());
        distributionOrder.setDatePromised(this.getDateDoc());
        distributionOrder.setIsInDispute(false);
        distributionOrder.setIsInTransit(false);
        distributionOrder.setSalesRep_ID(this.getAD_User_ID());
        if (!Util.isEmpty((String)this.getDescription())) {
            distributionOrder.setDescription(this.getDescription());
        } else {
            distributionOrder.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@"));
        }
        distributionOrder.setDocStatus("DR");
        distributionOrder.saveEx();
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.getProductId());
        MDDOrderLine distributionOrderLine = new MDDOrderLine(distributionOrder);
        distributionOrderLine.setM_Locator_ID(this.defaultCurrentLocator.getM_Locator_ID());
        distributionOrderLine.setM_LocatorTo_ID(this.defaultLocatorTo.getM_Locator_ID());
        distributionOrderLine.setC_UOM_ID(product.getC_UOM_ID());
        distributionOrderLine.setM_Product_ID(product.getM_Product_ID());
        distributionOrderLine.setDateOrdered(this.getDateDoc());
        distributionOrderLine.setDatePromised(this.getDateDoc());
        distributionOrderLine.setIsInvoiced(false);
        if (this.getAttributeSetInstance() > 0) {
            distributionOrderLine.setM_AttributeSetInstance_ID(this.getAttributeSetInstance());
            distributionOrderLine.setM_AttributeSetInstanceTo_ID(this.getAttributeSetInstance());
        }
        distributionOrderLine.setFreightAmt(Env.ZERO);
        distributionOrderLine.setConfirmedQty(this.getMovementQty());
        distributionOrderLine.setQtyEntered(this.getMovementQty());
        distributionOrderLine.setQtyOrdered(this.getMovementQty());
        distributionOrderLine.setTargetQty(this.getMovementQty());
        if (!Util.isEmpty((String)this.getDescription())) {
            distributionOrderLine.setDescription(this.getDescription());
        }
        distributionOrderLine.saveEx();
        if (!distributionOrder.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + distributionOrder.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + distributionOrder.getDocumentInfo());
        }
        distributionOrder.saveEx();
        return "@Created@: " + distributionOrder.getDocumentNo();
    }

    private String createMovement() {
        MWarehouse currentWarehouse = MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId());
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)currentWarehouse.getAD_Org_ID());
        int partnerId = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (partnerId <= 0) {
            throw new NoBPartnerLinkedforOrgException(org);
        }
        MMovement movement = new MMovement(this.getCtx(), 0, this.get_TrxName());
        movement.setAD_Org_ID(currentWarehouse.getAD_Org_ID());
        movement.setC_BPartner_ID(partnerId);
        if (!Util.isEmpty((String)this.getDescription())) {
            movement.setDescription(this.getDescription());
        } else {
            movement.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@"));
        }
        movement.setDocAction(Optional.ofNullable(this.getDocAction()).orElseGet(() -> "PR"));
        movement.setSalesRep_ID(this.getAD_User_ID());
        movement.setMovementDate(this.getDateDoc());
        movement.setIsInTransit(false);
        movement.setDocStatus("DR");
        movement.saveEx();
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.getProductId());
        MMovementLine movementLine = new MMovementLine(movement);
        movementLine.setM_Locator_ID(this.defaultCurrentLocator.getM_Locator_ID());
        movementLine.setM_LocatorTo_ID(this.defaultLocatorTo.getM_Locator_ID());
        movementLine.setM_Product_ID(product.getM_Product_ID());
        if (this.getAttributeSetInstance() > 0) {
            movementLine.setM_AttributeSetInstance_ID(this.getAttributeSetInstance());
            movementLine.setM_AttributeSetInstanceTo_ID(this.getAttributeSetInstance());
        }
        if (!Util.isEmpty((String)this.getDescription())) {
            movementLine.setDescription(this.getDescription());
        }
        movementLine.setMovementQty(this.getMovementQty());
        movementLine.saveEx();
        if (!movement.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + movement.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + movement.getDocumentInfo());
        }
        movement.saveEx();
        return "@Created@: " + movement.getDocumentNo();
    }
}

