/*
 * Decompiled with CFR 0.152.
 */
package org.spin.retail.process;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.retail.process.ProductLockForInventoryAbstract;

public class ProductLockForInventory
extends ProductLockForInventoryAbstract {
    private MLocator defaultCurrentLocator;

    @Override
    protected void prepare() {
        super.prepare();
        this.defaultCurrentLocator = this.getCurrenLocatorId() > 0 ? MLocator.get((Properties)this.getCtx(), (int)this.getCurrenLocatorId()) : MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId()).getDefaultLocator();
        if (this.defaultCurrentLocator == null) {
            throw new AdempiereException("@ECA29_CurrenLocator_ID@ @NotFound@");
        }
    }

    protected String doIt() throws Exception {
        return this.createInventoryLock();
    }

    private String createInventoryLock() {
        MWarehouse currentWarehouse = MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId());
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.getProductId());
        MInventory inventoryLock = new MInventory(this.getCtx(), 0, this.get_TrxName());
        inventoryLock.setAD_Org_ID(currentWarehouse.getAD_Org_ID());
        if (!Util.isEmpty((String)this.getDescription())) {
            inventoryLock.setDescription(this.getDescription());
        } else {
            inventoryLock.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@"));
        }
        if (this.getDocTypeTargetId() > 0) {
            inventoryLock.setC_DocType_ID(this.getDocTypeTargetId());
        } else {
            inventoryLock.setC_DocType_ID(MDocType.getDocType((String)"MMI"));
        }
        inventoryLock.setMovementDate(this.getDateDoc());
        inventoryLock.setM_Warehouse_ID(currentWarehouse.getM_Warehouse_ID());
        inventoryLock.setDocStatus("DR");
        inventoryLock.setDocumentNo(product.getValue() + " - " + product.getName() + " - " + inventoryLock.getDocumentNo());
        inventoryLock.addDescription(product.getValue() + " - " + product.getName());
        inventoryLock.saveEx();
        MInventoryLine inventoryLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
        inventoryLine.setM_Inventory_ID(inventoryLock.getM_Inventory_ID());
        inventoryLine.setM_Locator_ID(this.defaultCurrentLocator.getM_Locator_ID());
        inventoryLine.setM_Product_ID(product.getM_Product_ID());
        if (this.getAttributeSetInstance() > 0) {
            inventoryLine.setM_AttributeSetInstance_ID(this.getAttributeSetInstance());
        }
        if (!Util.isEmpty((String)this.getDescription())) {
            inventoryLine.setDescription(this.getDescription());
        }
        inventoryLine.setQtyCount(Env.ZERO);
        inventoryLine.saveEx();
        return "@Created@: " + inventoryLock.getDocumentNo();
    }
}

