/*
 * Decompiled with CFR 0.152.
 */
package org.spin.retail.process;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.retail.process.ProductInventoryAdjustmentAbstract;
import org.spin.retail.util.ProductStorageUtil;

public class ProductInventoryAdjustment
extends ProductInventoryAdjustmentAbstract {
    private MLocator defaultCurrentLocator;

    @Override
    protected void prepare() {
        super.prepare();
        this.defaultCurrentLocator = this.getCurrenLocatorId() > 0 ? MLocator.get((Properties)this.getCtx(), (int)this.getCurrenLocatorId()) : MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId()).getDefaultLocator();
        if (this.defaultCurrentLocator == null) {
            throw new AdempiereException("@ECA29_CurrenLocator_ID@ @NotFound@");
        }
    }

    protected String doIt() throws Exception {
        return this.createInventoryAdjustment();
    }

    private String createInventoryAdjustment() {
        MWarehouse currentWarehouse = MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId());
        MInventory inventoryAdjustment = new MInventory(this.getCtx(), 0, this.get_TrxName());
        inventoryAdjustment.setAD_Org_ID(currentWarehouse.getAD_Org_ID());
        if (!Util.isEmpty((String)this.getDescription())) {
            inventoryAdjustment.setDescription(this.getDescription());
        } else {
            inventoryAdjustment.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@"));
        }
        if (this.getDocTypeTargetId() > 0) {
            inventoryAdjustment.setC_DocType_ID(this.getDocTypeTargetId());
        } else {
            inventoryAdjustment.setC_DocType_ID(MDocType.getDocType((String)"MMI"));
        }
        inventoryAdjustment.setDocAction(Optional.ofNullable(this.getDocAction()).orElseGet(() -> "PR"));
        inventoryAdjustment.setMovementDate(this.getDateDoc());
        inventoryAdjustment.setM_Warehouse_ID(currentWarehouse.getM_Warehouse_ID());
        inventoryAdjustment.setDocStatus("DR");
        inventoryAdjustment.saveEx();
        if (this.getAttributeSetInstance() <= 0) {
            new Query(this.getCtx(), "M_Storage", "M_Product_ID = ? AND M_Locator_ID = ? AND QtyOnHand <> 0 AND M_AttributeSetInstance_ID <> 0", this.get_TrxName()).setParameters(new Object[]{this.getProductId(), this.defaultCurrentLocator.getM_Locator_ID()}).getIDsAsList().forEach(storageId -> {
                MStorage currentStorage = new MStorage(this.getCtx(), storageId.intValue(), this.get_TrxName());
                this.createInventoryLine(inventoryAdjustment, currentStorage.getM_AttributeSetInstance_ID(), Env.ZERO);
            });
        }
        this.createInventoryLine(inventoryAdjustment, this.getAttributeSetInstance(), this.getQtyCount());
        if (!inventoryAdjustment.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + inventoryAdjustment.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + inventoryAdjustment.getDocumentInfo());
        }
        inventoryAdjustment.saveEx();
        return "@Created@: " + inventoryAdjustment.getDocumentNo();
    }

    private void createInventoryLine(MInventory header, int attributeSetInstanceId, BigDecimal quantity) {
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.getProductId());
        MInventoryLine inventoryAdjustmentLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
        inventoryAdjustmentLine.setM_Inventory_ID(header.getM_Inventory_ID());
        inventoryAdjustmentLine.setM_Locator_ID(this.defaultCurrentLocator.getM_Locator_ID());
        inventoryAdjustmentLine.setM_Product_ID(product.getM_Product_ID());
        inventoryAdjustmentLine.setM_AttributeSetInstance_ID(attributeSetInstanceId);
        if (!Util.isEmpty((String)this.getDescription())) {
            inventoryAdjustmentLine.setDescription(this.getDescription());
        }
        inventoryAdjustmentLine.setQtyCount(quantity);
        ProductStorageUtil.setQuantityBook(inventoryAdjustmentLine);
        inventoryAdjustmentLine.saveEx();
    }
}

