/*
 * Decompiled with CFR 0.152.
 */
package org.spin.retail.process;

import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.retail.process.ProductInternalUseAbstract;

public class ProductInternalUse
extends ProductInternalUseAbstract {
    private MLocator defaultCurrentLocator;

    @Override
    protected void prepare() {
        super.prepare();
        this.defaultCurrentLocator = this.getCurrenLocatorId() > 0 ? MLocator.get((Properties)this.getCtx(), (int)this.getCurrenLocatorId()) : MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId()).getDefaultLocator();
        if (this.defaultCurrentLocator == null) {
            throw new AdempiereException("@ECA29_CurrenLocator_ID@ @NotFound@");
        }
    }

    protected String doIt() throws Exception {
        return this.createInternalUse();
    }

    private String createInternalUse() {
        MWarehouse currentWarehouse = MWarehouse.get((Properties)this.getCtx(), (int)this.getCurrenWarehouseId());
        MInventory internalUse = new MInventory(this.getCtx(), 0, this.get_TrxName());
        internalUse.setAD_Org_ID(currentWarehouse.getAD_Org_ID());
        if (!Util.isEmpty((String)this.getDescription())) {
            internalUse.setDescription(this.getDescription());
        } else {
            internalUse.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@"));
        }
        if (this.getDocTypeTargetId() > 0) {
            internalUse.setC_DocType_ID(this.getDocTypeTargetId());
        } else {
            internalUse.setC_DocType_ID(MDocType.getDocType((String)"MMI"));
        }
        internalUse.setDocAction(Optional.ofNullable(this.getDocAction()).orElseGet(() -> "PR"));
        internalUse.setMovementDate(this.getDateDoc());
        internalUse.setM_Warehouse_ID(currentWarehouse.getM_Warehouse_ID());
        internalUse.setDocStatus("DR");
        internalUse.saveEx();
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.getProductId());
        MInventoryLine internalUseLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
        internalUseLine.setM_Inventory_ID(internalUse.getM_Inventory_ID());
        internalUseLine.setM_Locator_ID(this.defaultCurrentLocator.getM_Locator_ID());
        internalUseLine.setM_Product_ID(product.getM_Product_ID());
        if (this.getAttributeSetInstance() > 0) {
            internalUseLine.setM_AttributeSetInstance_ID(this.getAttributeSetInstance());
        }
        if (!Util.isEmpty((String)this.getDescription())) {
            internalUseLine.setDescription(this.getDescription());
        }
        internalUseLine.setQtyInternalUse(this.getQtyInternalUse());
        internalUseLine.setC_Charge_ID(this.getChargeId());
        internalUseLine.saveEx();
        if (!internalUse.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + internalUse.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + internalUse.getDocumentInfo());
        }
        internalUse.saveEx();
        return "@Created@: " + internalUse.getDocumentNo();
    }
}

