/*
 * Decompiled with CFR 0.152.
 */
package org.spin.retail.model.validator;

import org.compiere.model.MClient;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MProductPrice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.spin.retail.util.ProductSetupUtil;

public class ProductSetup
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ProductSetup.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_Product", (ModelValidator)this);
        engine.addModelChange("M_Product_PO", (ModelValidator)this);
        engine.addModelChange("M_DiscountSchemaBreak", (ModelValidator)this);
        engine.addModelChange("M_ProductPrice", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 1 || type == 2) {
            if (entity.get_TableName().equals("M_Product")) {
                ProductSetupUtil.setDefaultPriceListFromProductCategory((MProduct)entity);
            } else if (entity.get_TableName().equals("M_DiscountSchemaBreak")) {
                ProductSetupUtil.calculateAmount((MDiscountSchemaBreak)entity);
            } else if (entity.get_TableName().equals("M_Product_PO") && (type == 1 || entity.is_ValueChanged("PricePO") || entity.is_ValueChanged("PriceList") || entity.is_ValueChanged("FreightRatePO") || entity.is_ValueChanged("ReplenishRatePO") || entity.is_ValueChanged("MarketingRatePO"))) {
                MProductPO purchaseProduct = (MProductPO)entity;
                ProductSetupUtil.setPurchasePriceFromRates(purchaseProduct);
            }
        } else if (type == 4 || type == 5) {
            if (entity.get_TableName().equals("M_Product")) {
                if (type == 4 || entity.is_ValueChanged("M_Product_Category_ID")) {
                    ProductSetupUtil.setDiscountSchemaBreakFromCategory((MProduct)entity);
                }
            } else if (entity.get_TableName().equals("M_Product_PO")) {
                if (type == 4 || entity.is_ValueChanged("PricePO") || entity.is_ValueChanged("PriceList") || entity.is_ValueChanged("FreightRatePO") || entity.is_ValueChanged("ReplenishRatePO") || entity.is_ValueChanged("MarketingRatePO")) {
                    MProductPO purchaseProduct = (MProductPO)entity;
                    ProductSetupUtil.updateSalesPriceListFromPurchaseProduct(purchaseProduct);
                }
            } else if (entity.get_TableName().equals("M_ProductPrice") && (type == 4 || entity.is_ValueChanged("PriceStd"))) {
                MProductPrice productPrice = (MProductPrice)entity;
                ProductSetupUtil.updateDiscountSchemaBreakFromSalesPriceList(productPrice);
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        return null;
    }
}

