/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.util.support.k8;

import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.compiere.model.MAttachment;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.csm.model.MCSMCluster;
import org.spin.csm.util.support.k8.IAKubeCtl;
import org.spin.model.MADAppRegistration;

public class KubeCtl
implements IAKubeCtl {
    private int registrationId = 0;
    private KubernetesClient apiClient = null;
    private CLogger log = CLogger.getCLogger(KubeCtl.class);
    private MADAppRegistration appRegistration = null;

    public String testConnection() {
        AtomicReference<String> result = new AtomicReference<String>();
        this.connect();
        BinaryOperator cumulate = (previous, acumValue) -> previous.toString() + acumValue.toString();
        result.set("");
        if (this.apiClient == null) {
            this.connect();
        }
        if (this.apiClient != null) {
            Optional.ofNullable(((NodeList)this.apiClient.nodes().list()).getItems()).ifPresent(nodes -> {
                result.getAndAccumulate(this.apiClient.getMasterUrl().toString(), cumulate);
                result.getAndAccumulate(nodes.stream().map(node -> node.getMetadata().getName()).collect(Collectors.joining(", ", " [ ", " ] ")), cumulate);
            });
        }
        this.disconnect();
        return (String)result.get();
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.appRegistration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)registrationId, null);
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public boolean connect() {
        Optional<MADAppRegistration> maybeApplicationRegistration = Optional.ofNullable(this.appRegistration);
        maybeApplicationRegistration.ifPresent(applicationRegistration -> {
            Optional<MCSMCluster> maybeCluster = Optional.ofNullable(MCSMCluster.getCluster(applicationRegistration));
            maybeCluster.ifPresent(cluster -> {
                Optional<MAttachment> maybeAttachment = Optional.ofNullable(cluster.getAttachment());
                maybeAttachment.ifPresent(attachment -> {
                    if (attachment.getEntryCount() > 0 && attachment.getEntryData(0) != null) {
                        String data = new String(attachment.getEntryData(0));
                        Config kubeConfig = null;
                        kubeConfig = Config.fromKubeconfig((String)data);
                        kubeConfig.setConnectionTimeout(this.appRegistration.getTimeout());
                        this.apiClient = new DefaultKubernetesClient(kubeConfig);
                        this.log.fine("Connected");
                    }
                });
            });
        });
        return this.apiClient != null;
    }

    @Override
    public boolean disconnect() {
        if (this.apiClient != null) {
            this.apiClient = null;
        }
        return false;
    }

    @Override
    public KubernetesClient getApiClient() {
        if (this.apiClient == null) {
            this.connect();
        }
        return this.apiClient;
    }

    @Override
    public int getTimeOut() {
        return Optional.ofNullable(this.appRegistration.getTimeout()).orElse(0);
    }
}

