/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.util;

import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.model.MADToken;
import org.spin.model.MADTokenDefinition;
import org.spin.util.ITokenGenerator;

public class ManualTokenGenerator
implements ITokenGenerator {
    private String token;
    private MADToken tokenObject;
    private Timestamp expireDate = new Timestamp(System.currentTimeMillis());
    private static String TOKEN_VALUE = "DEFAULT_MANUAL_TOKEN";

    public String generateToken(String tokenType, int userId) {
        this.expireDate = new Timestamp(System.currentTimeMillis());
        MADTokenDefinition tokenDef = MADTokenDefinition.getByTokenType((Properties)Env.getCtx(), (String)tokenType, null);
        new Query(Env.getCtx(), "AD_Token", "IsActive = ? AND AD_TokenDefinition_ID = ? ", null).setParameters(new Object[]{"Y", tokenDef.getAD_TokenDefinition_ID()}).list().stream().forEach(tok -> {
            tok.setIsActive(false);
            tok.save();
        });
        this.tokenObject = new MADToken(Env.getCtx(), 0, null);
        this.tokenObject.setTokenType(tokenType);
        this.tokenObject.setExpireDate(this.expireDate);
        this.tokenObject.setTokenValue(TOKEN_VALUE);
        this.tokenObject.setAD_User_ID(userId);
        return this.token;
    }

    public boolean validateToken(String token, int userId) {
        MADToken passReset = (MADToken)new Query(Env.getCtx(), "AD_Token", "TokenValue = ?", null).setParameters(new Object[]{token}).first();
        Timestamp current = new Timestamp(System.currentTimeMillis());
        return passReset != null && passReset.getExpireDate().compareTo(current) > 0;
    }

    public MADToken getToken() {
        return this.tokenObject;
    }

    public String getTokenValue() {
        return this.token;
    }
}

