/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MRegistration;
import org.compiere.model.Query;
import org.compiere.util.Util;
import org.spin.csm.model.MCSMApplication;
import org.spin.csm.model.MCSMApplicationType;
import org.spin.csm.model.MCSMApplicationVersion;
import org.spin.csm.util.support.k8.IAKubeCtl;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppRegistrationPara;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.k8.FileHandler;
import org.spin.util.support.k8.KubeHandler;

public class K8DeploymentUtil {
    public static String TOKEN_TYPE_GITLAB = "GL";
    public static String TOKEN_TYPE_DIGITAL_OCEAN = "DO";
    public static String APPLICATION_TYPE_K8 = "KBC";
    public static String APPLICATION_TYPE_DOCKER = "DKI";
    public static String TOKEN_HEADER_GITLAB = "PRIVATE-TOKEN";
    public static String TOKEN_HEADER_DO = "Authorization";
    public static String K8_TAG_NAMESPACE = "Namespace";
    public static String K8_TAG_SECRET = "Secret";
    public static String K8_TAG_PRIVATE_REGISTRY = "Private.Registry";
    public static String K8_TAG_PRIVATE_REGISTRY_TOKEN = "TOKEN";
    public static String K8_TAG_PRIVATE_REGISTRY_HEADER = "HEADER";
    public static String K8_TAG_PRIVATE_REGISTRY_URL = "URL";
    public static String K8_TAG_PRIVATE_TEMPLATE = "Private.Template";
    private String trx_Name = null;
    private String nameSpace;
    private IAKubeCtl supportedApi;
    private Properties Ctx;
    private int AD_Client_ID = 0;
    private boolean isDeleting = false;
    int registrationId = 0;
    int appRegistrationId = 0;
    int applicationTypeId = 0;
    int applicationId = 0;
    boolean automaticUpdatedFilter = false;
    public static final BinaryOperator<String> concat = (previous, concatValue) -> previous.toString() + concatValue.toString();

    public String get_TrxName() {
        return this.trx_Name;
    }

    public Properties getCtx() {
        return this.Ctx;
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public K8DeploymentUtil(Properties Ctx, int AD_Client_ID, String trx_Name) {
        this.Ctx = Ctx;
        this.AD_Client_ID = AD_Client_ID;
        this.trx_Name = trx_Name;
    }

    public K8DeploymentUtil withRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        return this;
    }

    public K8DeploymentUtil withAppRegistrationId(int appRegistrationId) {
        this.appRegistrationId = appRegistrationId;
        return this;
    }

    public K8DeploymentUtil withApplicationTypeId(int applicationTypeId) {
        this.applicationTypeId = applicationTypeId;
        return this;
    }

    public K8DeploymentUtil withApplicationId(int applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public K8DeploymentUtil isDeleting(boolean deleting) {
        this.isDeleting = deleting;
        return this;
    }

    public K8DeploymentUtil isAtomaticUpdate(boolean automaticUpdate) {
        this.automaticUpdatedFilter = automaticUpdate;
        return this;
    }

    private String processFilesOnCluster(MCSMApplication application, MCSMApplicationType applicationType, MADAppRegistration appRegistration) {
        AtomicReference<String> result = new AtomicReference<String>("");
        result.set("@CSM_Application_ID@ = ".concat(application.getName()).concat(" -> "));
        if (this.applicationId > 0) {
            application = new MCSMApplication(this.getCtx(), this.applicationId, this.get_TrxName());
        }
        if (application.get_ID() > 0) {
            LinkedHashMap<String, String> variables = this.getVariables(appRegistration);
            List<InputStream> templates = this.getTemplates(applicationType, application);
            if (!this.isDeleting) {
                this.setPrivateRegistryAccess(variables);
            }
            try {
                this.supportedApi = (IAKubeCtl)AppSupportHandler.getInstance().getAppSupport(appRegistration);
                if (this.supportedApi == null) {
                    throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
                }
                Optional.ofNullable(this.supportedApi).ifPresent(api -> {
                    Optional.ofNullable(new KubeHandler().withAPI(api.getApiClient()).withNamespace(this.nameSpace).withVariables(variables).withFiles(templates)).ifPresent(yamlsToApply -> {
                        if (!this.isDeleting) {
                            result.getAndAccumulate(yamlsToApply.apply(), concat);
                        } else {
                            result.getAndAccumulate(yamlsToApply.delete(), concat);
                        }
                    });
                    api.disconnect();
                });
            }
            catch (Exception e) {
                throw new AdempiereException(e.getMessage());
            }
        }
        return result.get();
    }

    private String processFilesOnCluster(MCSMApplicationType applicationType, MADAppRegistration appRegistration) {
        AtomicReference<String> result = new AtomicReference<String>("");
        result.set("@CSM_ApplicationType_ID@ = ".concat(applicationType.getName()).concat(" -> "));
        if (this.applicationId > 0) {
            result.getAndAccumulate(this.processFilesOnCluster(new MCSMApplication(this.getCtx(), this.applicationId, this.get_TrxName()), applicationType, appRegistration), concat);
        } else {
            String whereClause = "IsActive = 'Y' AND CSM_ApplicationType_ID= ?";
            new Query(this.getCtx(), "CSM_Application", whereClause, this.get_TrxName()).setParameters(new Object[]{applicationType.get_ID()}).setOrderBy("SeqNo").list().forEach(application -> result.getAndAccumulate(this.processFilesOnCluster((MCSMApplication)application, applicationType, appRegistration), concat));
        }
        return result.get();
    }

    private String processFilesOnCluster(MADAppRegistration appRegistration) {
        AtomicReference<String> result = new AtomicReference<String>("");
        result.set("@AD_AppRegistration_ID@ = ".concat(appRegistration.getName()).concat(" -> "));
        if (this.applicationTypeId > 0) {
            result.getAndAccumulate(this.processFilesOnCluster(new MCSMApplicationType(this.getCtx(), this.applicationTypeId, this.get_TrxName()), appRegistration), concat);
        } else {
            String whereClause = "IsActive = 'Y' AND EXISTS (SELECT 1 FROM CSM_CustomerSettingAccess csa INNER JOIN CSM_CustomerAppAccess caa_app ON (csa.CSM_CustomerSettingAccess_ID = caa_app.CSM_CustomerSettingAccess_ID) INNER JOIN CSM_CustomerAppAccess caa_at ON (caa_app.CSM_CustomerSettingAccess_ID = caa_at.CSM_CustomerSettingAccess_ID AND caa_at.CSM_ApplicationType_ID IS NOT NULL) WHERE caa_at.CSM_ApplicationType_ID = CSM_ApplicationType.CSM_ApplicationType_ID AND caa_app.AD_AppRegistration_ID = ? )";
            new Query(this.getCtx(), "CSM_ApplicationType", whereClause, this.get_TrxName()).setParameters(new Object[]{appRegistration.get_ID()}).list().forEach(applicationType -> result.getAndAccumulate(this.processFilesOnCluster((MCSMApplicationType)applicationType, appRegistration), concat));
        }
        return result.get();
    }

    private String processFilesOnCluster(MRegistration registration) {
        AtomicReference<String> result = new AtomicReference<String>("");
        ArrayList<Object> params = new ArrayList<Object>();
        result.set("@A_Registration_ID@ = ".concat(registration.getName()).concat(" -> "));
        if (this.appRegistrationId > 0) {
            String whereClause = "AD_AppRegistration_ID=? AND IsActive = 'Y'";
            params.add(this.appRegistrationId);
            if (this.automaticUpdatedFilter) {
                whereClause = whereClause + " AND EXISTS(SELECT 1 FROM AD_AppRegistration_Para param WHERE param.AD_AppRegistration_ID =AD_AppRegistration.AD_AppRegistration_ID AND param.ParameterName= ? AND param.ParameterValue= ?)";
                params.add("AUTOMATIC_UPDATE");
                params.add("Y");
            }
            Optional.ofNullable(new Query(this.getCtx(), "AD_AppRegistration", whereClause, this.get_TrxName()).setParameters(params).first()).ifPresent(appRegistration -> result.getAndAccumulate(this.processFilesOnCluster((MADAppRegistration)appRegistration), concat));
        } else {
            String whereClause = "A_Registration_ID = ? AND IsActive = 'Y'";
            params.add(registration.get_ID());
            if (this.automaticUpdatedFilter) {
                whereClause = whereClause + " AND EXISTS(SELECT 1 FROM AD_AppRegistration_Para param WHERE param.AD_AppRegistration_ID =AD_AppRegistration.AD_AppRegistration_ID AND param.ParameterName= ? AND param.ParameterValue= ?)";
                params.add("AUTOMATIC_UPDATE");
                params.add("Y");
            }
            new Query(this.getCtx(), "AD_AppRegistration", whereClause, this.get_TrxName()).setParameters(params).list().forEach(appRegistration -> result.getAndAccumulate(this.processFilesOnCluster((MADAppRegistration)appRegistration), concat));
        }
        return result.get();
    }

    public String processFilesOnCluster() {
        AtomicReference<String> result = new AtomicReference<String>("");
        if (this.registrationId > 0) {
            result.getAndAccumulate(this.processFilesOnCluster(new MRegistration(this.getCtx(), this.registrationId, this.get_TrxName())), concat);
        } else {
            new Query(this.getCtx(), "A_Registration", "IsActive = 'Y'", this.get_TrxName()).list().forEach(registration -> result.getAndAccumulate(this.processFilesOnCluster((MRegistration)registration), concat));
        }
        return result.get();
    }

    private LinkedHashMap<String, String> getVariables(MADAppRegistration appRegistration) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Optional<List> maybeApplicationVersions = null;
        String whereClause = "EXISTS (SELECT 1 FROM CSM_CustomerSettingAccess csa INNER JOIN CSM_CustomerAppAccess caa_app ON (csa.CSM_CustomerSettingAccess_ID = caa_app.CSM_CustomerSettingAccess_ID) INNER JOIN CSM_CustomerAppAccess caa_av ON (caa_app.CSM_CustomerSettingAccess_ID = caa_av.CSM_CustomerSettingAccess_ID AND caa_av.CSM_ApplicationVersion_ID IS NOT NULL AND caa_av.IsActive = 'Y' AND caa_av.IsReadWrite = 'Y') WHERE caa_av.CSM_ApplicationVersion_ID = CSM_ApplicationVersion.CSM_ApplicationVersion_ID AND caa_app.AD_AppRegistration_ID = ?) ";
        maybeApplicationVersions = Optional.ofNullable(new Query(this.getCtx(), "CSM_ApplicationVersion", whereClause, this.get_TrxName()).setParameters(new Object[]{appRegistration.get_ID()}).list());
        maybeApplicationVersions.ifPresent(listApplicationVersion -> result.putAll(this.getVariables(appRegistration, (List<MCSMApplicationVersion>)listApplicationVersion)));
        return result;
    }

    private LinkedHashMap<String, String> getVariables(MADAppRegistration AppRegistration, List<MCSMApplicationVersion> versions) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        AppRegistration.getAllParameters().entrySet().forEach(param -> {
            String value = ((MADAppRegistrationPara)param.getValue()).getParameterValue();
            if (((String)param.getKey()).startsWith(K8_TAG_NAMESPACE)) {
                this.nameSpace = value;
            } else if (((String)param.getKey()).startsWith(K8_TAG_SECRET)) {
                value = Base64.getEncoder().encodeToString(value.getBytes());
            }
            result.put((String)param.getKey(), value);
        });
        versions.stream().forEach(appVersion -> result.put(appVersion.getParent().getValue(), appVersion.getReleaseURL(true)));
        return result;
    }

    private List<InputStream> getTemplates(MCSMApplicationType appType, MCSMApplication app) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        ArrayList appToProcess = new ArrayList();
        Optional.ofNullable(appType).ifPresent(type -> {
            if (type.getApplicationType() != null && type.getApplicationType().equals(APPLICATION_TYPE_K8)) {
                if (app != null && app.getCSM_ApplicationType_ID() == type.getCSM_ApplicationType_ID()) {
                    appToProcess.add(app);
                } else {
                    appToProcess.addAll(MCSMApplication.getApplicationsAsList("CSM_ApplicationType_ID = ? ", this.isDeleting ? "SeqNo DESC" : "SeqNo", type.getCSM_ApplicationType_ID()));
                }
                result.addAll(this.getTemplates(appToProcess));
            }
        });
        return result;
    }

    private List<InputStream> getTemplates(List<MCSMApplication> applications) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        Optional.ofNullable(applications).ifPresent(apps -> apps.forEach(app -> {
            Optional.ofNullable(app.getAttachment()).ifPresent(attachments -> Arrays.asList(attachments.getEntries()).stream().forEach(file -> result.add(new ByteArrayInputStream(file.getData()))));
            Optional.ofNullable(app.getReleaseAssetPattern()).ifPresent(url -> {
                FileHandler curl = new FileHandler(url, true);
                String tokenType = null;
                if (app.getValue().startsWith(K8_TAG_PRIVATE_TEMPLATE) && !Util.isEmpty((String)(tokenType = app.getValue().replaceAll(K8_TAG_PRIVATE_TEMPLATE + ".", "")))) {
                    Optional.ofNullable(new Query(this.getCtx(), "AD_Token", "EXISTS(SELECT 1 FROM AD_TokenDefinition td WHERE td.TokenType  = ? AND td.AD_TokenDefinition_ID = AD_Token.AD_TokenDefinition_ID ) AND IsActive = 'Y'", this.get_TrxName()).setParameters(new Object[]{tokenType}).first()).ifPresent(tokenObj -> {
                        try {
                            curl.withParameter(app.getReleasePattern(), tokenObj.getTokenValue());
                        }
                        catch (Exception e) {
                            throw new AdempiereException(e.getMessage());
                        }
                    });
                }
                result.add(curl.getFileStream());
            });
        }));
        return result;
    }

    private void setPrivateRegistryAccess(LinkedHashMap<String, String> variables) {
        Optional.ofNullable(new Query(this.getCtx(), "AD_TokenDefinition", "IsActive = 'Y' AND AD_Client_ID IN(0, ?)", this.get_TrxName()).setParameters(new Object[]{this.getAD_Client_ID()}).list()).ifPresent(tokenDefinitions -> tokenDefinitions.forEach(tokenDefinition -> {
            String tokenType = tokenDefinition.getTokenType();
            String prefix_tag = K8_TAG_PRIVATE_REGISTRY + "." + tokenType + ".";
            Optional.ofNullable(variables.get(prefix_tag + K8_TAG_PRIVATE_REGISTRY_HEADER)).ifPresent(HEADER -> Optional.ofNullable(variables.get(prefix_tag + K8_TAG_PRIVATE_REGISTRY_URL)).ifPresent(URL2 -> Optional.ofNullable(variables.get(prefix_tag + K8_TAG_PRIVATE_REGISTRY_TOKEN)).ifPresent(token -> {
                FileHandler fHandler = new FileHandler(URL2, true);
                if (!Util.isEmpty((String)HEADER)) {
                    try {
                        Optional.ofNullable(new Query(this.getCtx(), "AD_Token", "AD_TokenDefinition_ID = ? AND IsActive = 'Y'", this.get_TrxName()).setParameters(new Object[]{tokenDefinition.getAD_TokenDefinition_ID()}).first()).ifPresent(tokenObj -> fHandler.withParameter(HEADER, tokenObj.getTokenValue()));
                    }
                    catch (Exception e) {
                        throw new AdempiereException(e.getLocalizedMessage());
                    }
                }
                String tokenValue = fHandler.getTextContent();
                token = K8DeploymentUtil.getBase64(tokenValue);
                variables.put(prefix_tag + K8_TAG_PRIVATE_REGISTRY_TOKEN, (String)token);
            })));
        }));
    }

    public static String getBase64(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes());
    }

    public static String getBase64(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }
}

