/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.spin.csm.util.IDockerRegistry;
import org.spin.model.MADAppRegistration;
import org.spin.restapi.util.RestAPIAbstract;

public class DigitalOceanGetRegistry
extends RestAPIAbstract
implements IDockerRegistry {
    private int registrationId = 0;
    private MADAppRegistration appRegistration;
    private CLogger log = CLogger.getCLogger(DigitalOceanGetRegistry.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private int totalTags = 1;
    private int currentTags = 0;
    private int currentPage = 0;

    @Override
    public LinkedHashMap<String, HashMap<String, Object>> getData() {
        LinkedHashMap<String, HashMap<String, Object>> data = new LinkedHashMap<String, HashMap<String, Object>>();
        while (this.currentTags < this.totalTags) {
            this.withParameter("page", ++this.currentPage);
            Optional.ofNullable(this.getWebResponse()).ifPresent(response -> {
                if (response.getStatus() != 200) {
                    this.log.severe(response.toString());
                    this.clear();
                    throw new AdempiereException(response.toString());
                }
                Optional<Object> maybeJson = Optional.ofNullable(response.readEntity(String.class));
                maybeJson.ifPresent(jsonString -> {
                    Optional<JSONObject> maybeResult = Optional.ofNullable(new JSONObject(jsonString));
                    maybeResult.ifPresent(jsonResult -> {
                        Optional<JSONObject> maybeTotals = Optional.ofNullable(jsonResult.getJSONObject("meta"));
                        maybeTotals.ifPresent(totals -> {
                            this.totalTags = totals.getInt("total");
                            Optional<JSONArray> maybeTags = Optional.ofNullable(jsonResult.getJSONArray("tags"));
                            maybeTags.ifPresent(tags -> tags.forEach(tagOject -> {
                                try {
                                    JSONObject tag = (JSONObject)tagOject;
                                    HashMap<String, Object> item = new HashMap<String, Object>();
                                    item.put("Size", tag.getBigDecimal("size_bytes"));
                                    item.put("RegistryName", tag.getString("registry_name"));
                                    item.put("Repository", tag.getString("repository"));
                                    item.put("CompressedSize", tag.getBigDecimal("compressed_size_bytes"));
                                    item.put("Updated", DATE_FORMAT.parse(tag.getString("updated_at")));
                                    item.put("Digest", tag.getString("manifest_digest"));
                                    data.put(tag.getString("tag"), item);
                                    ++this.currentTags;
                                }
                                catch (JSONException e) {
                                    this.clear();
                                    this.log.severe(e.getMessage());
                                    throw new AdempiereException(e.getMessage());
                                }
                                catch (ParseException e) {
                                    this.clear();
                                    this.log.severe(e.getMessage());
                                    throw new AdempiereException(e.getMessage());
                                }
                            }));
                        });
                    });
                });
            });
            this.setParameters(new HashMap());
        }
        this.clear();
        return data;
    }

    private void clear() {
        this.currentTags = 0;
        this.currentPage = 0;
        this.totalTags = 1;
        this.clearParameters();
    }

    public String testConnection() {
        return "OK";
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.appRegistration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)registrationId, null);
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }
}

