/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.util;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.csm.model.MCSMApplicationVersion;
import org.spin.csm.model.MCSMCustomerSettingAccess;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppRegistrationPara;
import org.spin.util.TokenGeneratorHandler;

public class CustomerSettingUtil {
    public static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";
    public static final String SETUP_UUID = "(*AutomaticSetup*)";
    public static final String EntityType = "ECA09";
    public static final String ApplicationType_DigitalOcean_DockerImage = "DOR";
    public static final String ApplicationType_DockerHub_DockerImage = "DHR";
    public static final String API_URL_DigitalOcean = "https://api.digitalocean.com";
    public static final String API_URL_GitHub = "https://hub.docker.com";
    public static final String API_PATH_DigitalOcean_DockerImage = "/v2/registry/<<Registry Name>>/repositories/<<Repository Name>>/tags";
    public static final String API_PATH_DockerHub_DockerImage = "/v2/repositories/<<Registry Name>>/<<Repository Name>>/tags";
    public static final String TOKEN_TYPE_PARAMETER_DigitalOcean = "DO";
    public static final String TOKEN_TYPE_PARAMETER_DockerHub = "DH";
    public static final String API_Parameter_URL = "URL";
    public static final String API_Parameter_URL_PATH = "PATH";
    public static final String API_Parameter_TOKEN_TYPE = "TOKEN_TYPE";
    public static final String DOCKER_TAG_IMAGE_REGISTRY_NAME = "RegistryName";
    public static final String DOCKER_TAG_IMAGE_REPOSITORY = "Repository";
    public static final String DOCKER_TAG_COMPRESSED_SIZE = "CompressedSize";
    public static final String DOCKER_TAG_FULL_SIZE = "Size";
    public static final String DOCKER_TAG_UPDATED = "Updated";
    public static final String DOCKER_TAG_DIGEST = "Digest";
    public static final String PARAMETER_Name = "AUTOMATIC_UPDATE";
    public static final String PARAMETER_Value = "Y";

    public static String getParameter(Properties ctx, String customerSettingCode, String applicationCode, String token, String parameterName, int userId) {
        boolean isValid = false;
        MCSMCustomerSettingAccess customerSettingAccess = (MCSMCustomerSettingAccess)new Query(ctx, "CSM_CustomerSettingAccess", "EXISTS(SELECT 1 FROM CSM_CustomerSetting cs WHERE cs.CSM_CustomerSetting_ID = CSM_CustomerSettingAccess.CSM_CustomerSetting_ID AND cs.Value = ?) AND EXISTS(SELECT 1 FROM CSM_CustomerAppAccess aa \t\t\t\t\tINNER JOIN AD_AppRegistration ap ON(ap.AD_AppRegistration_ID = aa.AD_AppRegistration_ID) \t\t\t\t\tWHERE aa.CSM_CustomerSettingAccess_ID = CSM_CustomerSettingAccess.CSM_CustomerSettingAccess_ID \t\t\t\t\tAND ap.Value = ?) AND EXISTS(SELECT 1 FROM AD_Token t WHERE t.AD_Token_ID = CSM_CustomerSettingAccess.CurrentToken_ID AND t.TokenValue = ?)", null).setParameters(new Object[]{customerSettingCode, applicationCode, token}).first();
        if (customerSettingAccess != null && customerSettingAccess.getCSM_CustomerSettingAccess_ID() != 0) {
            try {
                isValid = TokenGeneratorHandler.getInstance().validateToken(API_Parameter_URL, token, userId);
            }
            catch (Exception e) {
                throw new AdempiereException(e.getMessage());
            }
        }
        if (isValid) {
            Optional<MADAppRegistration> optionalEvaluator = customerSettingAccess.getAppRegistrationList().stream().filter(applicationRegistration -> applicationRegistration.getValue().equals(applicationCode)).findFirst();
            if (optionalEvaluator.isPresent()) {
                return optionalEvaluator.get().getParameterValue(parameterName);
            }
        } else {
            throw new AdempiereException("@Invalid@ @AD_Token_ID@");
        }
        return null;
    }

    public static List<MADAppRegistrationPara> getParametersList(Properties ctx, String customerSettingCode, String applicationCode, String token, int userId) {
        boolean isValid = false;
        MCSMCustomerSettingAccess customerSettingAccess = (MCSMCustomerSettingAccess)new Query(ctx, "CSM_CustomerSettingAccess", "EXISTS(SELECT 1 FROM CSM_CustomerSetting cs WHERE cs.CSM_CustomerSetting_ID = CSM_CustomerSettingAccess.CSM_CustomerSetting_ID AND cs.Value = ?) AND EXISTS(SELECT 1 FROM CSM_CustomerAppAccess aa \t\t\t\t\tINNER JOIN AD_AppRegistration ap ON(ap.AD_AppRegistration_ID = aa.AD_AppRegistration_ID) \t\t\t\t\tWHERE aa.CSM_CustomerSettingAccess_ID = CSM_CustomerSettingAccess.CSM_CustomerSettingAccess_ID \t\t\t\t\tAND ap.Value = ?) AND EXISTS(SELECT 1 FROM AD_Token t WHERE t.AD_Token_ID = CSM_CustomerSettingAccess.CurrentToken_ID AND t.TokenValue = ?)", null).setParameters(new Object[]{customerSettingCode, applicationCode, token}).first();
        if (customerSettingAccess != null && customerSettingAccess.getCSM_CustomerSettingAccess_ID() != 0) {
            try {
                isValid = TokenGeneratorHandler.getInstance().validateToken(API_Parameter_URL, token, userId);
            }
            catch (Exception e) {
                throw new AdempiereException(e.getMessage());
            }
        }
        if (isValid) {
            Optional<MADAppRegistration> optionalEvaluator = customerSettingAccess.getAppRegistrationList().stream().filter(applicationRegistration -> applicationRegistration.getValue().equals(applicationCode)).findFirst();
            if (optionalEvaluator.isPresent()) {
                return new Query(ctx, "AD_AppRegistration_Para", "AD_AppRegistration_ID = ?", null).setParameters(new Object[]{optionalEvaluator.get().getAD_AppRegistration_ID()}).list();
            }
        } else {
            throw new AdempiereException("@Invalid@ @AD_Token_ID@");
        }
        return null;
    }

    public static List<MCSMApplicationVersion> getApplicationList(Properties ctx, String releaseNo, String releaseTag, String customerSettingCode, String applicationCode, String token, int userId) {
        boolean isValid = false;
        MCSMCustomerSettingAccess customerSettingAccess = (MCSMCustomerSettingAccess)new Query(ctx, "CSM_CustomerSettingAccess", "EXISTS(SELECT 1 FROM CSM_CustomerSetting cs WHERE cs.CSM_CustomerSetting_ID = CSM_CustomerSettingAccess.CSM_CustomerSetting_ID AND cs.Value = ?) AND EXISTS(SELECT 1 FROM CSM_CustomerAppAccess aa INNER JOIN CSM_Application ap ON(ap.CSM_Application_ID = aa.CSM_Application_ID) WHERE aa.CSM_CustomerSettingAccess_ID = CSM_CustomerSettingAccess.CSM_CustomerSettingAccess_ID AND ap.Value = ?) AND EXISTS(SELECT 1 FROM AD_Token t WHERE t.AD_Token_ID = CSM_CustomerSettingAccess.CurrentToken_ID AND t.TokenValue = ?)", null).setParameters(new Object[]{customerSettingCode, applicationCode, token}).first();
        if (customerSettingAccess != null && customerSettingAccess.getCSM_CustomerSettingAccess_ID() != 0) {
            try {
                isValid = TokenGeneratorHandler.getInstance().validateToken(API_Parameter_URL, token, userId);
            }
            catch (Exception e) {
                throw new AdempiereException(e.getMessage());
            }
        }
        if (isValid) {
            Optional<PO> baseAppVersion = Optional.ofNullable(new Query(ctx, "CSM_ApplicationVersion", "EXISTS(SELECT 1 FROM CSM_Application app WHERE app.CSM_Application_ID = CSM_ApplicationVersion.CSM_Application_ID AND app.Value = ?) AND ReleaseNo = ? AND ReleaseTag = ?", null).setParameters(new Object[]{applicationCode, releaseNo, releaseTag}).first());
            if (baseAppVersion.isPresent()) {
                return ((MCSMApplicationVersion)baseAppVersion.get()).getListVersion();
            }
        } else {
            throw new AdempiereException("@Invalid@ @AD_Token_ID@");
        }
        return null;
    }
}

