/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.util;

import java.security.SecureRandom;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.SecureEngine;
import org.compiere.util.TimeUtil;
import org.spin.model.MADToken;
import org.spin.util.ITokenGenerator;

public class CSMTokenGenerator
implements ITokenGenerator {
    private String token;
    private MADToken tokenObject;

    public String generateToken(String tokenType, int userId) {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] bSalt = new byte[8];
            random.nextBytes(bSalt);
            this.token = SecureEngine.getSHA512Hash((int)1000, (String)this.getRandomValue(), (byte[])bSalt);
            Timestamp expireDate = new Timestamp(System.currentTimeMillis());
            expireDate = TimeUtil.addDays((Timestamp)expireDate, (int)30);
            this.tokenObject = new MADToken(Env.getCtx(), 0, null);
            this.tokenObject.setTokenType(tokenType);
            this.tokenObject.setExpireDate(expireDate);
            this.tokenObject.setTokenValue(this.token);
            this.tokenObject.setAD_User_ID(userId);
            this.tokenObject.saveEx();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        return this.token;
    }

    private String getRandomValue() {
        long longToken = Math.abs(new SecureRandom().nextLong());
        return Long.toString(longToken, 16);
    }

    public boolean validateToken(String token, int userId) {
        MADToken passReset = (MADToken)new Query(Env.getCtx(), "AD_Token", "TokenValue = ?", null).setParameters(new Object[]{token}).first();
        Timestamp current = new Timestamp(System.currentTimeMillis());
        return passReset != null && passReset.getExpireDate().compareTo(current) > 0;
    }

    public MADToken getToken() {
        return this.tokenObject;
    }

    public String getTokenValue() {
        return this.token;
    }
}

