/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.csm.util.DigitalOceanGetRegistry;
import org.spin.model.MADAppSupport;
import org.spin.model.MADAppSupportPara;
import org.spin.util.ISetupDefinition;

public class DigitalOceanGetRegistrySetup
implements ISetupDefinition {
    public String doIt(Properties context, String transactionName) {
        this.createAppSupport(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createAppSupport(Properties context, String transactionName) {
        if (Env.getAD_Client_ID((Properties)context) > 0) {
            throw new AdempiereException("@Invalid@ @AD_Client_ID@");
        }
        MADAppSupport appSupport = (MADAppSupport)new Query(context, "AD_AppSupport", "Classname = ?", transactionName).setParameters(new Object[]{DigitalOceanGetRegistry.class.getName()}).setClient_ID().first();
        if (appSupport != null && appSupport.get_ID() > 0) {
            return;
        }
        appSupport = new MADAppSupport(context, 0, transactionName);
        appSupport.setValue("DO Docker Image");
        appSupport.setName(appSupport.getValue());
        appSupport.setDescription("(*Created from Setup Automatically*)");
        appSupport.setApplicationType("DOR");
        appSupport.setIsDefault(false);
        appSupport.setClassname(DigitalOceanGetRegistry.class.getName());
        appSupport.setIsDirectLoad(true);
        appSupport.saveEx();
        this.createAppSupportPara(appSupport, "URL", "https://api.digitalocean.com", "URL for Digital Ocean API");
        this.createAppSupportPara(appSupport, "PATH", "/v2/registry/<<Registry Name>>/repositories/<<Repository Name>>/tags", "Path for URL Digital Ocean API (Replace <<Registry Name>> for real registry name and <<Repository Name>> for real repository Name)");
        this.createAppSupportPara(appSupport, "TOKEN_TYPE", "DO", "Token Type for Get Manual Token");
    }

    private void createAppSupportPara(MADAppSupport appSupport, String parameterName, String defaultValue, String description) {
        MADAppSupportPara urlParam = new MADAppSupportPara(appSupport.getCtx(), 0, appSupport.get_TrxName());
        urlParam.setAD_AppSupport_ID(appSupport.get_ID());
        urlParam.setParameterType("C");
        urlParam.setAD_Reference_ID(10);
        urlParam.setParameterName(parameterName);
        urlParam.setParameterDefault(defaultValue);
        urlParam.setIsMandatory(true);
        urlParam.setDescription(description);
        urlParam.saveEx();
    }
}

