/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.csm.model.MCSMApplication;
import org.spin.csm.model.MCSMApplicationVersion;
import org.spin.csm.model.MCSMCustomerAppAccess;
import org.spin.csm.process.ApplicationVersionUpdateAbstract;

public class ApplicationVersionUpdate
extends ApplicationVersionUpdateAbstract {
    private AtomicInteger updateVersions = new AtomicInteger(0);

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.getRegistrationId() > 0) {
            this.updateAppForActiveRegistration(this.getRegistrationId());
        } else {
            Optional<List> maybeActiveRegistrations = Optional.ofNullable(new Query(this.getCtx(), "A_Registration", "", this.get_TrxName()).setOnlyActiveRecords(true).getIDsAsList());
            maybeActiveRegistrations.ifPresent(activeRegistrations -> activeRegistrations.forEach(registrationId -> this.updateAppForActiveRegistration((int)registrationId)));
        }
        if (this.isUpgradeNow()) {
            ProcessBuilder upgradeProcess = ProcessBuilder.create((Properties)this.getCtx());
            Arrays.asList(this.getParameter()).stream().forEach(parameter -> upgradeProcess.withParameter(parameter.getParameterName(), parameter.getParameter(), parameter.getParameter_To()));
            upgradeProcess.execute(this.get_TrxName());
        }
        return "@Updated@ -> " + this.updateVersions.get();
    }

    private void updateAppForActiveRegistration(int registrationId) {
        if (this.getAppRegistrationId() > 0) {
            this.updateAppForApplicationRegistration(this.getAppRegistrationId());
        } else {
            String whereClause = "A_Registration_ID = ?  AND IsActive = 'Y' ";
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(registrationId);
            if (this.isOnlyAutomaticUpdated()) {
                whereClause = whereClause + "AND EXISTS(SELECT 1 FROM AD_AppRegistration_Para param WHERE param.AD_AppRegistration_ID =AD_AppRegistration.AD_AppRegistration_ID AND param.ParameterName= ? AND param.ParameterValue= ? )";
                params.add("AUTOMATIC_UPDATE");
                params.add("Y");
            }
            Optional<List> maybeAppRegistrations = Optional.ofNullable(new Query(this.getCtx(), "AD_AppRegistration", whereClause, this.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).getIDsAsList());
            maybeAppRegistrations.ifPresent(appRegistrations -> appRegistrations.forEach(appRegistrationId -> this.updateAppForApplicationRegistration((int)appRegistrationId)));
        }
    }

    private void updateAppForApplicationRegistration(int appRegistrationId) {
        AtomicReference<Object> updatedCustomerAppAccess = new AtomicReference<Object>(null);
        String whereClause = "EXISTS (SELECT 1 FROM CSM_CustomerAppAccess caa WHERE caa.CSM_CustomerSettingAccess_ID = CSM_CustomerSettingAccess.CSM_CustomerSettingAccess_ID AND caa.AD_AppRegistration_ID = ?)";
        Optional<PO> maybeCustomerSettingAccess = Optional.ofNullable(new Query(this.getCtx(), "CSM_CustomerSettingAccess", whereClause, this.get_TrxName()).setParameters(new Object[]{appRegistrationId}).setOnlyActiveRecords(true).first());
        maybeCustomerSettingAccess.ifPresent(customerSettingAccess -> customerSettingAccess.getApplicationAccess().stream().filter(appAccess -> appAccess.getCSM_Application_ID() != 0 && appAccess.getCSM_ApplicationVersion_ID() != 0).forEach(appAccess -> {
            if (appAccess.isActive() && appAccess.isReadWrite()) {
                if (this.getApplicationVersionId() > 0 && updatedCustomerAppAccess.get() == null) {
                    updatedCustomerAppAccess.set(this.createApplicationAccessToSelectedVersion((MCSMCustomerAppAccess)appAccess, new MCSMApplicationVersion(this.getCtx(), this.getApplicationVersionId(), this.get_TrxName())));
                }
                if (updatedCustomerAppAccess.get() == null) {
                    updatedCustomerAppAccess.set(this.createApplicationAccessToLatestVersion((MCSMCustomerAppAccess)appAccess));
                }
                if (updatedCustomerAppAccess.get() != null && ((MCSMCustomerAppAccess)updatedCustomerAppAccess.get()).get_ID() != appAccess.get_ID()) {
                    appAccess.setIsReadWrite(false);
                    appAccess.saveEx();
                }
            }
        }));
    }

    private MCSMCustomerAppAccess createApplicationAccessToLatestVersion(MCSMCustomerAppAccess customerAppAccess) {
        AtomicReference<Object> updatedCustomerAppAccess = new AtomicReference<Object>(null);
        Optional<MCSMApplication> maybeApplication = Optional.ofNullable((MCSMApplication)customerAppAccess.getCSM_Application());
        Optional<MCSMApplicationVersion> maybeApplicationVersion = Optional.ofNullable((MCSMApplicationVersion)customerAppAccess.getCSM_ApplicationVersion());
        maybeApplication.ifPresent(application -> maybeApplicationVersion.ifPresent(currentVersion -> {
            MCSMApplicationVersion latestVersion = application.getLatestVersion(currentVersion.getReleaseType());
            if (latestVersion.get_ID() != currentVersion.get_ID()) {
                MCSMCustomerAppAccess newcustomerAppAccess = new MCSMCustomerAppAccess(this.getCtx(), 0, this.get_TrxName());
                MCSMCustomerAppAccess.copyValues((PO)customerAppAccess, (PO)newcustomerAppAccess);
                newcustomerAppAccess.setCSM_ApplicationVersion_ID(latestVersion.get_ID());
                newcustomerAppAccess.saveEx();
                updatedCustomerAppAccess.set(newcustomerAppAccess);
                this.updateVersions.addAndGet(1);
            } else {
                updatedCustomerAppAccess.set(customerAppAccess);
            }
        }));
        return updatedCustomerAppAccess.get();
    }

    private MCSMCustomerAppAccess createApplicationAccessToSelectedVersion(MCSMCustomerAppAccess customerAppAccess, MCSMApplicationVersion applicationVersion) {
        AtomicReference<Object> updatedCustomerAppAccess = new AtomicReference<Object>(null);
        Optional<MCSMApplication> maybeApplication = Optional.ofNullable((MCSMApplication)applicationVersion.getCSM_Application());
        Optional<MCSMApplicationVersion> maybeApplicationVersion = Optional.ofNullable(applicationVersion);
        maybeApplication.ifPresent(application -> maybeApplicationVersion.ifPresent(selectedVersion -> {
            MCSMCustomerAppAccess newcustomerAppAccess = new MCSMCustomerAppAccess(this.getCtx(), 0, this.get_TrxName());
            newcustomerAppAccess.setCSM_CustomerSettingAccess_ID(customerAppAccess.getCSM_CustomerSettingAccess_ID());
            newcustomerAppAccess.setCSM_Application_ID(selectedVersion.getCSM_Application_ID());
            newcustomerAppAccess.setCSM_ApplicationVersion_ID(selectedVersion.get_ID());
            newcustomerAppAccess.setIsReadWrite(true);
            newcustomerAppAccess.saveEx();
            updatedCustomerAppAccess.set(newcustomerAppAccess);
            this.updateVersions.addAndGet(1);
        }));
        return updatedCustomerAppAccess.get();
    }
}

