/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.process;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.MediaType;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.spin.csm.model.MCSMApplication;
import org.spin.csm.model.MCSMApplicationVersion;
import org.spin.csm.process.ApplicationUpdateAbstract;
import org.spin.csm.util.IDockerRegistry;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADToken;
import org.spin.restapi.util.RestAPIAbstract;
import org.spin.util.support.AppSupportHandler;

public class ApplicationUpdate
extends ApplicationUpdateAbstract {
    private CLogger log = CLogger.getCLogger(ApplicationUpdate.class);
    private AtomicInteger updateVersions = new AtomicInteger(0);
    private AtomicInteger createdVersions = new AtomicInteger(0);

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.getRecord_ID() > 0) {
            Optional<MCSMApplication> maybeApplication = Optional.ofNullable(new MCSMApplication(this.getCtx(), this.getRecord_ID(), this.get_TrxName()));
            maybeApplication.ifPresent(application -> this.updateApplication((MCSMApplication)application));
        } else {
            Optional<List> maybeApplications = Optional.ofNullable(new Query(this.getCtx(), "CSM_Application", "InfoAPI_ID IS NOT NULL", this.get_TrxName()).list());
            maybeApplications.ifPresent(applications -> applications.forEach(application -> this.updateApplication((MCSMApplication)application)));
        }
        return "@Updated@ -> " + this.updateVersions.get() + " | @Created@ " + this.createdVersions.get();
    }

    private void updateApplication(MCSMApplication application) {
        Optional<MADAppRegistration> maybeAppRegistration = Optional.ofNullable(MADAppRegistration.getById((Properties)this.getCtx(), (int)application.getInfoAPI_ID(), (String)this.get_TrxName()));
        maybeAppRegistration.ifPresent(registration -> {
            Optional<String> maybeURL = Optional.ofNullable(registration.getParameterValue("URL"));
            Optional<String> maybeURLPath = Optional.ofNullable(registration.getParameterValue("PATH"));
            Optional<String> tokenType = Optional.ofNullable(registration.getParameterValue("TOKEN_TYPE"));
            maybeURL.ifPresent(url -> maybeURLPath.ifPresent(urlPath -> this.getToken(tokenType.orElse("")).ifPresent(token -> {
                try {
                    Optional<List<MCSMApplicationVersion>> maybeApplicationVersions = Optional.ofNullable(application.getActiveVersionAsList());
                    RestAPIAbstract api = (RestAPIAbstract)AppSupportHandler.getInstance().getAppSupport(registration);
                    IDockerRegistry parserData = (IDockerRegistry)api;
                    Optional<LinkedHashMap<String, HashMap<String, Object>>> maybeApiData = null;
                    api.withURL(url).withPath(urlPath).withRequest(MediaType.APPLICATION_JSON_TYPE).withHeader("Content-Type", (Object)"application/json").withHeader("Authorization", (Object)token.getTokenValue());
                    maybeApiData = Optional.ofNullable(parserData.getData());
                    maybeApiData.ifPresent(apiData -> {
                        maybeApplicationVersions.ifPresent(appVersions -> appVersions.forEach(appVersion -> {
                            Optional maybeData = Optional.ofNullable(apiData.get(appVersion.getReleaseTag()));
                            maybeData.ifPresent(data -> {
                                appVersion.setIsActive(true);
                                appVersion.setReleaseDate(new Timestamp(((Date)data.get("Updated")).getTime()));
                            });
                            maybeData.orElseGet(() -> {
                                appVersion.setIsActive(false);
                                return null;
                            });
                            if (appVersion.is_Changed()) {
                                appVersion.saveEx();
                                this.updateVersions.addAndGet(1);
                            }
                        }));
                        apiData.entrySet().forEach(data -> maybeApplicationVersions.ifPresent(appVersions -> {
                            Optional<MCSMApplicationVersion> maybeVersion = appVersions.stream().filter(version -> version.getReleaseTag().equals(data.getKey())).findFirst();
                            maybeVersion.orElseGet(() -> this.createVersion(application, (String)data.getKey(), (HashMap)data.getValue()));
                        }));
                    });
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    throw new AdempiereException(e.getMessage());
                }
            })));
        });
    }

    private MCSMApplicationVersion createVersion(MCSMApplication application, String releaseTag, HashMap<String, Object> data) {
        MCSMApplicationVersion version = new MCSMApplicationVersion(this.getCtx(), 0, this.get_TrxName());
        version.setCSM_Application_ID(application.get_ID());
        version.setReleaseNo(releaseTag);
        version.setReleaseTag(releaseTag);
        version.setReleaseDate(new Timestamp(((Date)data.get("Updated")).getTime()));
        version.setName(data.get("Digest").toString());
        version.setIsValid(true);
        version.setReleaseType(this.getReleaseType(releaseTag));
        version.saveEx();
        this.createdVersions.addAndGet(1);
        return version;
    }

    private Optional<MADToken> getToken(String tokenType) {
        String whereClause = "EXISTS (SELECT 1 FROM AD_TokenDefinition td WHERE td.AD_TokenDefinition_ID = AD_Token.AD_TokenDefinition_ID AND td.TokenType = ?)";
        return Optional.ofNullable(new Query(this.getCtx(), "AD_Token", whereClause, this.get_TrxName()).setParameters(new Object[]{tokenType}).first());
    }

    private String getReleaseType(String releaseTag) {
        String RELEASE = "R";
        if ((releaseTag = releaseTag.toUpperCase()).contains("R".concat("T"))) {
            return "T";
        }
        if (releaseTag.contains("R".concat("C"))) {
            return "C";
        }
        if (releaseTag.contains("R".concat("S"))) {
            return "S";
        }
        return "D";
    }
}

