/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import org.adempiere.model.GenericPO;
import org.compiere.model.MAttachment;
import org.compiere.model.MRegistration;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.csm.model.MCSMCustomerSettingAccess;
import org.spin.csm.process.ActiveRegistrationCreateFromAbstract;
import org.spin.csm.process.CustomerSettingGenerateTokenAbstract;

public class ActiveRegistrationCreateFrom
extends ActiveRegistrationCreateFromAbstract {
    private BinaryOperator<String> concat = (previous, concatValue) -> previous.toString() + concatValue.toString();
    private static String COLUMNNAME_A_Registration_ID = "A_A_Registration_ID";
    private static String COLUMNNAME_AD_AppRegistration_ID = "APP_AD_AppRegistration_ID";

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (!this.isSelection()) {
            if (this.getRegistrationId() == 0) {
                this.copyARegistration(this.getRecord_ID(), 0, 0);
            } else {
                int activeRegistrationFromId = this.getRegistrationId();
                int activeRegistrationToId = this.getRecord_ID();
                int appRegistrationId = this.getAppRegistrationId();
                this.copyARegistration(activeRegistrationFromId, activeRegistrationToId, appRegistrationId);
            }
        } else {
            this.getSelectionKeys().forEach(selectedRecord -> {
                int activeRegistrationFromId = this.getSelectionAsInt((int)selectedRecord, COLUMNNAME_A_Registration_ID);
                int activeRegistrationToId = this.getRecord_ID();
                int appRegistrationId = this.getSelectionAsInt((int)selectedRecord, COLUMNNAME_AD_AppRegistration_ID);
                this.copyARegistration(activeRegistrationFromId, activeRegistrationToId, appRegistrationId);
            });
        }
        return "";
    }

    private void copyARegistration(int activeRegistrationFromId, int activeRegistrationToId, int appRegistrationId) {
        if (activeRegistrationFromId > 0) {
            HashMap appRegistrationEquivalents = new HashMap();
            MRegistration activeRegistrationFrom = new MRegistration(this.getCtx(), activeRegistrationFromId, this.get_TrxName());
            AtomicReference<String> whereClause = new AtomicReference<String>("");
            AtomicReference<String> whereClauseCustomerSetting = new AtomicReference<String>("");
            ArrayList<Integer> processParameters = new ArrayList<Integer>();
            processParameters.add(activeRegistrationFrom.get_ID());
            whereClause.set("A_Registration_ID = ?");
            whereClauseCustomerSetting.set(whereClause.get());
            if (appRegistrationId > 0) {
                processParameters.add(appRegistrationId);
                whereClause.getAndAccumulate(" AND AD_AppRegistration_ID = ?", this.concat);
                whereClauseCustomerSetting.getAndAccumulate(" AND EXISTS(SELECT 1 FROM CSM_CustomerAppAccess appa WHERE appa.AD_AppRegistration_ID = ? AND appa.CSM_CustomerSettingAccess_ID = CSM_CustomerSettingAccess.CSM_CustomerSettingAccess_ID)", this.concat);
            }
            Optional<GenericPO> mayBeActiveRegistrationTo = Optional.ofNullable(this.getActiveRegistrationTo(activeRegistrationFrom, activeRegistrationToId));
            mayBeActiveRegistrationTo.ifPresent(activeRegistrationTo -> {
                new Query(this.getCtx(), "AD_AppRegistration", (String)whereClause.get(), this.get_TrxName()).setParameters(processParameters).list().forEach(appRegistrationFrom -> {
                    Optional<GenericPO> mayBeAppRegistrationTo = Optional.ofNullable(this.cloneRecord((PO)appRegistrationFrom, this.getReferences("A_Registration_ID", activeRegistrationTo.get_ID())));
                    mayBeAppRegistrationTo.ifPresent(appRegistrationTo -> {
                        appRegistrationEquivalents.put(appRegistrationFrom.get_ID(), appRegistrationTo.get_ID());
                        new Query(this.getCtx(), "AD_AppRegistration_Para", "AD_AppRegistration_ID = ? ", this.get_TrxName()).setParameters(new Object[]{appRegistrationFrom.get_ID()}).list().forEach(appRegistrationParaFrom -> this.cloneRecord((PO)appRegistrationParaFrom, this.getReferences("AD_AppRegistration_ID", appRegistrationTo.get_ID())));
                    });
                });
                new Query(this.getCtx(), "CSM_CustomerSettingAccess", (String)whereClauseCustomerSetting.get(), this.get_TrxName()).setParameters(processParameters).list().forEach(customerSettingAccessFrom -> {
                    Optional<GenericPO> mayBeCustomerSettingAccessTo = Optional.ofNullable(this.cloneRecord((PO)customerSettingAccessFrom, this.getReferences("A_Registration_ID", activeRegistrationTo.get_ID())));
                    mayBeCustomerSettingAccessTo.ifPresent(customerSettingAccessTo -> {
                        customerSettingAccessTo.set_ValueOfColumn("IsValid", (Object)false);
                        customerSettingAccessTo.set_ValueOfColumn("CurrentToken_ID", (Object)0);
                        customerSettingAccessTo.save();
                        new Query(this.getCtx(), "CSM_CustomerAppAccess", "CSM_CustomerSettingAccess_ID = ? ", this.get_TrxName()).setParameters(new Object[]{customerSettingAccessFrom.get_ID()}).list().forEach(customerAppAccessFrom -> {
                            Optional<GenericPO> mayBeCustomerAppAccessTo = Optional.ofNullable(this.cloneRecord((PO)customerAppAccessFrom, this.getReferences("CSM_CustomerSettingAccess_ID", customerSettingAccessTo.get_ID())));
                            mayBeCustomerAppAccessTo.ifPresent(customerAppAccessTo -> {
                                if (customerAppAccessTo.get_ValueAsInt("AD_AppRegistration_ID") > 0) {
                                    Optional maybeAppRegistrationId = Optional.ofNullable(appRegistrationEquivalents.get(customerAppAccessFrom.get_ValueAsInt("AD_AppRegistration_ID")));
                                    maybeAppRegistrationId.ifPresent(newAppRegistrationId -> customerAppAccessTo.set_ValueOfColumn("AD_AppRegistration_ID", newAppRegistrationId));
                                }
                                customerAppAccessTo.saveEx();
                            });
                        });
                        ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(CustomerSettingGenerateTokenAbstract.getProcessId())).withRecordId(Integer.valueOf(MCSMCustomerSettingAccess.Table_ID), Integer.valueOf(customerSettingAccessTo.get_ID())).execute(this.get_TrxName());
                    });
                });
            });
        }
    }

    private GenericPO cloneRecord(PO from, HashMap<String, Integer> foreignReferences) {
        GenericPO clonePO = new GenericPO(from.get_TableName(), from.getCtx(), 0, from.get_TrxName());
        PO.copyValues((PO)from, (PO)clonePO);
        clonePO.setIsDirectLoad(true);
        Optional<HashMap<String, Integer>> maybeReferences = Optional.ofNullable(foreignReferences);
        maybeReferences.ifPresent(references -> references.entrySet().forEach(reference -> clonePO.set_ValueOfColumn((String)reference.getKey(), reference.getValue())));
        clonePO.saveEx();
        this.copyAttachments(from, (PO)clonePO);
        return clonePO;
    }

    private boolean copyAttachments(PO from, PO to) {
        Optional<MAttachment> maybeAttachmentFrom = Optional.ofNullable(from.getAttachment());
        maybeAttachmentFrom.ifPresent(attachmentFrom -> {
            MAttachment attachmentTo = new MAttachment(this.getCtx(), 0, this.get_TrxName());
            attachmentTo.setAD_Table_ID(to.get_Table_ID());
            attachmentTo.setRecord_ID(to.get_ID());
            Arrays.asList(attachmentFrom.getEntries()).stream().forEach(entry -> attachmentTo.addEntry(entry.getFile()));
            attachmentTo.saveEx();
        });
        return true;
    }

    private HashMap<String, Integer> getReferences(String key, Integer value) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put(key, value);
        return result;
    }

    private GenericPO getActiveRegistrationTo(MRegistration activeRegistrationFrom, int activeRegistrationToId) {
        GenericPO result = null;
        if (activeRegistrationToId > 0) {
            result = new GenericPO(activeRegistrationFrom.get_TableName(), activeRegistrationFrom.getCtx(), activeRegistrationToId, activeRegistrationFrom.get_TrxName());
        } else {
            result = this.cloneRecord((PO)activeRegistrationFrom, null);
            result.set_ValueOfColumn("Name", (Object)this.getName());
            result.saveEx();
        }
        return result;
    }
}

