/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.model;

import java.sql.ResultSet;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MRegistration;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.csm.model.X_CSM_Cluster;
import org.spin.model.MADAppRegistration;

public class MCSMCluster
extends X_CSM_Cluster {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, MCSMCluster> clustersCache = new CCache("CSM_Cluster", 30);

    public MCSMCluster(Properties ctx, int CSM_Cluster_ID, String trxName) {
        super(ctx, CSM_Cluster_ID, trxName);
    }

    public MCSMCluster(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MCSMCluster getCluster(MADAppRegistration applicationRegistration) {
        AtomicReference<Object> cluster = new AtomicReference<Object>(null);
        Optional<MADAppRegistration> maybeApplicationRegistration = Optional.ofNullable(applicationRegistration);
        maybeApplicationRegistration.ifPresent(appRegistration -> {
            if (appRegistration.get_ValueAsInt("A_Registration_ID") > 0) {
                cluster.set(MCSMCluster.getCluster(new MRegistration(Env.getCtx(), appRegistration.get_ValueAsInt("A_Registration_ID"), null)));
            }
        });
        return cluster.get();
    }

    public static MCSMCluster getCluster(MRegistration activeRegistration) {
        AtomicReference<Object> cluster = new AtomicReference<Object>(null);
        Optional<MRegistration> maybeActiveRegistration = Optional.ofNullable(activeRegistration);
        maybeActiveRegistration.ifPresent(registration -> {
            Optional<Object> maybeCluster = Optional.ofNullable(clustersCache.get((Object)registration.get_ID()));
            String whereClause = "EXISTS(SELECT 1 FROM A_Registration ar WHERE ar.CSM_Cluster_ID = CSM_Cluster.CSM_Cluster_ID AND ar.A_Registration_ID = ?)";
            cluster.set(maybeCluster.orElse(new Query(Env.getCtx(), "CSM_Cluster", whereClause, null).setParameters(new Object[]{registration.get_ID()}).first()));
            if (cluster.get() != null) {
                clustersCache.put((Object)registration.get_ID(), cluster.get());
            }
        });
        return cluster.get();
    }
}

