/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.spin.csm.model.MCSMApplication;
import org.spin.csm.model.MCSMApplicationDependende;
import org.spin.csm.model.X_CSM_ApplicationVersion;

public class MCSMApplicationVersion
extends X_CSM_ApplicationVersion {
    private static final long serialVersionUID = 5448641333159848635L;
    private MCSMApplication application = null;

    public MCSMApplicationVersion(Properties ctx, int CSM_ApplicationVersion_ID, String trxName) {
        super(ctx, CSM_ApplicationVersion_ID, trxName);
    }

    public MCSMApplicationVersion(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCSMApplication getParent() {
        this.application = Optional.ofNullable(this.application).orElse((MCSMApplication)this.getCSM_Application());
        return this.application;
    }

    public String getReleaseURL(boolean asset) {
        return Env.parseVariable((String)(asset ? this.getParent().getReleaseAssetPattern() : this.getParent().getReleasePattern()), (PO)this, (String)this.get_TrxName(), (boolean)true);
    }

    public List<MCSMApplicationDependende> getDependenceAsList() {
        return new Query(this.getCtx(), "CSM_ApplicationDependende", "CSM_ApplicationVersion_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getCSM_ApplicationVersion_ID()}).setOnlyActiveRecords(true).list();
    }

    public String validateDependence() {
        ArrayList versions = new ArrayList();
        List<MCSMApplicationDependende> dependencesList = this.getDependenceAsList();
        dependencesList.forEach(dependence -> this.processDependence((MCSMApplicationDependende)dependence, versions));
        StringBuffer dependenceError = new StringBuffer();
        versions.stream().filter(version -> !version.isValid()).forEach(version -> dependenceError.append(version.getDependenceError()));
        return dependenceError.toString();
    }

    public List<MCSMApplicationVersion> getListVersion() {
        ArrayList versions = new ArrayList();
        List<MCSMApplicationDependende> dependencesList = this.getDependenceAsList();
        ArrayList<MCSMApplicationVersion> appVersions = new ArrayList<MCSMApplicationVersion>();
        dependencesList.forEach(dependence -> this.processDependence((MCSMApplicationDependende)dependence, versions));
        versions.stream().filter(version -> version.isValid()).forEach(version -> appVersions.addAll(version.getValidVersions()));
        return appVersions;
    }

    public String getApplicationName() {
        MCSMApplication application = this.getParent();
        return application.getValue() + " - " + application.getName();
    }

    private void processDependence(MCSMApplicationDependende dependence, List<DependenceReference> versions) {
        this.processDependence(dependence, versions, this);
    }

    private void processDependence(MCSMApplicationDependende dependence, List<DependenceReference> versions, MCSMApplicationVersion mainVersion) {
        MCSMApplicationVersion parentVersion = new MCSMApplicationVersion(this.getCtx(), dependence.getCSM_ParentVersion_ID(), this.get_TrxName());
        Optional<DependenceReference> reference = versions.stream().filter(referenceValue -> referenceValue.getApplicationId() == mainVersion.getCSM_Application_ID()).findFirst();
        if (reference.isPresent()) {
            reference.get().addCalling(dependence.getCSM_ParentApplication_ID(), dependence.getCSM_ParentVersion_ID(), dependence.getCSM_ApplicationVersion_ID());
        } else {
            DependenceReference referenceValue2 = new DependenceReference(dependence.getCSM_ApplicationVersion().getCSM_Application_ID(), dependence.getCSM_ApplicationVersion().getCSM_Application().getName());
            referenceValue2.addCalling(dependence.getCSM_ParentApplication_ID(), dependence.getCSM_ParentVersion_ID(), dependence.getCSM_ApplicationVersion_ID());
            versions.add(referenceValue2);
        }
        parentVersion.getDependenceAsList().forEach(parentDependence -> this.processDependence((MCSMApplicationDependende)parentDependence, versions, mainVersion));
    }

    @Override
    public String toString() {
        return "MCSMApplicationVersion [getCSM_Application_ID()=" + this.getCSM_Application_ID() + ", getCSM_ApplicationVersion_ID()=" + this.getCSM_ApplicationVersion_ID() + ", getName()=" + this.getName() + ", getReleaseDate()=" + this.getReleaseDate() + ", getReleaseNo()=" + this.getReleaseNo() + ", getReleaseTag()=" + this.getReleaseTag() + "]";
    }

    private class DependenceReference {
        private int applicationId;
        private String applicationName;
        private Map<Integer, Integer> applicationReference;
        private Map<Integer, Integer> applicationDependence;
        private List<Integer> invalidApplications;

        public DependenceReference(int applicationId, String applicationName) {
            this.applicationId = applicationId;
            this.applicationName = applicationName;
            this.applicationReference = new LinkedHashMap<Integer, Integer>();
            this.applicationDependence = new LinkedHashMap<Integer, Integer>();
            this.invalidApplications = new ArrayList<Integer>();
        }

        public void addCalling(int applicationId, int versionId, int parentApplicationId) {
            this.applicationReference.put(versionId, applicationId);
            this.applicationDependence.put(versionId, parentApplicationId);
            this.invalidApplications = this.getInvalidDependences();
        }

        public int getApplicationId() {
            return this.applicationId;
        }

        public boolean isValid() {
            return this.invalidApplications.size() == 0;
        }

        private List<Integer> getInvalidDependences() {
            return this.applicationReference.values().stream().distinct().filter(application -> this.applicationReference.values().stream().filter(appVersion -> application.equals(appVersion)).count() > 1L).filter(application -> this.applicationReference.entrySet().stream().filter(appVersion -> ((Integer)appVersion.getValue()).equals(application)).distinct().count() > 1L).collect(Collectors.toList());
        }

        public String getDependenceError() {
            if (this.isValid()) {
                return null;
            }
            StringBuffer error = new StringBuffer();
            this.applicationReference.entrySet().stream().filter(appVersion -> this.invalidApplications.indexOf(appVersion.getValue()) >= 0).forEach(reference -> {
                MCSMApplication application = new MCSMApplication(MCSMApplicationVersion.this.getCtx(), (Integer)reference.getValue(), MCSMApplicationVersion.this.get_TrxName());
                MCSMApplicationVersion version = new MCSMApplicationVersion(MCSMApplicationVersion.this.getCtx(), (Integer)reference.getKey(), MCSMApplicationVersion.this.get_TrxName());
                MCSMApplicationVersion parentVersion = new MCSMApplicationVersion(MCSMApplicationVersion.this.getCtx(), this.applicationDependence.get(reference.getKey()), MCSMApplicationVersion.this.get_TrxName());
                error.append(Env.NL).append(parentVersion.getApplicationName()).append(": ");
                error.append(Env.NL);
                error.append(" @RequiredVersion@ ").append(version.getReleaseNo()).append(" @ReleaseDate@ ").append(DisplayType.getDateFormat().format(version.getReleaseDate())).append(" @From@ @CSM_Application_ID@ (").append(application.getValue() + " - " + application.getName()).append(")");
            });
            return error.toString();
        }

        public List<MCSMApplicationVersion> getValidVersions() {
            if (!this.isValid()) {
                return new ArrayList<MCSMApplicationVersion>();
            }
            ArrayList<MCSMApplicationVersion> validVersions = new ArrayList<MCSMApplicationVersion>();
            this.applicationReference.entrySet().stream().filter(appVersion -> this.invalidApplications.indexOf(appVersion.getValue()) < 0).forEach(reference -> validVersions.add(new MCSMApplicationVersion(MCSMApplicationVersion.this.getCtx(), (Integer)reference.getKey(), MCSMApplicationVersion.this.get_TrxName())));
            return validVersions;
        }

        public String toString() {
            return "DependenceReference [applicationId=" + this.applicationId + ", applicationName=" + this.applicationName + ", applicationReference=" + this.applicationReference + ", invalidApplications=" + this.invalidApplications + "]";
        }
    }
}

