/*
 * Decompiled with CFR 0.152.
 */
package org.spin.csm.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.csm.model.X_CSM_ApplicationType;

public class MCSMApplicationType
extends X_CSM_ApplicationType {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MCSMApplicationType> applicationTypeCacheIds = new CCache("CSM_ApplicationType", 30);
    private static CCache<String, MCSMApplicationType> applicationTypeCacheValues = new CCache("CSM_ApplicationType", 30);

    public MCSMApplicationType(Properties ctx, int CSM_ApplicationType_ID, String trxName) {
        super(ctx, CSM_ApplicationType_ID, trxName);
    }

    public MCSMApplicationType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MRole> getRolesAsList() {
        return new Query(this.getCtx(), "AD_Role", "EXISTS(SELECT 1 FROM CSM_ApplicationTypeRole atr WHERE atr.AD_Role_ID = AD_Role.AD_Role_ID AND atr.CSM_ApplicationType_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.getCSM_ApplicationType_ID()}).list();
    }

    public static MCSMApplicationType getById(Properties ctx, int applicationTypeId, String trxName) {
        if (applicationTypeId <= 0) {
            return null;
        }
        MCSMApplicationType applicationType = (MCSMApplicationType)applicationTypeCacheIds.get((Object)applicationTypeId);
        if (applicationType != null && applicationType.get_ID() > 0) {
            return applicationType;
        }
        applicationType = (MCSMApplicationType)new Query(ctx, "CSM_ApplicationType", "CSM_ApplicationType_ID=?", trxName).setClient_ID().setParameters(new Object[]{applicationTypeId}).first();
        if (applicationType != null && applicationType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + applicationType.getValue();
            applicationTypeCacheValues.put((Object)key, (Object)applicationType);
            applicationTypeCacheIds.put((Object)applicationType.get_ID(), (Object)applicationType);
        }
        return applicationType;
    }

    public static MCSMApplicationType getByValue(Properties ctx, String applicationTypevalue, String trxName) {
        int clientId;
        String key;
        MCSMApplicationType applicationType;
        if (applicationTypevalue == null) {
            return null;
        }
        if (applicationTypeCacheValues.size() == 0) {
            MCSMApplicationType.getAll(ctx, true, trxName);
        }
        if ((applicationType = (MCSMApplicationType)applicationTypeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + applicationTypevalue))) != null && applicationType.get_ID() > 0) {
            return applicationType;
        }
        applicationType = (MCSMApplicationType)new Query(ctx, "CSM_ApplicationType", "Value=?", trxName).setClient_ID().setParameters(new Object[]{applicationTypevalue}).first();
        if (applicationType != null && applicationType.get_ID() > 0) {
            applicationTypeCacheValues.put((Object)key, (Object)applicationType);
            applicationTypeCacheIds.put((Object)applicationType.get_ID(), (Object)applicationType);
        }
        return applicationType;
    }

    public static List<MCSMApplicationType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || applicationTypeCacheIds.size() > 0) {
            List applicationTypesList = new Query(Env.getCtx(), "CSM_ApplicationType", null, trxName).setClient_ID().setOrderBy("Name").list();
            applicationTypesList.stream().forEach(applicationType -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + applicationType.getValue();
                applicationTypeCacheIds.put((Object)applicationType.getCSM_ApplicationType_ID(), applicationType);
                applicationTypeCacheValues.put((Object)key, applicationType);
            });
            return applicationTypesList;
        }
        List<MCSMApplicationType> applicationTypesList = applicationTypeCacheIds.entrySet().stream().map(applicationType -> (MCSMApplicationType)applicationType.getValue()).collect(Collectors.toList());
        return applicationTypesList;
    }

    @Override
    public String toString() {
        return "MCSMApplicationType [getCSM_ApplicationType_ID()=" + this.getCSM_ApplicationType_ID() + ", getName()=" + this.getName() + ", getValue()=" + this.getValue() + "]";
    }
}

