/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.Adempiere;
import org.compiere.model.MRule;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.X_HR_Concept;
import org.spin.util.RuleEngineUtil;

public class RuleClassGenerator {
    private final String[] VARIABLES = new String[]{"_HR_Employee_Payroll_Value", "_HR_Employee_Contract", "_HR_Employee_ValidFrom", "_HR_Employee_ValidTo", "_HR_Payroll_Value", "_Process", "_Period", "_Payroll", "_Department", "_PeriodNo", "_HR_Period_ID", "SCOPE_PROCESS", "SCOPE_EMPLOYEE", "SCOPE_CONCEPT", "PERSISTENCE_SAVE", "PERSISTENCE_IGNORE", "ACTION_BREAK", "_C_BPartner_ID", "_HR_Employee_ID", "_C_BPartner", "_HR_Employee", "_DateStart", "_DateEnd", "_Days", "_From", "_To"};
    private MRule rule = null;
    private X_HR_Concept concept = null;
    private String directoryName = null;
    private Map<String, Boolean> importClasses = new HashMap<String, Boolean>();
    private static CLogger log = CLogger.getCLogger(RuleClassGenerator.class);

    public RuleClassGenerator(MRule rule, String directory) {
        this.rule = rule;
        this.directoryName = directory;
        this.concept = (X_HR_Concept)new Query(rule.getCtx(), "HR_Concept", "EXISTS(SELECT 1 FROM HR_Attribute a WHERE a.HR_Concept_ID = HR_Concept.HR_Concept_ID AND a.AD_Rule_ID = ?)", rule.get_TrxName()).setParameters(new Object[]{rule.getAD_Rule_ID()}).first();
        this.loadImports();
    }

    private void loadImports() {
        this.importClasses.put("import org.eevolution.model.*;", true);
        this.importClasses.put("import org.compiere.model.*;", true);
        this.importClasses.put("import org.adempiere.model.*;", true);
        this.importClasses.put("import org.compiere.util.*;", true);
        this.importClasses.put("import org.spin.model.*;", true);
        this.importClasses.put("import org.spin.util.*;", true);
        this.importClasses.put("import java.util.*;", true);
        this.importClasses.put("import java.math.*;", true);
        this.importClasses.put("import java.sql.*;", true);
    }

    private String extractImports(String script) {
        Pattern importPattern = Pattern.compile("import");
        Matcher importMatcher = importPattern.matcher(script);
        Pattern semicolonPattern = Pattern.compile(";");
        Matcher semicolonMatcher = semicolonPattern.matcher(script);
        while (importMatcher.find()) {
            int beginIndex = importMatcher.start();
            if (!semicolonMatcher.find(beginIndex)) continue;
            String importValue = script.substring(beginIndex, semicolonMatcher.start() + 1);
            this.importClasses.put(importValue, true);
        }
        for (String value : this.importClasses.keySet()) {
            script = script.replace(value, "");
        }
        return script;
    }

    private String getScript() {
        String text = this.rule.getScript().trim().replaceAll("(int )(\\w+)(\\s+){0,}(=)(\\s+){0,}(getConcept)", "int $2 = (int) getConcept").replaceAll("(int )(\\w+)(\\s+){0,}(=)(\\s+){0,}(getAttribute)", "int $2 = (int) getAttribute").replaceAll("(Timestamp )(\\w+)(\\s+){0,}(=)(\\s+){0,}(getConcept)", "Timestamp $2 = (Timestamp) getConcept").replaceAll("(String )(\\w+)(\\s+){0,}(=)(\\s+){0,}(getConcept)", "String $2 = (String) getConcept").replaceAll("(Timestamp )(\\w+)(\\s+){0,}(=)(\\s+){0,}(_Employee)", "Timestamp $2 = (Timestamp) _Employee").replaceAll("String gender = _BPartner.get_Value(\"Gender\");", "String gender = (String) _C_BPartner.get_Value(\"Gender\");").replaceAll("\\bget", "process.get").replace(".process.get", ".get");
        text = this.extractImports(text);
        String resultType = "double";
        String defValue = "0";
        if ("D".equals(this.concept.getColumnType())) {
            resultType = "Timestamp";
            defValue = "null";
        } else if ("T".equals(this.concept.getColumnType())) {
            resultType = "String";
            defValue = "null";
        }
        String script = Env.NL + resultType + " result = " + defValue + ";" + Env.NL + "description = null;" + Env.NL + text;
        return this.changeValues(script).replaceAll("\\R", "\n\t\t");
    }

    public String createFile() {
        if (this.concept == null || this.concept.getHR_Concept_ID() <= 0) {
            return "";
        }
        if (this.rule == null || Util.isEmpty((String)this.rule.getScript())) {
            return "";
        }
        String packageName = RuleEngineUtil.getPackageName(this.rule);
        String className = RuleEngineUtil.getClassName(this.rule);
        StringBuffer header = this.createHeader(packageName, className);
        if (!this.directoryName.endsWith(File.separator)) {
            this.directoryName = this.directoryName + File.separator;
        }
        this.writeToFile(header, this.directoryName + className + ".java");
        return this.directoryName + className + ".java";
    }

    private StringBuffer createHeader(String packageName, String className) {
        String script = this.getScript();
        StringBuffer header = new StringBuffer();
        header.append("/******************************************************************************\n * Product: ADempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 2006-2017 ADempiere Foundation, All Rights Reserved.         *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * or (at your option) any later version.\t\t\t\t\t\t\t\t\t\t*\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * or via info@adempiere.net or http://www.adempiere.net/license.html         *\n *****************************************************************************/\n");
        header.append("\n");
        header.append("package ").append(packageName).append(";\n");
        header.append("\n");
        this.importClasses.keySet().forEach(importValue -> header.append((String)importValue).append("\n"));
        header.append("\n");
        header.append("\n\n/** Generated Process for (").append(this.rule.getValue()).append(" ").append(this.rule.getName()).append(")\n");
        if (this.rule.getDescription() != null) {
            header.append(" *  Description: ").append(this.rule.getDescription()).append("\n");
        }
        if (this.rule.getHelp() != null) {
            header.append(" *  Help: ").append(this.rule.getHelp()).append("\n");
        }
        header.append(" *  @author ADempiere (generated) \n").append(" *  @version ").append(Adempiere.MAIN_VERSION).append("\n").append(" */\n");
        header.append("public class ").append(RuleEngineUtil.getClassName(this.rule)).append(" implements RuleInterface {");
        header.append("\n\n\tString description = null;");
        header.append("\n\n\t@Override").append("\n\tpublic Object run(MHRProcess process, Map<String, Object> engineContext) {").append("\n\t\t").append(script).append("\n\t\treturn result;").append("\n\t}");
        header.append("\n\n\t@Override").append("\n\tpublic String getDescription() {").append("\n\t\treturn description;").append("\n\t}");
        header.append("\n}");
        return header;
    }

    private String changeValues(String script) {
        AtomicReference<String> newScript = new AtomicReference<String>(script);
        Arrays.asList(this.VARIABLES).stream().filter(variableName -> script.contains((CharSequence)variableName)).forEach(variableName -> newScript.set(((String)newScript.get()).replaceAll("\\b" + variableName + "\\b", this.getValueFromMap((String)variableName))));
        return newScript.get();
    }

    private String getValueFromMap(String variableName) {
        String calling = variableName;
        if (variableName.equals("_Process") || variableName.equals("_Period") || variableName.equals("_Payroll") || variableName.equals("_Department") || variableName.equals("_PeriodNo") || variableName.equals("_HR_Period_ID") || variableName.equals("SCOPE_PROCESS") || variableName.equals("SCOPE_EMPLOYEE") || variableName.equals("SCOPE_CONCEPT") || variableName.equals("PERSISTENCE_SAVE") || variableName.equals("PERSISTENCE_IGNORE") || variableName.equals("ACTION_BREAK") || variableName.equals("_Days") || variableName.equals("_C_BPartner_ID") || variableName.equals("_HR_Employee_ID")) {
            calling = "((Integer) engineContext.get(\"" + variableName + "\"))";
        } else if (variableName.equals("_From") || variableName.equals("_To") || variableName.equals("_HR_Employee_ValidFrom") || variableName.equals("_HR_Employee_ValidTo") || variableName.equals("_DateStart") || variableName.equals("_DateEnd")) {
            calling = "((Timestamp) engineContext.get(\"" + variableName + "\"))";
        } else if (variableName.equals("_HR_Payroll_Value") || variableName.equals("_HR_Employee_Payroll_Value")) {
            calling = "((String) engineContext.get(\"" + variableName + "\"))";
        } else if (variableName.equals("_C_BPartner")) {
            calling = "((MBPartner) engineContext.get(\"" + variableName + "\"))";
        } else if (variableName.equals("_HR_Employee")) {
            calling = "((MHREmployee) engineContext.get(\"" + variableName + "\"))";
        } else if (variableName.equals("_HR_Employee_Contract")) {
            calling = "((MHRContract) engineContext.get(\"" + variableName + "\"))";
        }
        return calling;
    }

    private void writeToFile(StringBuffer sb, String fileName) {
        try {
            File out = new File(fileName);
            if (out.exists()) {
                out.delete();
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == ';' || c == '}') {
                    ((Writer)fw).write(c);
                    continue;
                }
                if (c == '{') {
                    ((Writer)fw).write(c);
                    continue;
                }
                ((Writer)fw).write(c);
            }
            ((Writer)fw).flush();
            ((Writer)fw).close();
            float size = out.length();
            log.info(out.getAbsolutePath() + " - " + (size /= 1024.0f) + " kB");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, fileName, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

