/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.model.MRule;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.spin.util.RuleEngineUtil;
import org.spin.util.RuleInterface;

public class PayrollEngineHandler {
    private static PayrollEngineHandler ruleEngineHandler = null;
    private Map<Integer, RuleInterface> ruleEngineMap = new HashMap<Integer, RuleInterface>();
    private static final CLogger logger = CLogger.getCLogger(PayrollEngineHandler.class);

    public static PayrollEngineHandler getInstance() {
        if (ruleEngineHandler == null) {
            ruleEngineHandler = new PayrollEngineHandler();
        }
        return ruleEngineHandler;
    }

    private PayrollEngineHandler() {
    }

    public RuleInterface getRuleEngine(MRule rule) throws Exception {
        if (rule == null) {
            return null;
        }
        if (!this.ruleEngineMap.containsKey(rule.getAD_Rule_ID())) {
            this.loadClass(rule);
            return this.ruleEngineMap.get(rule.getAD_Rule_ID());
        }
        return this.ruleEngineMap.get(rule.getAD_Rule_ID());
    }

    private Class<?> getHandlerClass(MRule rule) {
        String className = RuleEngineUtil.getCompleteClassName(rule);
        if (Util.isEmpty((String)className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (RuleInterface.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != RuleInterface.class) continue;
                logger.log(Level.SEVERE, "Error loading class, Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Loading class Error" + e.getMessage());
        }
        logger.log(Level.SEVERE, "Not found Class: " + className);
        return null;
    }

    private void loadClass(MRule rule) throws Exception {
        Class<?> clazz = this.getHandlerClass(rule);
        RuleInterface generator = null;
        if (clazz == null) {
            logger.log(Level.SEVERE, "Class not found, Using Standard Class");
            generator = null;
            throw new ClassNotFoundException("Class for rule engine not found");
        }
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        generator = (RuleInterface)constructor.newInstance(new Object[0]);
        this.ruleEngineMap.put(rule.getAD_Rule_ID(), generator);
    }
}

