/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommission;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.MRule;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.Scriptlet;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.model.I_HR_Period;
import org.eevolution.model.MHRAttribute;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRConceptCategory;
import org.eevolution.model.MHRConceptType;
import org.eevolution.model.MHRContract;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPayrollConcept;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.X_HR_Process;
import org.eevolution.service.HRProcessActionMsg;
import org.spin.util.PayrollEngineHandler;
import org.spin.util.RuleInterface;
import org.spin.util.TNAUtil;

public class MHRProcess
extends X_HR_Process
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = -8553627333715790110L;
    public int partnerId = 0;
    public int userId = 0;
    public int payrollConceptId = 0;
    public int payrollId = 0;
    public int departmentId = 0;
    public int jobId = 0;
    public String columnType = "";
    public Timestamp dateFrom;
    public Timestamp dateTo;
    private MHRPayroll payroll = null;
    public Hashtable<Integer, MHRMovement> movements = new Hashtable();
    public MHRPayrollConcept[] payrollConcepts;
    private MHREmployee employee;
    private MBPartner businessPartner;
    HashMap<String, Object> scriptCtx = new HashMap();
    private List<MHRConcept> activeConceptRule = new ArrayList<MHRConcept>();
    private Map<String, MHRMovement> lastConceptMap = new HashMap<String, MHRMovement>();
    private Map<String, BigDecimal> conceptAgregateMap = new HashMap<String, BigDecimal>();
    private Map<String, MHRAttribute> attributeInstanceMap = new HashMap<String, MHRAttribute>();
    private static CLogger logger = CLogger.getCLogger(MHRProcess.class);
    public static final String CONCEPT_PP_COST_COLLECTOR_LABOR = "PP_COST_COLLECTOR_LABOR";
    private Object description = null;
    private HRProcessActionMsg actionScope = null;
    private static StringBuffer s_scriptImport = new StringBuffer(" import org.eevolution.model.*;" + Env.NL + "import org.compiere.model.*;" + Env.NL + "import org.adempiere.model.*;" + Env.NL + "import org.compiere.util.*;" + Env.NL + "import org.spin.model.*;" + Env.NL + "import org.spin.util.*;" + Env.NL + "import java.util.*;" + Env.NL + "import java.math.*;" + Env.NL + "import java.sql.*;");
    private String processMsg = null;
    private boolean justPrepared = false;
    private boolean isReversal = false;

    public static void addScriptImportPackage(String packageName) {
        s_scriptImport.append(" import ").append(packageName).append(";");
    }

    public MHRProcess(Properties ctx, int HR_Process_ID, String trxName) {
        super(ctx, HR_Process_ID, trxName);
        if (HR_Process_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
            this.setC_DocType_ID(0);
            this.set_ValueNoCheck("DocumentNo", null);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setHR_Department_ID(0);
            this.setC_BPartner_ID(0);
        }
    }

    public MHRProcess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public final void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() <= 0) {
            return;
        }
        String sql = "UPDATE HR_Process SET Processed=? WHERE HR_Process_ID=?";
        DB.executeUpdateEx((String)"UPDATE HR_Process SET Processed=? WHERE HR_Process_ID=?", (Object[])new Object[]{processed, this.get_ID()}, (String)this.get_TrxName());
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Client_ID() == 0) {
            throw new AdempiereException("@AD_Client_ID@ = 0");
        }
        if (this.getAD_Org_ID() == 0) {
            int context_AD_Org_ID = this.getAD_Org_ID();
            if (context_AD_Org_ID == 0) {
                throw new AdempiereException("@AD_Org_ID@ = *");
            }
            this.setAD_Org_ID(context_AD_Org_ID);
            logger.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        return true;
    }

    public boolean processIt(String processAction) {
        this.processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        logger.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        logger.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        logger.info("prepareIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        this.reActivateIt();
        MHRPeriod period = MHRPeriod.getById((Properties)this.getCtx(), (int)this.getHR_Period_ID(), (String)this.get_TrxName());
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)(this.getHR_Period_ID() > 0 ? period.getDateAcct() : this.getDateAcct()), (int)this.getC_DocTypeTarget_ID(), (int)this.getAD_Org_ID());
        if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        try {
            this.createMovements();
        }
        catch (Exception exception) {
            this.deleteMovements();
            throw new AdempiereException((Throwable)exception);
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public String completeIt() {
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (this.processMsg != null) {
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean approveIt() {
        return true;
    }

    public boolean rejectIt() {
        logger.info("rejectIt - " + this.toString());
        return true;
    }

    public boolean postIt() {
        logger.info("postIt - " + this.toString());
        return false;
    }

    public boolean voidIt() {
        logger.info("voidIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            List<MHRMovement> lines = MHRMovement.findByProcess(this);
            for (MHRMovement movement : lines) {
                BigDecimal oldAmount = movement.getAmount();
                if (oldAmount.signum() == 0) continue;
                movement.setAmount(Env.ZERO);
                movement.setDescription("Void (" + oldAmount + ")");
                movement.saveEx();
            }
        } else {
            boolean isAccrual = false;
            try {
                MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
            }
            catch (PeriodClosedException periodClosedException) {
                isAccrual = true;
            }
            if (isAccrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.setProcessed(true);
        this.setDocStatus("VO");
        this.saveEx();
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        return this.processMsg == null;
    }

    public boolean closeIt() {
        if (this.isProcessed()) {
            logger.info(this.toString());
            this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
            if (this.processMsg != null) {
                return false;
            }
            this.setProcessed(true);
            this.setDocAction("--");
            this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
            return this.processMsg == null;
        }
        return false;
    }

    public MHRProcess reverseIt(boolean isAccrual) {
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElseGet(() -> currentDate) : this.getDateAcct();
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)reversalDate, (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
        MHRProcess reversal = MHRProcess.copyFrom(this, this.getDateAcct(), this.getC_DocType_ID(), false, this.get_TrxName(), true);
        if (reversal == null) {
            this.processMsg = "Could not create Payroll Process Reversal";
            return null;
        }
        reversal.setReversal_ID(this.getHR_Process_ID());
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.setProcessed(true);
        reversal.setName("(" + reversal.getDocumentNo() + " -> " + this.getDocumentNo() + ")");
        reversal.saveEx();
        this.processMsg = reversal.getDocumentNo();
        this.setProcessed(true);
        this.setReversal_ID(reversal.getHR_Process_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setProcessed(true);
        this.setDocAction("--");
        this.setName("(" + this.getName() + " <- " + reversal.getDocumentNo() + ")");
        this.saveEx();
        return reversal;
    }

    public boolean reverseCorrectIt() {
        logger.info("reverseCorrectIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.processMsg != null) {
            return false;
        }
        MHRProcess reversal = this.reverseIt(false);
        if (reversal == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        return this.processMsg == null;
    }

    public boolean reverseAccrualIt() {
        logger.info("reverseAccrualIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.processMsg != null) {
            return false;
        }
        MHRProcess reversal = this.reverseIt(true);
        if (reversal == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        return this.processMsg == null;
    }

    public boolean reActivateIt() {
        logger.info("reActivateIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)"HRP", (int)this.getAD_Org_ID());
        int no = this.deleteMovements();
        logger.fine("HR_Process deleted #" + no);
        no = MFactAcct.deleteEx((int)Table_ID, (int)this.getHR_Process_ID(), (String)this.get_TrxName());
        logger.fine("Fact_Acct deleted #" + no);
        this.setProcessed(false);
        this.setDocAction("CO");
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        return this.processMsg == null;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    public String getProcessMsg() {
        return this.processMsg;
    }

    public String getSummary() {
        return "";
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            logger.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (int)0, (int)0);
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public MHRMovement[] getLines(boolean requery) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Process_ID=?");
        params.add(this.getHR_Process_ID());
        whereClause.append("AND (Qty <> 0 OR Amount <> 0)");
        whereClause.append(" AND EXISTS(SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Movement.HR_Concept_ID AND c.IsActive=? AND c.AccountSign<>?)");
        params.add(true);
        params.add("N");
        whereClause.append(" AND EXISTS(SELECT 1 FROM HR_Concept_Acct ca WHERE ca.HR_Concept_ID=HR_Movement.HR_Concept_ID AND ca.IsActive=? AND ca.IsBalancing<>?)");
        params.add(true);
        params.add(true);
        whereClause.append(" AND C_BPartner_ID IS NOT NULL");
        StringBuffer orderByClause = new StringBuffer();
        orderByClause.append("(SELECT bp.C_BP_Group_ID FROM C_BPartner bp WHERE bp.C_BPartner_ID=HR_Movement.C_BPartner_ID)");
        List list = new Query(this.getCtx(), "HR_Movement", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy(orderByClause.toString()).list();
        return list.toArray(new MHRMovement[list.size()]);
    }

    private void loadMovements(Hashtable<Integer, MHRMovement> movements, int partnerId) {
        String whereClause = "HR_Process_ID=? AND C_BPartner_ID=?";
        List list = new Query(this.getCtx(), "HR_Movement", "HR_Process_ID=? AND C_BPartner_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getHR_Process_ID(), partnerId}).list();
        for (MHRMovement movement : list) {
            if (movements.containsKey(movement.getHR_Concept_ID())) {
                MHRMovement lastM = movements.get(movement.getHR_Concept_ID());
                MHRConcept concept = MHRConcept.getById(this.getCtx(), lastM.getHR_Concept_ID(), this.get_TrxName());
                String columntype = concept.getColumnType();
                if (columntype.equals("A")) {
                    movement.addAmount(lastM.getAmount());
                } else if (columntype.equals("Q")) {
                    movement.addQty(lastM.getQty());
                }
            }
            movements.put(movement.getHR_Concept_ID(), movement);
        }
    }

    private Object executeScriptEngine(MHRConcept concept, MRule rule, String columnType) {
        long startTime = System.currentTimeMillis();
        Object result = null;
        try {
            String text = "";
            if (rule.getScript() != null) {
                text = rule.getScript().trim().replaceAll("\\bget", "process.get").replace(".process.get", ".get");
            }
            String script = s_scriptImport.toString() + Env.NL + text;
            ScriptEngine engine = rule.getScriptEngine();
            SimpleScriptContext context = new SimpleScriptContext();
            this.scriptCtx.entrySet().stream().forEach(entry -> context.setAttribute((String)entry.getKey(), entry.getValue(), 100));
            context.setAttribute("description", "", 100);
            Double defaultValue = 0.0;
            if ("D".equals(columnType) || "T".equals(columnType)) {
                defaultValue = null;
            }
            context.setAttribute("result", defaultValue, 100);
            result = engine.eval(script, (ScriptContext)context);
            if (result != null && "@Error@".equals(result.toString())) {
                throw new AdempiereException("@AD_Rule_ID@ @HR_Concept_ID@ " + concept.getValue() + "" + concept.getName() + "\t @@Error@ " + result);
            }
            this.description = context.getAttribute("description");
            long elapsed = System.currentTimeMillis() - startTime;
            logger.info("ScriptResult -> Concept Name " + concept.getName() + " = " + result + " Time elapsed: " + TimeUtil.formatElapsed(elapsed));
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        return result;
    }

    private Object executeScript(MHRConcept concept, int ruleId, String columnType) {
        long startTime = System.currentTimeMillis();
        MRule rule = MRule.get((Properties)this.getCtx(), (int)ruleId);
        Object result = null;
        this.description = null;
        try {
            if (rule == null || rule.getAD_Rule_ID() <= 0) {
                logger.log(Level.WARNING, " @AD_Rule_ID@ @NotFound@");
                return null;
            }
            if (!rule.getEventType().equals("H") || !rule.getRuleType().equals("S")) {
                logger.log(Level.WARNING, " must be of type JSR 223 and event human resource");
                return null;
            }
            boolean isRunned = false;
            if (rule.isRuleClassGenerated()) {
                try {
                    RuleInterface ruleEngine = PayrollEngineHandler.getInstance().getRuleEngine(rule);
                    if (ruleEngine != null) {
                        isRunned = true;
                        result = ruleEngine.run(this, this.scriptCtx);
                        this.description = ruleEngine.getDescription();
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.WARNING, e.getLocalizedMessage());
                }
                catch (Exception e) {
                    throw new AdempiereException((Throwable)e);
                }
            }
            if (!isRunned) {
                if (rule.getEngineName() != null) {
                    return this.executeScriptEngine(concept, rule, columnType);
                }
                String text = "";
                if (rule.getScript() != null) {
                    text = rule.getScript().trim().replaceAll("\\bget", "process.get").replace(".process.get", ".get");
                }
                String resultType = "double";
                String defValue = "0";
                if ("D".equals(columnType)) {
                    resultType = "Timestamp";
                    defValue = "null";
                } else if ("T".equals(columnType)) {
                    resultType = "String";
                    defValue = "null";
                }
                String script = s_scriptImport.toString() + Env.NL + resultType + " result = " + defValue + ";" + Env.NL + "String description = null;" + Env.NL + text;
                Scriptlet engine = new Scriptlet("result", script, this.scriptCtx);
                Exception ex = engine.execute();
                if (ex != null) {
                    throw ex;
                }
                result = engine.getResult(false);
                this.description = engine.getDescription();
            }
            long elapsed = System.currentTimeMillis() - startTime;
            logger.info("ScriptResult -> Concept Name " + concept.getName() + " = " + result + " Time elapsed: " + TimeUtil.formatElapsed(elapsed));
        }
        catch (Exception e) {
            throw new AdempiereException("@HR_Employee_ID@ : " + this.businessPartner.getName() + " " + this.businessPartner.getName2() + " \n @HR_Concept_ID@ " + concept.getValue() + " -> " + concept.getName() + " \n @AD_Rule_ID@=" + rule.getValue() + "\n  Script : " + rule.getScript() + " \n Execution error : \n" + e.getLocalizedMessage());
        }
        return result;
    }

    private void createCostCollectorMovements(int partnerId, MHRPeriod period) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("EXISTS (SELECT 1 FROM AD_User u WHERE u.AD_User_ID=PP_Cost_Collector.AD_User_ID AND u.C_BPartner_ID=?)");
        params.add(partnerId);
        whereClause.append(" AND MovementDate>=?");
        params.add(period.getStartDate());
        whereClause.append(" AND MovementDate<=?");
        params.add(period.getEndDate());
        whereClause.append(" AND DocStatus IN (?,?)");
        params.add("CO");
        params.add("CL");
        List listCollector = new Query(this.getCtx(), "PP_Cost_Collector", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(params).setOrderBy("PP_Cost_Collector_ID DESC").list();
        for (MPPCostCollector costCollector : listCollector) {
            this.createMovementForCostCollector(partnerId, costCollector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MHRMovement createMovementForCostCollector(int partnerId, MPPCostCollector costCollector) {
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), CONCEPT_PP_COST_COLLECTOR_LABOR, costCollector.get_TrxName());
        ArrayList<Comparable<Date>> params = new ArrayList<Comparable<Date>>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("? >= ValidFrom AND ( ? <= ValidTo OR ValidTo IS NULL)");
        params.add(this.dateFrom);
        params.add(this.dateTo);
        if (this.payrollId > 0) {
            whereClause.append(" AND (HR_Payroll_ID=? OR HR_Payroll_ID IS NULL)");
            params.add(Integer.valueOf(this.payrollId));
        }
        if (this.departmentId > 0) {
            whereClause.append(" AND (HR_Department_ID=? OR HR_Payroll_ID IS NULL)");
            params.add(Integer.valueOf(this.departmentId));
        }
        if (this.jobId > 0) {
            whereClause.append(" AND (HR_Job_ID=? OR HR_Job_ID IS NULL)");
            params.add(Integer.valueOf(this.jobId));
        }
        whereClause.append(" AND HR_Concept_ID = ? ");
        params.add(Integer.valueOf(concept.get_ID()));
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        MHRAttribute attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        if (attribute == null) {
            throw new AdempiereException();
        }
        if ("E".equals(concept.getType())) {
            Object result;
            this.scriptCtx.put("_CostCollector", costCollector);
            try {
                result = this.executeScript(concept, attribute.getAD_Rule_ID(), attribute.getColumnType());
            }
            finally {
                this.scriptCtx.remove("_CostCollector");
            }
            MHREmployee employee = MHREmployee.getActiveEmployee((Properties)this.getCtx(), (int)partnerId, (String)this.get_TrxName());
            MHRMovement movement = new MHRMovement(this, concept);
            movement.setHR_Attribute_ID(attribute.getHR_Attribute_ID());
            movement.setC_BPartner_ID(partnerId);
            movement.setDescription(attribute.getDescription());
            movement.setReferenceNo(attribute.getReferenceNo());
            movement.setC_BP_Relation_ID(attribute.getC_BP_Relation_ID());
            movement.setAD_Rule_ID(attribute.getAD_Rule_ID());
            movement.setValidFrom(this.dateFrom);
            movement.setValidTo(this.dateTo);
            movement.setPP_Cost_Collector_ID(costCollector.getPP_Cost_Collector_ID());
            movement.setIsManual(true);
            movement.setColumnValue(result);
            movement.setProcessed(true);
            int bpGroupId = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT C_BP_Group_ID FROM C_BPartner WHERE C_BPartner_ID=?", (int)this.partnerId);
            movement.setC_BP_Group_ID(bpGroupId);
            movement.setEmployee(employee);
            movement.saveEx();
            return movement;
        }
        throw new AdempiereException();
    }

    private void createMovements() throws Exception {
        MHRPeriod payrollPeriod;
        logger.info("CreateMovements #");
        long startTime = System.currentTimeMillis();
        this.scriptCtx.clear();
        this.lastConceptMap = new HashMap<String, MHRMovement>();
        this.conceptAgregateMap = new HashMap<String, BigDecimal>();
        this.attributeInstanceMap = new HashMap<String, MHRAttribute>();
        logger.info("info data - Process " + this.getHR_Process_ID() + ", Period :" + this.getHR_Period_ID() + ", Payroll : " + this.getHR_Payroll_ID() + ", @HR_Department_ID@ : " + this.getHR_Department_ID());
        if (this.getHR_Period_ID() > 0) {
            payrollPeriod = MHRPeriod.getById((Properties)this.getCtx(), (int)this.getHR_Period_ID(), (String)this.get_TrxName());
        } else {
            payrollPeriod = new MHRPeriod(this.getCtx(), 0, this.get_TrxName());
            MPeriod period = MPeriod.get((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getAD_Org_ID());
            if (period != null) {
                payrollPeriod.setStartDate(period.getStartDate());
                payrollPeriod.setEndDate(period.getEndDate());
            } else {
                payrollPeriod.setStartDate(this.getDateAcct());
                payrollPeriod.setEndDate(this.getDateAcct());
            }
        }
        this.dateFrom = payrollPeriod.getStartDate();
        this.dateTo = payrollPeriod.getEndDate();
        this.payroll = MHRPayroll.getById((Properties)this.getCtx(), (int)this.getHR_Payroll_ID(), (String)this.get_TrxName());
        this.scriptCtx.put("process", (Object)this);
        this.scriptCtx.put("_Process", this.getHR_Process_ID());
        this.scriptCtx.put("_Period", this.getHR_Period_ID());
        this.scriptCtx.put("_Payroll", this.getHR_Payroll_ID());
        this.scriptCtx.put("_Department", this.getHR_Department_ID());
        this.scriptCtx.put("_From", this.dateFrom);
        this.scriptCtx.put("_To", this.dateTo);
        this.scriptCtx.put("_Period", payrollPeriod.getPeriodNo());
        this.scriptCtx.put("_PeriodNo", payrollPeriod.getPeriodNo());
        this.scriptCtx.put("_HR_Period_ID", this.getHR_Period_ID());
        this.scriptCtx.put("_HR_Payroll_Value", this.payroll.getValue());
        this.scriptCtx.put("SCOPE_PROCESS", 1);
        this.scriptCtx.put("SCOPE_EMPLOYEE", 2);
        this.scriptCtx.put("SCOPE_CONCEPT", 3);
        this.scriptCtx.put("PERSISTENCE_SAVE", 1);
        this.scriptCtx.put("PERSISTENCE_IGNORE", 2);
        this.scriptCtx.put("ACTION_BREAK", 1);
        if (this.getHR_Payroll_ID() > 0) {
            this.payrollId = this.getHR_Payroll_ID();
        }
        if (this.getHR_Department_ID() > 0) {
            this.departmentId = this.getHR_Department_ID();
        }
        if (this.getHR_Job_ID() > 0) {
            this.jobId = this.getHR_Job_ID();
        }
        this.payrollConcepts = MHRPayrollConcept.getPayrollConcepts((MHRProcess)this);
        this.actionScope = new HRProcessActionMsg();
        for (MBPartner employee : MHREmployee.getEmployees((MHRProcess)this)) {
            this.calculateMovements(employee, payrollPeriod);
            if (!this.actionScope.isProcessScope() || !this.actionScope.isBreakRunning()) continue;
            this.actionScope.clearAction();
            this.actionScope.clearScope();
            this.actionScope.clearPersistence();
            break;
        }
        if (this.getHR_Period_ID() > 0) {
            payrollPeriod.setProcessed(true);
            payrollPeriod.saveEx();
        }
        logger.info("Calculation for CreateMovements # Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - startTime));
    }

    public HRProcessActionMsg scope(int scope) {
        return this.actionScope.scope(scope);
    }

    private void calculateMovements(MBPartner partner, MHRPeriod payrollPeriod) {
        logger.info("Employee # " + partner.getValue() + " - " + partner.getName() + " " + partner.getName2());
        long startTime = System.currentTimeMillis();
        this.partnerId = partner.get_ID();
        this.businessPartner = partner;
        this.employee = MHREmployee.getActiveEmployee((Properties)this.getCtx(), (int)this.partnerId, (String)this.get_TrxName());
        if (this.employee == null) {
            return;
        }
        String employeePayrollValue = null;
        if (this.employee.getHR_Payroll_ID() != 0) {
            MHRPayroll employeePayroll = MHRPayroll.getById((Properties)this.getCtx(), (int)this.employee.getHR_Payroll_ID(), (String)this.get_TrxName());
            employeePayrollValue = employeePayroll.getValue();
        }
        Timestamp employeeValidFrom = this.dateFrom;
        Timestamp employeeValidTo = this.dateTo;
        if (this.employee.getStartDate() != null && this.dateFrom != null && this.employee.getStartDate().getTime() > this.dateFrom.getTime()) {
            employeeValidFrom = this.employee.getStartDate();
        }
        if (this.employee.getEndDate() != null && this.dateTo != null && this.employee.getEndDate().getTime() < this.dateTo.getTime()) {
            employeeValidTo = this.employee.getEndDate();
        }
        this.scriptCtx.remove("_DateStart");
        this.scriptCtx.remove("_DateEnd");
        this.scriptCtx.remove("_Days");
        this.scriptCtx.remove("_C_BPartner_ID");
        this.scriptCtx.remove("_HR_Employee_ID");
        this.scriptCtx.remove("_C_BPartner");
        this.scriptCtx.remove("_HR_Employee");
        this.scriptCtx.remove("_HR_Employee_ValidFrom");
        this.scriptCtx.remove("_HR_Employee_ValidTo");
        this.scriptCtx.remove("_HR_Employee_Payroll_Value");
        this.scriptCtx.remove("_HR_Employee_Contract");
        this.scriptCtx.put("_DateStart", this.employee.getStartDate());
        this.scriptCtx.put("_DateEnd", this.employee.getEndDate() == null ? (this.dateTo == null ? this.getDateAcct() : this.dateTo) : this.employee.getEndDate());
        this.scriptCtx.put("_Days", TimeUtil.getDaysBetween(payrollPeriod.getStartDate(), payrollPeriod.getEndDate(), new int[0]) + 1);
        this.scriptCtx.put("_C_BPartner_ID", partner.getC_BPartner_ID());
        this.scriptCtx.put("_HR_Employee_ID", this.employee.getHR_Employee_ID());
        this.scriptCtx.put("_C_BPartner", partner);
        this.scriptCtx.put("_HR_Employee", this.employee);
        this.scriptCtx.put("_HR_Employee_Payroll_Value", employeePayrollValue);
        this.scriptCtx.put("_HR_Employee_ValidFrom", employeeValidFrom);
        this.scriptCtx.put("_HR_Employee_ValidTo", employeeValidTo);
        if (this.employee.getHR_Payroll_ID() > 0) {
            MHRPayrollConcept[] contract = MHRContract.getById((Properties)this.getCtx(), (int)this.employee.getHR_Payroll().getHR_Contract_ID(), (String)this.get_TrxName());
            this.scriptCtx.put("_HR_Employee_Contract", contract);
        }
        if (this.getHR_Period_ID() > 0) {
            this.createCostCollectorMovements(partner.get_ID(), payrollPeriod);
        }
        this.movements.clear();
        this.loadMovements(this.movements, this.partnerId);
        for (MHRPayrollConcept payrollConcept : this.payrollConcepts) {
            if (this.actionScope.isConceptScope() && this.actionScope.isBreakRunning()) {
                this.actionScope.clearAction();
                this.actionScope.clearScope();
                this.actionScope.clearPersistence();
                continue;
            }
            this.payrollConceptId = payrollConcept.getHR_Concept_ID();
            MHRConcept concept = MHRConcept.getById(this.getCtx(), this.payrollConceptId, this.get_TrxName());
            boolean printed = payrollConcept.isPrinted() || concept.isPrinted();
            MHRMovement movement2 = this.movements.get(concept.get_ID());
            if (movement2 == null) {
                this.scriptCtx.remove("_HR_Concept_ID");
                this.scriptCtx.remove("_HR_Concept");
                this.scriptCtx.put("_HR_Concept_ID", concept.getHR_Concept_ID());
                this.scriptCtx.put("_HR_Concept", concept);
                this.scriptCtx.remove("_HR_PayrollConcept_ID");
                this.scriptCtx.put("_HR_PayrollConcept_ID", payrollConcept.getHR_PayrollConcept_ID());
                this.createMovementFromConcept(concept, printed);
                movement2 = this.movements.get(concept.get_ID());
                if (movement2 == null) {
                    throw new AdempiereException("Concept " + concept.getValue() + " not created");
                }
                movement2.setHR_Payroll_ID(payrollConcept.getHR_Payroll_ID());
                movement2.setHR_PayrollConcept_ID(payrollConcept.getHR_PayrollConcept_ID());
                movement2.setPeriodNo(payrollPeriod.getPeriodNo());
            }
            if (!this.actionScope.isEmployeeScope() && !this.actionScope.isProcessScope() || !this.actionScope.isBreakRunning()) continue;
            if (!this.actionScope.isEmployeeScope()) break;
            this.actionScope.clearScope();
            this.actionScope.clearAction();
            break;
        }
        if (this.actionScope.isIgnorePersistence()) {
            this.actionScope.clearPersistence();
            return;
        }
        logger.info("Calculation for Employee # " + partner.getValue() + " - " + partner.getName() + " " + partner.getName2() + " Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - startTime));
        long startSavingTime = System.currentTimeMillis();
        this.movements.values().stream().filter(movement -> movement.getHR_Concept_ID() != 0).forEach(movement -> {
            long startSavingMovementTime = System.currentTimeMillis();
            MHRConcept concept = MHRConcept.getById(this.getCtx(), movement.getHR_Concept_ID(), this.get_TrxName());
            if (concept != null && concept.get_ID() > 0) {
                if (concept.isManual()) {
                    logger.fine("Skip saving " + (Object)movement);
                } else {
                    boolean saveThisRecord;
                    boolean bl = saveThisRecord = !(!concept.isSaveInHistoric() && !movement.isPrinted() && !concept.isPaid() && !concept.isPrinted() || concept.isNotSaveInHistoryIfNull() && movement.isEmpty());
                    if (saveThisRecord) {
                        movement.saveEx();
                    }
                }
            }
            logger.info("Saving Concept " + concept.getValue() + " - " + concept.getName() + " Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - startSavingMovementTime));
        });
        logger.info("Saving for Employee # " + partner.getValue() + " - " + partner.getName() + " " + partner.getName2() + " Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - startSavingTime));
        logger.info("Employee # " + partner.getValue() + " - " + partner.getName() + " " + partner.getName2() + " Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - startTime));
        this.actionScope.clearPersistence();
    }

    private int deleteMovements() {
        int no = DB.executeUpdateEx((String)"DELETE FROM HR_Movement m WHERE HR_Process_ID=? AND IsManual<>?", (Object[])new Object[]{this.getHR_Process_ID(), true}, (String)this.get_TrxName());
        logger.info("Movements Deleted #" + no);
        return no;
    }

    private void createMovementFromConcept(MHRConcept concept, boolean isPrinted) {
        logger.info("Calculating -> Concept " + concept.getValue() + " -> " + concept.getName());
        this.columnType = concept.getColumnType();
        MHRAttribute attribute = MHRAttribute.getByConceptAndEmployee(concept, this.employee, this.getHR_Payroll_ID(), this.dateFrom, this.dateTo);
        if (attribute == null || concept.isManual()) {
            this.createDummyMovement(concept);
            return;
        }
        logger.info("Concept : " + concept.getName());
        MHRMovement movement = this.createMovement(concept, attribute, isPrinted);
        if ("E".equals(concept.getType())) {
            logger.info("Processing -> Rule to Concept " + concept.getValue());
            if (this.activeConceptRule.contains(concept)) {
                throw new AdempiereException("Recursion loop detected in concept " + concept.getValue());
            }
            this.activeConceptRule.add(concept);
            Object result = this.executeScript(concept, attribute.getAD_Rule_ID(), attribute.getColumnType());
            this.activeConceptRule.remove(concept);
            movement.setColumnValue(result);
            if (this.description != null) {
                movement.setDescription(this.description.toString());
            }
        }
        movement.setProcessed(true);
        this.movements.put(concept.getHR_Concept_ID(), movement);
    }

    private void createDummyMovement(MHRConcept concept) {
        logger.info("Skip concept " + concept + " - attribute not found");
        MHRMovement dummyMovement = new MHRMovement(this.getCtx(), 0, concept.get_TrxName());
        dummyMovement.setSeqNo(concept.getSeqNo());
        dummyMovement.setIsManual(true);
        this.movements.put(concept.getHR_Concept_ID(), dummyMovement);
    }

    public double getMonthlySalary(String trxName) {
        BigDecimal monthtlySalary = this.employee.getMonthlySalary();
        if (monthtlySalary != null && !monthtlySalary.equals(Env.ZERO)) {
            return monthtlySalary.doubleValue();
        }
        if (this.employee.getHR_Payroll_ID() != 0) {
            MHRPayroll payroll = MHRPayroll.getById((Properties)this.getCtx(), (int)this.employee.getHR_Payroll_ID(), (String)trxName);
            MHRContract contract = MHRContract.getById((Properties)this.getCtx(), (int)payroll.getHR_Contract_ID(), (String)trxName);
            if (contract != null && contract.getMonthlySalary_ID() != 0) {
                MHRConcept concept = MHRConcept.getById(this.getCtx(), contract.getMonthlySalary_ID(), trxName);
                return this.getAttribute(concept.getValue());
            }
        }
        return 0.0;
    }

    public double getDailySalary() {
        BigDecimal dailySalary = this.employee.getDailySalary();
        if (dailySalary != null && !dailySalary.equals(Env.ZERO)) {
            return dailySalary.doubleValue();
        }
        if (this.employee.getHR_Payroll_ID() != 0) {
            MHRPayroll payroll = MHRPayroll.getById((Properties)this.getCtx(), (int)this.employee.getHR_Payroll_ID(), (String)this.get_TrxName());
            MHRContract contract = MHRContract.getById((Properties)this.getCtx(), (int)payroll.getHR_Contract_ID(), (String)this.get_TrxName());
            if (contract != null && contract.getDailySalary_ID() != 0) {
                MHRConcept concept = MHRConcept.getById(this.getCtx(), contract.getDailySalary_ID(), this.get_TrxName());
                return this.getAttribute(concept.getValue());
            }
        }
        return 0.0;
    }

    private MHRMovement createMovement(MHRConcept concept, MHRAttribute attribute, boolean isPrinted) {
        I_HR_Period payrollPeriod = this.getHR_Period();
        MHRMovement movement = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
        movement.setAD_Org_ID(this.employee.getAD_Org_ID());
        movement.setSeqNo(concept.getSeqNo());
        movement.setHR_Attribute_ID(attribute.getHR_Attribute_ID());
        movement.setDescription(attribute.getDescription());
        movement.setReferenceNo(attribute.getReferenceNo());
        Optional.ofNullable(payrollPeriod).ifPresent(period -> movement.setPeriodNo(period.getPeriodNo()));
        movement.setC_BPartner_ID(this.partnerId);
        movement.setC_BP_Relation_ID(attribute.getC_BP_Relation_ID());
        movement.setHR_Concept_ID(concept.getHR_Concept_ID());
        movement.setHR_Concept_Category_ID(concept.getHR_Concept_Category_ID());
        movement.setHR_Concept_Type_ID(concept.getHR_Concept_Type_ID());
        movement.setHR_Process_ID(this.getHR_Process_ID());
        movement.setAD_Rule_ID(attribute.getAD_Rule_ID());
        movement.setValidFrom(this.dateFrom);
        movement.setValidTo(this.dateTo);
        movement.setIsPrinted(isPrinted);
        movement.setIsManual(concept.isManual());
        movement.setC_BP_Group_ID(this.businessPartner.getC_BP_Group_ID());
        movement.setEmployee(this.employee);
        if (!"E".equals(concept.getType())) {
            int precision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)Env.getContextAsInt((Properties)this.p_ctx, (String)"#C_Currency_ID"));
            if (concept.getStdPrecision() > 0) {
                precision = concept.getStdPrecision();
            }
            BigDecimal rate = Env.ONE;
            BigDecimal amount = attribute.getAmount();
            if (attribute.isConvertedAmount() && attribute.getC_Currency_ID() != this.getC_Currency_ID() && (rate = MConversionRate.getRate((int)attribute.getC_Currency_ID(), (int)this.getC_Currency_ID(), (Timestamp)this.getDateAcct(), (int)this.getC_ConversionType_ID(), (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID())) != null) {
                amount = rate.multiply(Optional.ofNullable(amount).orElse(Env.ZERO)).setScale(precision, 4);
            }
            movement.setAmount(amount);
            movement.setQty(attribute.getQty());
            movement.setTextMsg(attribute.getTextMsg());
            movement.setServiceDate(attribute.getServiceDate());
        }
        return movement;
    }

    public double getConcept(String conceptValue) {
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue.trim(), this.get_TrxName());
        if (concept == null) {
            return 0.0;
        }
        MHRMovement movement = this.movements.get(concept.get_ID());
        if (movement == null) {
            this.createMovementFromConcept(concept, concept.isPrinted());
            movement = this.movements.get(concept.get_ID());
        }
        if (movement == null) {
            throw new AdempiereException("Concept " + concept.getValue() + " not created");
        }
        String type = concept.getColumnType();
        if ("A".equals(type)) {
            return movement.getAmount().doubleValue();
        }
        if ("Q".equals(type)) {
            return movement.getQty().doubleValue();
        }
        return 0.0;
    }

    public String getConceptString(String pconcept) {
        String type;
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), pconcept.trim(), this.get_TrxName());
        if (concept == null) {
            return null;
        }
        MHRMovement movement = this.movements.get(concept.get_ID());
        if (movement == null) {
            this.createMovementFromConcept(concept, concept.isPrinted());
            movement = this.movements.get(concept.get_ID());
        }
        if ("T".equals(type = concept.getColumnType())) {
            return movement.getTextMsg();
        }
        return null;
    }

    public Timestamp getConceptDate(String conceptValue) {
        String type;
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue.trim(), this.get_TrxName());
        if (concept == null) {
            return null;
        }
        MHRMovement movement = this.movements.get(concept.get_ID());
        if (movement == null) {
            this.createMovementFromConcept(concept, concept.isPrinted());
            movement = this.movements.get(concept.get_ID());
        }
        if ("D".equals(type = concept.getColumnType())) {
            return movement.getServiceDate();
        }
        return null;
    }

    @Deprecated
    public void setConcept(String conceptValue, double value) {
        this.createMovement(conceptValue, value);
    }

    @Deprecated
    public void setConcept(String conceptValue, double value, boolean isManual) {
        this.createMovement(conceptValue, value, isManual);
    }

    public void createMovement(String conceptValue, double value) {
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue, this.get_TrxName());
        if (concept == null) {
            return;
        }
        MHRAttribute attribute = MHRAttribute.getByConceptAndEmployee(concept, this.employee, this.getHR_Payroll_ID(), this.dateFrom, this.dateTo);
        if (attribute == null || concept.isManual()) {
            this.createDummyMovement(concept);
            return;
        }
        MHRMovement movement = this.createMovement(concept, attribute, concept.isPrinted());
        movement.setColumnValue(BigDecimal.valueOf(value));
        movement.saveEx();
        this.movements.put(concept.getHR_Concept_ID(), movement);
    }

    public void createMovement(String conceptValue, double value, boolean isManual) {
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue, this.get_TrxName());
        if (concept == null) {
            return;
        }
        MHRAttribute attribute = MHRAttribute.getByConceptAndEmployee(concept, this.employee, this.getHR_Payroll_ID(), this.dateFrom, this.dateTo);
        if (attribute == null || concept.isManual()) {
            this.createDummyMovement(concept);
            return;
        }
        MHRMovement movement = this.createMovement(concept, attribute, concept.isPrinted());
        if (concept.getColumnType().equals("A")) {
            movement.setAmount(BigDecimal.valueOf(value));
        } else if (concept.getColumnType().equals("Q")) {
            movement.setQty(BigDecimal.valueOf(value));
        } else {
            return;
        }
        movement.setIsManual(isManual);
        movement.saveEx();
        this.movements.put(movement.getHR_Movement_ID(), movement);
    }

    public MHRMovement createMovement(MHRConcept concept, BigDecimal qty, BigDecimal amount, String referenceNo, String description) {
        if (concept == null || concept.getHR_Concept_ID() == 0) {
            throw new AdempiereException("@HR_Concept_ID@ @NotFound@");
        }
        MHRMovement.findByProcessAndConceptIdAndPartnerId(this, concept.getHR_Concept_ID(), this.partnerId, referenceNo, description).stream().filter(movement -> movement != null).forEach(movement -> movement.deleteEx(true));
        MHRAttribute attribute = MHRAttribute.getByConceptAndEmployee(concept, this.employee, this.getHR_Payroll_ID(), this.dateFrom, this.dateTo);
        MHRMovement movement2 = this.createMovement(concept, attribute, concept.isPrinted());
        Optional.ofNullable(qty).ifPresent(q -> movement2.setAmount((BigDecimal)q));
        Optional.ofNullable(amount).ifPresent(a -> movement2.setAmount((BigDecimal)a));
        Optional.ofNullable(referenceNo).ifPresent(rn -> movement2.setReferenceNo((String)rn));
        Optional.ofNullable(description).ifPresent(d -> movement2.setDescription((String)d));
        movement2.saveEx();
        this.movements.put(concept.getHR_Concept_ID(), movement2);
        return movement2;
    }

    public MHRMovement createMovement(String conceptValue, BigDecimal qty, BigDecimal amount, String referenceNo, String description) {
        if (conceptValue == null || conceptValue.length() == 0) {
            throw new AdempiereException("@HR_Concept_ID@ @NotFound@");
        }
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue, this.get_TrxName());
        if (concept == null || concept.getHR_Concept_ID() == 0) {
            throw new AdempiereException("@HR_Concept_ID@ @NotFound@");
        }
        return this.createMovement(concept, qty, amount, referenceNo, description);
    }

    public double getConceptType(String typeValue) {
        MHRConceptType conceptType = MHRConceptType.getByValue((Properties)this.getCtx(), (String)typeValue, (String)this.get_TrxName());
        if (conceptType == null) {
            return 0.0;
        }
        double value = 0.0;
        for (MHRPayrollConcept payrollConcept : this.payrollConcepts) {
            MHRConcept concept = MHRConcept.getById(this.getCtx(), payrollConcept.getHR_Concept_ID(), this.get_TrxName());
            if (concept.getHR_Concept_Type_ID() != conceptType.get_ID()) continue;
            MHRMovement movement = this.movements.get(payrollConcept.getHR_Concept_ID());
            if (movement == null) {
                this.createMovementFromConcept(concept, concept.isPrinted());
            }
            if ((movement = this.movements.get(concept.get_ID())) == null) continue;
            String columnType = concept.getColumnType();
            if ("A".equals(columnType)) {
                value += movement.getAmount().doubleValue();
                continue;
            }
            if (!"Q".equals(columnType)) continue;
            value += movement.getQty().doubleValue();
        }
        return value;
    }

    public double getConceptGroup(String categoryValue) {
        return this.getConceptCategory(categoryValue);
    }

    public double getConceptCategory(String categoryValue) {
        MHRConceptCategory conceptCategory = MHRConceptCategory.getByValue((Properties)this.getCtx(), (String)categoryValue, (String)this.get_TrxName());
        if (conceptCategory == null) {
            return 0.0;
        }
        double value = 0.0;
        for (MHRPayrollConcept payrollConcept : this.payrollConcepts) {
            MHRConcept concept = MHRConcept.getById(this.getCtx(), payrollConcept.getHR_Concept_ID(), this.get_TrxName());
            if (concept.getHR_Concept_Category_ID() != conceptCategory.get_ID()) continue;
            MHRMovement movement = this.movements.get(payrollConcept.getHR_Concept_ID());
            if (movement == null) {
                this.createMovementFromConcept(concept, concept.isPrinted());
            }
            if ((movement = this.movements.get(concept.get_ID())) == null) continue;
            String columnType = concept.getColumnType();
            if ("A".equals(columnType)) {
                value += movement.getAmount().doubleValue();
                continue;
            }
            if (!"Q".equals(columnType)) continue;
            value += movement.getQty().doubleValue();
        }
        return value;
    }

    public double getList(String listSearchKey, double amount, String columnParam) {
        return this.getList(listSearchKey, this.dateFrom, amount, columnParam, this.columnType);
    }

    public double getList(String listSearchKey, Timestamp from, double amount, String columnParam) {
        return this.getList(listSearchKey, from, amount, columnParam, null);
    }

    public double getList(String listSearchKey, Timestamp from, double amount, String columnParam, String columnType) {
        BigDecimal value = Env.ZERO;
        String column = columnParam;
        if ("A".equals(columnType) || columnType == null) {
            column = column.toString().length() == 1 ? "Col_" + column : "Amount" + column;
            ArrayList<Object> params = new ArrayList<Object>();
            String sqlList = "SELECT " + column + " FROM HR_List l INNER JOIN HR_ListVersion lv ON (lv.HR_List_ID=l.HR_List_ID) INNER JOIN HR_ListLine ll ON (ll.HR_ListVersion_ID=lv.HR_ListVersion_ID) WHERE l.IsActive='Y' AND lv.IsActive='Y' AND ll.IsActive='Y' AND l.Value = ? AND l.AD_Client_ID in (?,0) AND (? BETWEEN lv.ValidFrom AND lv.ValidTo ) AND (? BETWEEN ll.MinValue AND\tll.MaxValue) ORDER BY l.AD_CLIENT_ID desc ";
            params.add(listSearchKey);
            params.add(this.getAD_Client_ID());
            params.add(from);
            params.add(BigDecimal.valueOf(amount));
            value = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)sqlList, params);
        }
        if (value == null) {
            throw new IllegalStateException("getList Out of Range");
        }
        return value.doubleValue();
    }

    public MHRAttribute getAttributeInstance(String conceptValue) {
        return this.getAttributeInstance(conceptValue, 0, null);
    }

    public MHRAttribute getAttributeInstance(String conceptValue, int partnerId, Timestamp breakDate) {
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue, this.get_TrxName());
        return this.getAttributeInstance(concept, partnerId, breakDate);
    }

    public MHRAttribute getAttributeInstance(MHRConcept concept, int partnerId, Timestamp breakDate) {
        String key;
        MHRAttribute attribute;
        if (concept == null) {
            return null;
        }
        if (breakDate == null) {
            breakDate = this.dateFrom;
        }
        if (partnerId <= 0) {
            partnerId = this.partnerId;
        }
        if ((attribute = this.attributeInstanceMap.get(key = concept.getValue() + "|" + partnerId + "|" + breakDate.getTime())) != null) {
            return attribute;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("ValidFrom<=?");
        params.add(breakDate);
        whereClause.append(" AND AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        if (this.payrollId > 0) {
            whereClause.append(" AND (HR_Payroll_ID=? OR HR_Payroll_ID IS NULL)");
            params.add(this.payrollId);
        }
        if (this.departmentId > 0) {
            whereClause.append(" AND (HR_Department_ID=? OR HR_Department_ID IS NULL)");
            params.add(this.departmentId);
        }
        if (this.jobId > 0) {
            whereClause.append(" AND (HR_Job_ID=? OR HR_Job_ID IS NULL)");
            params.add(this.jobId);
        }
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID = HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(concept.getValue());
        if (!concept.getType().equals("I")) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(partnerId);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").setOnlyActiveRecords(true).first()) != null) {
            this.attributeInstanceMap.put(key, attribute);
        }
        return attribute;
    }

    public double getAttribute(String conceptValue) {
        return this.getAttribute(conceptValue, null);
    }

    public double getAttribute(String conceptValue, Timestamp breakDate) {
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue, this.get_TrxName());
        if (concept == null) {
            return 0.0;
        }
        MHRAttribute attribute = this.getAttributeInstance(concept, 0, breakDate);
        if (attribute == null) {
            return 0.0;
        }
        if (concept.getColumnType().equals("Q")) {
            return attribute.getQty().doubleValue();
        }
        if (concept.getColumnType().equals("A")) {
            BigDecimal rate = Env.ONE;
            BigDecimal amount = attribute.getAmount();
            if (attribute.isConvertedAmount() && attribute.getC_Currency_ID() != this.getC_Currency_ID()) {
                int precision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)Env.getContextAsInt((Properties)this.p_ctx, (String)"#C_Currency_ID"));
                if (concept.getStdPrecision() > 0) {
                    precision = concept.getStdPrecision();
                }
                if ((rate = MConversionRate.getRate((int)attribute.getC_Currency_ID(), (int)this.getC_Currency_ID(), (Timestamp)this.getDateAcct(), (int)this.getC_ConversionType_ID(), (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID())) != null) {
                    amount = rate.multiply(Optional.ofNullable(amount).orElse(Env.ZERO)).setScale(precision, 4);
                }
            }
            if (amount == null) {
                return 0.0;
            }
            return amount.doubleValue();
        }
        return 0.0;
    }

    public Timestamp getAttributeDate(String conceptValue) {
        return this.getAttributeDate(conceptValue, null);
    }

    public Timestamp getAttributeDate(String conceptValue, Timestamp breakDate) {
        MHRAttribute attribute = this.getAttributeInstance(conceptValue, 0, breakDate);
        if (attribute == null) {
            return null;
        }
        return attribute.getServiceDate();
    }

    public String getAttributeString(String conceptValue) {
        return this.getAttributeString(conceptValue, null);
    }

    public String getAttributeString(String conceptValue, Timestamp breakDate) {
        MHRAttribute attribute = this.getAttributeInstance(conceptValue, 0, breakDate);
        if (attribute == null) {
            return null;
        }
        return attribute.getTextMsg();
    }

    public int getDays(Timestamp date1, Timestamp date2) {
        return TimeUtil.getDaysBetween(date1, date2, new int[0]) + 1;
    }

    public int getDays(String date1, String date2) {
        Timestamp dat1 = Timestamp.valueOf(date1);
        Timestamp dat2 = Timestamp.valueOf(date2);
        return this.getDays(dat1, dat2);
    }

    public int getMonths(Timestamp startParam, Timestamp endParam) {
        boolean negative = false;
        Timestamp end = endParam;
        Timestamp start = startParam;
        if (end.before(start)) {
            negative = true;
            Timestamp temp = start;
            start = end;
            end = temp;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        if (cal.get(1) == calEnd.get(1)) {
            if (negative) {
                return (calEnd.get(2) - cal.get(2)) * -1;
            }
            return calEnd.get(2) - cal.get(2);
        }
        int counter = 0;
        while (calEnd.after(cal)) {
            cal.add(2, 1);
            ++counter;
        }
        if (negative) {
            return counter * -1;
        }
        return counter;
    }

    public double getConcept(String conceptValue, int period) {
        return this.getConcept(conceptValue, null, period, period, true);
    }

    public double getConcept(String conceptValue, int periodFrom, int periodTo) {
        return this.getConcept(conceptValue, null, periodFrom, periodTo, true);
    }

    public double getConcept(String conceptValue, String payrollValue, int periodFrom, int periodTo) {
        return this.getConcept(conceptValue, payrollValue, periodFrom, periodTo, true);
    }

    public double getConcept(String conceptValue, String payrollValue, int periodFrom, int periodTo, boolean includeInProcess) {
        int payrollId;
        if (payrollValue == null) {
            payrollId = this.getHR_Payroll_ID();
        } else {
            MHRPayroll payroll = MHRPayroll.getByValue((Properties)this.getCtx(), (String)payrollValue, (String)this.get_TrxName());
            if (payroll == null) {
                return 0.0;
            }
            payrollId = payroll.get_ID();
        }
        String key = "SUM|" + this.partnerId + "|" + conceptValue + "|" + payrollId + "|" + periodFrom + "|" + periodTo + "|" + includeInProcess;
        BigDecimal amount = this.conceptAgregateMap.get(key);
        if (amount == null) {
            amount = new BigDecimal(MHRMovement.getConceptSum(this.getCtx(), conceptValue, payrollId, this.partnerId, this.getHR_Period_ID(), periodFrom, periodTo, includeInProcess, this.get_TrxName()));
            this.conceptAgregateMap.put(key, amount);
        }
        return amount.doubleValue();
    }

    public double getConceptAvg(String conceptValue, String payrollValue, int periodFrom, int periodTo) {
        return this.getConceptAvg(conceptValue, payrollValue, periodFrom, periodTo, true);
    }

    public double getConceptAvg(String conceptValue, String payrollValue, int periodFrom, int periodTo, boolean includeInProcess) {
        int payrollId;
        if (payrollValue == null) {
            payrollId = this.getHR_Payroll_ID();
        } else {
            MHRPayroll payroll = MHRPayroll.getByValue((Properties)this.getCtx(), (String)payrollValue, (String)this.get_TrxName());
            if (payroll == null) {
                return 0.0;
            }
            payrollId = payroll.get_ID();
        }
        String key = "AVG|" + this.partnerId + "|" + conceptValue + "|" + payrollId + "|" + periodFrom + "|" + periodTo + "|" + includeInProcess;
        BigDecimal amount = this.conceptAgregateMap.get(key);
        if (amount == null) {
            amount = new BigDecimal(MHRMovement.getConceptAvg(this.getCtx(), conceptValue, payrollId, this.partnerId, this.getHR_Period_ID(), periodFrom, periodTo, includeInProcess, this.get_TrxName()));
            this.conceptAgregateMap.put(key, amount);
        }
        return amount.doubleValue();
    }

    public MHRMovement getLastMovement(String conceptValue, String payrollValue, Timestamp breakDate, boolean isWithValidFrom) {
        String key;
        MHRMovement lastMovement;
        if (Util.isEmpty((String)payrollValue)) {
            payrollValue = this.payroll.getValue();
        }
        if ((lastMovement = this.lastConceptMap.get(key = this.partnerId + "|" + conceptValue + "|" + payrollValue + "|" + breakDate.getTime() + "|" + isWithValidFrom)) == null && (lastMovement = MHRMovement.getLastMovement(this.getCtx(), conceptValue, payrollValue, this.partnerId, breakDate, isWithValidFrom, this.get_TrxName())) != null) {
            this.lastConceptMap.put(key, lastMovement);
        }
        return lastMovement;
    }

    public double getLastConcept(String conceptValue, String payrollValue) {
        return this.getLastConcept(conceptValue, payrollValue, this.dateFrom, false);
    }

    public double getLastConcept(String conceptValue, String payrollValue, Timestamp breakDate) {
        return this.getLastConcept(conceptValue, payrollValue, breakDate, false);
    }

    public double getLastConcept(String conceptValue, String payrollValue, Timestamp breakDate, boolean isWithValidFrom) {
        MHRMovement lastMovement = this.getLastMovement(conceptValue, payrollValue, breakDate, isWithValidFrom);
        if (lastMovement == null) {
            return 0.0;
        }
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue, this.get_TrxName());
        if ("Q".equals(concept.getColumnType())) {
            if (lastMovement.getQty() != null) {
                return lastMovement.getQty().doubleValue();
            }
        } else if ("A".equals(concept.getColumnType()) && lastMovement.getAmount() != null) {
            return lastMovement.getAmount().doubleValue();
        }
        return 0.0;
    }

    public Timestamp getLastConceptDate(String conceptValue, String payrollValue) {
        return this.getLastConceptDate(conceptValue, payrollValue, this.dateFrom, false);
    }

    public Timestamp getLastConceptDate(String conceptValue, String payrollValue, Timestamp breakDate) {
        return this.getLastConceptDate(conceptValue, payrollValue, breakDate, false);
    }

    public Timestamp getLastConceptDate(String conceptValue, String payrollValue, Timestamp breakDate, boolean isWithValidFrom) {
        MHRMovement lastMovement = this.getLastMovement(conceptValue, payrollValue, breakDate, isWithValidFrom);
        if (lastMovement == null) {
            return null;
        }
        return lastMovement.getServiceDate();
    }

    public String getLastConceptString(String conceptValue, String payrollValue) {
        return this.getLastConceptString(conceptValue, payrollValue, this.dateFrom, false);
    }

    public String getLastConceptString(String conceptValue, String payrollValue, Timestamp breakDate) {
        return this.getLastConceptString(conceptValue, payrollValue, breakDate, false);
    }

    public String getLastConceptString(String conceptValue, String payrollValue, Timestamp breakDate, boolean isWithValidFrom) {
        MHRMovement lastMovement = this.getLastMovement(conceptValue, payrollValue, breakDate, isWithValidFrom);
        if (lastMovement == null) {
            return null;
        }
        if (!Util.isEmpty((String)lastMovement.getTextMsg())) {
            return lastMovement.getTextMsg();
        }
        return lastMovement.getDescription();
    }

    public Timestamp getLastConceptValidFrom(String conceptValue, String payrollValue) {
        return this.getLastConceptValidFrom(conceptValue, payrollValue, this.dateFrom, false);
    }

    public Timestamp getLastConceptValidFrom(String conceptValue, String payrollValue, Timestamp breakDate) {
        return this.getLastConceptValidFrom(conceptValue, payrollValue, breakDate, false);
    }

    public Timestamp getLastConceptValidFrom(String conceptValue, String payrollValue, Timestamp breakDate, boolean isWithValidFrom) {
        MHRMovement lastMovement = this.getLastMovement(conceptValue, payrollValue, breakDate, isWithValidFrom);
        if (lastMovement == null) {
            return null;
        }
        return lastMovement.getValidFrom();
    }

    public Timestamp getLastConceptValidTo(String conceptValue, String payrollValue) {
        return this.getLastConceptValidTo(conceptValue, payrollValue, this.dateFrom, false);
    }

    public Timestamp getLastConceptValidTo(String conceptValue, String payrollValue, Timestamp breakDate) {
        return this.getLastConceptValidTo(conceptValue, payrollValue, breakDate, false);
    }

    public Timestamp getLastConceptValidTo(String conceptValue, String payrollValue, Timestamp breakDate, boolean isWithValidFrom) {
        MHRMovement lastMovement = this.getLastMovement(conceptValue, payrollValue, breakDate, isWithValidFrom);
        if (lastMovement == null) {
            return null;
        }
        return lastMovement.getValidTo();
    }

    public double getConcept(String conceptValue, Timestamp from, Timestamp to) {
        return this.getConcept(conceptValue, null, from, to, true);
    }

    public double getConcept(String conceptValue, String payrollValue, Timestamp from, Timestamp to) {
        return this.getConcept(conceptValue, payrollValue, from, to, true);
    }

    public double getConcept(String conceptValue, String payrollValue, Timestamp from, Timestamp to, boolean includeInProcess) {
        int payrollId;
        if (payrollValue == null) {
            payrollId = this.getHR_Payroll_ID();
        } else {
            MHRPayroll payroll = MHRPayroll.getByValue((Properties)this.getCtx(), (String)payrollValue, (String)this.get_TrxName());
            if (payroll == null) {
                return 0.0;
            }
            payrollId = payroll.get_ID();
        }
        String key = "SUM|" + this.partnerId + "|" + conceptValue + "|" + payrollId + "|" + from.getTime() + "|" + to.getTime() + "|" + includeInProcess;
        BigDecimal amount = this.conceptAgregateMap.get(key);
        if (amount == null) {
            amount = new BigDecimal(MHRMovement.getConceptSum(this.getCtx(), conceptValue, payrollId, this.partnerId, from, to, includeInProcess, this.get_TrxName()));
            this.conceptAgregateMap.put(key, amount);
        }
        return amount.doubleValue();
    }

    public double getConceptAvg(String conceptValue, String payrollValue, Timestamp from, Timestamp to) {
        return this.getConceptAvg(conceptValue, payrollValue, from, to, true);
    }

    public double getConceptAvg(String conceptValue, String payrollValue, Timestamp from, Timestamp to, boolean includeInProcess) {
        int payrollId;
        if (payrollValue == null) {
            payrollId = this.getHR_Payroll_ID();
        } else {
            MHRPayroll payroll = MHRPayroll.getByValue((Properties)this.getCtx(), (String)payrollValue, (String)this.get_TrxName());
            if (payroll == null) {
                return 0.0;
            }
            payrollId = payroll.get_ID();
        }
        String key = "AVG|" + this.partnerId + "|" + conceptValue + "|" + payrollId + "|" + from.getTime() + "|" + to.getTime() + "|" + includeInProcess;
        BigDecimal amount = this.conceptAgregateMap.get(key);
        if (amount == null) {
            amount = new BigDecimal(MHRMovement.getConceptAvg(this.getCtx(), conceptValue, payrollId, this.partnerId, from, to, includeInProcess, this.get_TrxName()));
            this.conceptAgregateMap.put(key, amount);
        }
        return amount.doubleValue();
    }

    public double getAttribute(Properties ctx, String vAttribute, Timestamp dateFrom, Timestamp dateTo) {
        logger.warning("not implemented yet -> getByConceptAndPartnerId (Properties, String, Timestamp, Timestamp)");
        return 0.0;
    }

    public double getAttribute(Properties ctx, String vAttribute, int periodFrom, int periodTo, String pFrom, String pTo) {
        logger.warning("not implemented yet -> getByConceptAndPartnerId (Properties, String, int, int, String, String)");
        return 0.0;
    }

    public int getAttributeInvoice(String conceptValue) {
        MHRAttribute attribute = this.getAttributeInstance(conceptValue);
        if (attribute == null) {
            return 0;
        }
        return attribute.get_ValueAsInt("C_Invoice_ID");
    }

    public int getAttributeDocType(String conceptValue) {
        MHRAttribute attribute = this.getAttributeInstance(conceptValue);
        if (attribute == null) {
            return 0;
        }
        return attribute.get_ValueAsInt("C_DocType_ID");
    }

    public BigDecimal getAttributeByPartnerId(String conceptValue, int partnerId, Timestamp breakDate) {
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue, this.get_TrxName());
        MHRAttribute attribute = this.getAttributeInstance(conceptValue, partnerId, breakDate);
        if (attribute == null) {
            return BigDecimal.ZERO;
        }
        if (concept.getColumnType().equals("Q")) {
            return attribute.getQty();
        }
        if (concept.getColumnType().equals("A")) {
            return attribute.getAmount();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAttributeByPartnerId(String conceptValue, int partnerId) {
        return this.getAttributeByPartnerId(conceptValue, partnerId, null);
    }

    @Deprecated
    public BigDecimal getAttributeBPartner(String conceptValue, int partnerId) {
        return this.getAttributeByPartnerId(conceptValue, partnerId);
    }

    public double getDays(int period) {
        logger.warning("instead of using getDays in the formula it's recommended to use _DaysPeriod+1");
        return Env.getContextAsInt((Properties)this.getCtx(), (String)"_DaysPeriod") + 1;
    }

    public static MHRProcess copyFrom(MHRProcess from, Timestamp dateAcct, int docTypeTargetId, boolean counter, String trxName, boolean setOrder) {
        MHRProcess to = new MHRProcess(from.getCtx(), 0, trxName);
        PO.copyValues((PO)from, (PO)to, (int)from.getAD_Client_ID(), (int)from.getAD_Org_ID());
        to.setReversal(true);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setName(from.getDocumentNo());
        to.setC_DocType_ID(docTypeTargetId);
        to.setC_DocTypeTarget_ID(docTypeTargetId);
        to.setDateAcct(dateAcct);
        to.setHR_Job_ID(from.getHR_Job_ID());
        to.setHR_Department_ID(from.getHR_Department_ID());
        to.setHR_Payroll_ID(from.getHR_Payroll_ID());
        to.setHR_Period_ID(from.getHR_Period_ID());
        to.setC_BPartner_ID(from.getC_BPartner_ID());
        to.setHR_Employee_ID(from.getHR_Employee_ID());
        to.setPosted(false);
        to.setProcessed(false);
        to.setProcessing(false);
        to.saveEx();
        if (to.copyLinesFrom(from) == 0) {
            throw new IllegalStateException("Could not create Payroll Lines");
        }
        return to;
    }

    public int copyLinesFrom(MHRProcess from) {
        if (this.isProcessed() || this.isPosted() || from == null) {
            return 0;
        }
        List<MHRMovement> fromLines = MHRMovement.findByProcess(from);
        for (MHRMovement fromMovement : fromLines) {
            MHRMovement toMovement = new MHRMovement(this.getCtx(), 0, from.get_TrxName());
            PO.copyValues((PO)fromMovement, (PO)toMovement, (int)fromMovement.getAD_Client_ID(), (int)fromMovement.getAD_Org_ID());
            toMovement.setIsManual(fromMovement.isManual());
            toMovement.setHR_Concept_Category_ID(fromMovement.getHR_Concept_Category_ID());
            toMovement.setHR_Concept_Type_ID(fromMovement.getHR_Concept_Type_ID());
            toMovement.setHR_Process_ID(this.getHR_Process_ID());
            toMovement.setC_BPartner_ID(fromMovement.getC_BPartner_ID());
            toMovement.setHR_Concept_ID(fromMovement.getHR_Concept_ID());
            toMovement.setDescription(fromMovement.getDescription());
            toMovement.setHR_Department_ID(fromMovement.getHR_Department_ID());
            toMovement.setHR_Job_ID(fromMovement.getHR_Job_ID());
            toMovement.setIsPrinted(fromMovement.isPrinted());
            toMovement.setQty(fromMovement.getQty().negate());
            toMovement.setServiceDate(fromMovement.getServiceDate());
            toMovement.setTextMsg(fromMovement.getTextMsg());
            toMovement.setValidFrom(fromMovement.getValidFrom());
            toMovement.setValidTo(fromMovement.getValidTo());
            toMovement.setAD_Rule_ID(fromMovement.getAD_Rule_ID());
            toMovement.setAmount(fromMovement.getAmount().negate());
            toMovement.setC_Activity_ID(fromMovement.getC_Activity_ID());
            toMovement.setC_Campaign_ID(fromMovement.getC_Campaign_ID());
            toMovement.setAD_OrgTrx_ID(fromMovement.getAD_OrgTrx_ID());
            toMovement.setC_ProjectPhase_ID(fromMovement.getC_ProjectPhase_ID());
            toMovement.setC_ProjectPhase_ID(fromMovement.getC_ProjectPhase_ID());
            toMovement.setC_Project_ID(fromMovement.getC_Project_ID());
            toMovement.setUser1_ID(fromMovement.getUser1_ID());
            toMovement.setUser2_ID(fromMovement.getUser2_ID());
            toMovement.setUser3_ID(fromMovement.getUser3_ID());
            toMovement.setUser4_ID(fromMovement.getUser4_ID());
            toMovement.setProcessed(false);
            toMovement.setC_BP_Group_ID(fromMovement.getC_BP_Group_ID());
            toMovement.setHR_Employee_ID(fromMovement.getHR_Employee_ID());
            toMovement.setHR_EmployeeType_ID(fromMovement.getHR_EmployeeType_ID());
            toMovement.setHR_SkillType_ID(fromMovement.getHR_SkillType_ID());
            toMovement.setHR_Payroll_ID(fromMovement.getHR_Payroll_ID());
            toMovement.setHR_Contract_ID(fromMovement.getHR_Payroll().getHR_Contract_ID());
            toMovement.saveEx();
        }
        return fromLines.size();
    }

    public MHREmployee setEmployee(String partnerValue, String conceptValue) {
        MHRPeriod payrollPeriod;
        MBPartner partner = MBPartner.get((Properties)this.getCtx(), (String)partnerValue);
        if (partner == null) {
            throw new AdempiereException("@C_BPartner_ID@ @NotFound@ " + partnerValue);
        }
        this.partnerId = partner.get_ID();
        MHRConcept concept = MHRConcept.getByValue(this.getCtx(), conceptValue, this.get_TrxName());
        if (concept == null) {
            throw new AdempiereException("@HR_Concept_ID@ @NotFound@ " + conceptValue);
        }
        this.payrollConceptId = concept.get_ID();
        this.columnType = concept.getColumnType();
        this.employee = MHREmployee.getActiveEmployee((Properties)this.getCtx(), (int)this.partnerId, (String)this.get_TrxName());
        if (this.getHR_Payroll_ID() > 0) {
            this.payrollId = this.getHR_Payroll_ID();
        }
        if (this.getHR_Department_ID() > 0) {
            this.departmentId = this.getHR_Department_ID();
        }
        if (this.getHR_Job_ID() > 0) {
            this.jobId = this.getHR_Job_ID();
        }
        if (this.getHR_Period_ID() > 0) {
            payrollPeriod = MHRPeriod.getById((Properties)this.getCtx(), (int)this.getHR_Period_ID(), (String)this.get_TrxName());
        } else {
            payrollPeriod = new MHRPeriod(this.getCtx(), 0, this.get_TrxName());
            MPeriod period = MPeriod.get((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getAD_Org_ID());
            if (period != null) {
                payrollPeriod.setStartDate(period.getStartDate());
                payrollPeriod.setEndDate(period.getEndDate());
            } else {
                payrollPeriod.setStartDate(this.getDateAcct());
                payrollPeriod.setEndDate(this.getDateAcct());
            }
        }
        this.dateFrom = payrollPeriod.getStartDate();
        this.dateTo = payrollPeriod.getEndDate();
        this.scriptCtx.clear();
        this.scriptCtx.put("process", (Object)this);
        this.scriptCtx.put("_Process", this.getHR_Process_ID());
        this.scriptCtx.put("_Period", payrollPeriod.getHR_Period_ID());
        this.scriptCtx.put("_Payroll", this.getHR_Payroll_ID());
        this.scriptCtx.put("_PayrollValue", Optional.ofNullable(this.getHR_Payroll().getValue()).orElse(null));
        this.scriptCtx.put("_Department", this.getHR_Department_ID());
        logger.info("info data - Process " + this.getHR_Process_ID() + ", Period :" + this.getHR_Period_ID() + ", Payroll : " + this.getHR_Payroll_ID() + ", Department : " + this.getHR_Department_ID());
        this.scriptCtx.put("_From", this.dateFrom);
        this.scriptCtx.put("_To", this.dateTo);
        this.scriptCtx.put("_Period", payrollPeriod.getPeriodNo());
        this.scriptCtx.remove("_DateStart");
        this.scriptCtx.remove("_DateEnd");
        this.scriptCtx.remove("_Days");
        this.scriptCtx.remove("_C_BPartner_ID");
        this.scriptCtx.remove("_HR_Employee_ID");
        this.scriptCtx.put("_DateStart", this.employee.getStartDate());
        this.scriptCtx.put("_DateEnd", this.employee.getEndDate() == null ? TimeUtil.getDay(2999, 12, 31) : this.employee.getEndDate());
        this.scriptCtx.put("_Days", TimeUtil.getDaysBetween(payrollPeriod.getStartDate(), payrollPeriod.getEndDate(), new int[0]) + 1);
        this.scriptCtx.put("_C_BPartner_ID", this.employee.getC_BPartner_ID());
        this.scriptCtx.put("_HR_Employee_ID", this.employee.getHR_Employee_ID());
        this.scriptCtx.put("_Employee", this.employee);
        this.scriptCtx.remove("_HR_Concept_ID");
        this.scriptCtx.remove("_HR_Concept");
        this.scriptCtx.put("_HR_Concept_ID", concept.getHR_Concept_ID());
        this.scriptCtx.put("_HR_Concept", concept);
        this.scriptCtx.remove("_HR_PayrollConcept_ID");
        this.movements = new Hashtable();
        this.payrollConcepts = MHRPayrollConcept.getPayrollConcepts((MHRProcess)this);
        this.loadMovements(this.movements, this.employee.getC_BPartner_ID());
        if (!concept.isManual()) {
            this.movements.remove(concept.get_ID());
        }
        return this.employee;
    }

    public double getCommissionAmt(int bPartnerId, Timestamp from, Timestamp to, String docBasisType) {
        BigDecimal value = MCommission.getCommissionAmt((int)bPartnerId, (Timestamp)from, (Timestamp)to, (String)docBasisType, (String)this.get_TrxName());
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    public double getCommissionAmt(Timestamp from, Timestamp to, String docBasisType) {
        return this.getCommissionAmt(this.partnerId, from, to, docBasisType);
    }

    public double getCommissionAmt(String docBasisType) {
        return this.getCommissionAmt(this.dateFrom, this.dateTo, docBasisType);
    }

    public double getCommissionAmt() {
        return this.getCommissionAmt(null);
    }

    public double getIncidenceSum(String conceptValue, String workShiftValue, Timestamp from, Timestamp to) {
        return TNAUtil.getIncidenceSum((Properties)this.getCtx(), (String)conceptValue, (String)workShiftValue, (int)this.partnerId, (Timestamp)from, (Timestamp)to, (String)this.get_TrxName());
    }

    public double getIncidenceSum(String conceptValue, Timestamp from, Timestamp to) {
        return TNAUtil.getIncidenceSum((Properties)this.getCtx(), (String)conceptValue, null, (int)this.partnerId, (Timestamp)from, (Timestamp)to, (String)this.get_TrxName());
    }

    public void setReversal(boolean isReversal) {
        this.isReversal = isReversal;
    }

    public boolean isReversal() {
        return this.isReversal;
    }
}

