/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.X_HR_Attribute;
import org.eevolution.model.X_I_HR_Attribute;

public class MHRAttribute
extends X_HR_Attribute {
    private static final long serialVersionUID = 3783311896401143394L;

    public static Optional<MHRAttribute> getByConceptValueAndPartnerId(Properties ctx, String conceptValue, Integer partnerId, String referenceNo, String description, String trxName) {
        if (partnerId == null) {
            return Optional.empty();
        }
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        whereClause.append("EXISTS (SELECT 1 FROM HR_Concept c WHERE c.IsEmployee=? AND c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value=?)");
        parameters.add("Y");
        parameters.add(conceptValue);
        if (partnerId > 0) {
            whereClause.append(" AND ").append("C_BPartner_ID").append("=?");
            parameters.add(partnerId);
        }
        if (description != null && description.length() > 0) {
            whereClause.append(" AND ").append("Description").append("=?");
            parameters.add(description);
        }
        if (referenceNo != null && referenceNo.length() > 0) {
            whereClause.append(" AND ").append("ReferenceNo").append("=?");
            parameters.add(referenceNo);
        }
        MHRAttribute attribute = (MHRAttribute)new Query(ctx, "HR_Attribute", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).first();
        return Optional.ofNullable(attribute);
    }

    public static List<MHRAttribute> findByConceptValueAndPartnerId(Properties ctx, String conceptValue, Integer partnerId, String referenceNo, String description, String trxName) {
        List<MHRAttribute> attributes = new ArrayList<MHRAttribute>();
        if (partnerId == null) {
            return attributes;
        }
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        whereClause.append("EXISTS (SELECT 1 FROM HR_Concept c WHERE c.IsEmployee=? AND c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value=?)");
        parameters.add("Y");
        parameters.add(conceptValue);
        if (partnerId > 0) {
            whereClause.append(" AND ").append("C_BPartner_ID").append("=?");
            parameters.add(partnerId);
        }
        if (description != null && description.length() > 0) {
            whereClause.append(" AND ").append("Description").append("=?");
            parameters.add(description);
        }
        if (referenceNo != null && referenceNo.length() > 0) {
            whereClause.append(" AND ").append("ReferenceNo").append("=?");
            parameters.add(referenceNo);
        }
        attributes = new Query(ctx, "HR_Attribute", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).list();
        return attributes;
    }

    public static MHRAttribute getByConceptAndPartnerId(MHRConcept concept, Integer partnerId, int payrollId, String referenceNo, String description, Timestamp validFrom) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Concept_ID").append("=?");
        params.add(concept.getHR_Concept_ID());
        if (partnerId > 0) {
            whereClause.append(" AND ").append("C_BPartner_ID").append("=? ");
            params.add(partnerId);
        }
        if (referenceNo != null && referenceNo.length() > 0) {
            whereClause.append(" AND ").append("ReferenceNo").append("=? ");
            params.add(referenceNo);
        }
        if (description != null && description.length() > 0) {
            whereClause.append(" AND ").append("Description").append("=? ");
            params.add(description);
        }
        if (payrollId > 0) {
            whereClause.append(" AND ").append("HR_Payroll_ID").append("? ");
            params.add(payrollId);
        }
        if (validFrom != null) {
            whereClause.append(" AND ").append("ValidFrom").append("=? ");
            params.add(validFrom);
        }
        MHRAttribute attribute = (MHRAttribute)new Query(concept.getCtx(), "HR_Attribute", whereClause.toString(), concept.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        return attribute;
    }

    public static MHRAttribute getByConceptAndEmployee(MHRConcept concept, MHREmployee employee, int payrollId, Timestamp dateFrom, Timestamp dateTo) {
        String ORDERVALUE = " DESC NULLS LAST";
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        StringBuffer orderByClause = new StringBuffer("ValidFrom").append(ORDERVALUE);
        whereClause.append("ValidFrom <= ? AND (ValidTo >= ? OR ValidTo IS NULL)");
        params.add(dateFrom);
        params.add(dateTo);
        whereClause.append(" AND HR_Concept_ID = ? ");
        params.add(concept.getHR_Concept_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        whereClause.append(" AND (HR_Payroll_ID = ? OR HR_Payroll_ID IS NULL)");
        params.add(payrollId);
        orderByClause.append(", HR_Payroll_ID").append(ORDERVALUE);
        if (employee != null) {
            if (concept.isEmployee()) {
                whereClause.append(" AND C_BPartner_ID = ? AND (HR_Employee_ID = ? OR HR_Employee_ID IS NULL)");
                params.add(employee.getC_BPartner_ID());
                params.add(employee.get_ID());
                orderByClause.append(", C_BPartner_ID").append(ORDERVALUE);
            } else {
                whereClause.append(" AND C_BPartner_ID IS NULL ");
            }
            whereClause.append(" AND (HR_Department_ID = ? OR HR_Department_ID IS NULL)");
            params.add(employee.getHR_Department_ID());
            orderByClause.append(", HR_Department_ID").append(ORDERVALUE);
            whereClause.append(" AND (HR_Job_ID = ? OR HR_Job_ID IS NULL)");
            params.add(employee.getHR_Job_ID());
            orderByClause.append(", HR_Job_ID").append(ORDERVALUE);
            MHRPayroll payroll = MHRPayroll.getById((Properties)employee.getCtx(), (int)payrollId, (String)concept.get_TrxName());
            whereClause.append(" AND (HR_Contract_ID = ? OR HR_Contract_ID IS NULL)");
            params.add(payroll.getHR_Contract_ID());
            orderByClause.append(", HR_Contract_ID").append(ORDERVALUE);
            if (employee.getHR_WorkGroup_ID() != 0) {
                whereClause.append(" AND (HR_WorkGroup_ID = ? OR HR_WorkGroup_ID IS NULL)");
                params.add(employee.getHR_WorkGroup_ID());
                orderByClause.append(", HR_WorkGroup_ID").append(ORDERVALUE);
            }
            if (employee.getHR_ShiftGroup_ID() != 0) {
                whereClause.append(" AND (HR_ShiftGroup_ID = ? OR HR_ShiftGroup_ID IS NULL)");
                params.add(employee.getHR_ShiftGroup_ID());
                orderByClause.append(", HR_ShiftGroup_ID").append(ORDERVALUE);
            }
            if (employee.getHR_Grade_ID() != 0) {
                whereClause.append(" AND (HR_Grade_ID = ? OR HR_Grade_ID IS NULL)");
                params.add(employee.getHR_Grade_ID());
                orderByClause.append(", HR_Grade_ID").append(ORDERVALUE);
            }
            if (employee.getHR_Degree_ID() != 0) {
                whereClause.append(" AND (HR_Degree_ID = ? OR HR_Degree_ID IS NULL)");
                params.add(employee.getHR_Degree_ID());
                orderByClause.append(", HR_Degree_ID").append(ORDERVALUE);
            }
            if (employee.getHR_Race_ID() != 0) {
                whereClause.append(" AND (HR_Race_ID = ? OR HR_Race_ID IS NULL)");
                params.add(employee.getHR_Race_ID());
                orderByClause.append(", HR_Race_ID").append(ORDERVALUE);
            }
            if (employee.getHR_CareerLevel_ID() != 0) {
                whereClause.append(" AND (HR_CareerLevel_ID = ? OR HR_CareerLevel_ID IS NULL)");
                params.add(employee.getHR_CareerLevel_ID());
                orderByClause.append(", HR_CareerLevel_ID").append(ORDERVALUE);
            }
            if (employee.getHR_JobEducation_ID() != 0) {
                whereClause.append(" AND (HR_JobEducation_ID = ? OR HR_JobEducation_ID IS NULL)");
                params.add(employee.getHR_JobEducation_ID());
                orderByClause.append(", HR_JobEducation_ID").append(ORDERVALUE);
            }
            if (employee.getHR_EmployeeType_ID() != 0) {
                whereClause.append(" AND (HR_EmployeeType_ID = ? OR HR_EmployeeType_ID IS NULL)");
                params.add(employee.getHR_EmployeeType_ID());
                orderByClause.append(", HR_EmployeeType_ID").append(ORDERVALUE);
            }
            if (employee.getHR_JobType_ID() != 0) {
                whereClause.append(" AND (HR_JobType_ID = ? OR HR_JobType_ID IS NULL)");
                params.add(employee.getHR_JobType_ID());
                orderByClause.append(", HR_JobType_ID").append(ORDERVALUE);
            }
            if (employee.getHR_SkillType_ID() != 0) {
                whereClause.append(" AND (HR_SkillType_ID = ? OR HR_SkillType_ID IS NULL)");
                params.add(employee.getHR_SkillType_ID());
                orderByClause.append(", HR_SkillType_ID").append(ORDERVALUE);
            }
            if (employee.getHR_Designation_ID() != 0) {
                whereClause.append(" AND (HR_Designation_ID = ? OR HR_Designation_ID IS NULL)");
                params.add(employee.getHR_Designation_ID());
                orderByClause.append(", HR_Designation_ID").append(ORDERVALUE);
            }
            if (employee.getHR_SalaryStructure_ID() != 0) {
                whereClause.append(" AND (HR_SalaryStructure_ID = ? OR HR_SalaryStructure_ID IS NULL)");
                params.add(employee.getHR_SalaryStructure_ID());
                orderByClause.append(", HR_SalaryStructure_ID").append(ORDERVALUE);
            }
            if (employee.getHR_SalaryRange_ID() != 0) {
                whereClause.append(" AND (HR_SalaryRange_ID = ? OR HR_SalaryRange_ID IS NULL)");
                params.add(employee.getHR_SalaryRange_ID());
                orderByClause.append(", HR_SalaryRange_ID").append(ORDERVALUE);
            }
            if (employee.getEmployeeStatus() != null) {
                whereClause.append(" AND (EmployeeStatus = ? OR EmployeeStatus IS NULL)");
                params.add(employee.getEmployeeStatus());
                orderByClause.append(", EmployeeStatus").append(ORDERVALUE);
            }
            if (employee.getC_Activity_ID() != 0) {
                whereClause.append(" AND (C_Activity_ID = ? OR C_Activity_ID IS NULL)");
                params.add(employee.getC_Activity_ID());
                orderByClause.append(", C_Activity_ID").append(ORDERVALUE);
            }
            if (employee.getC_Campaign_ID() != 0) {
                whereClause.append(" AND (C_Campaign_ID = ? OR C_Campaign_ID IS NULL)");
                params.add(employee.getC_Campaign_ID());
                orderByClause.append(", C_Campaign_ID").append(ORDERVALUE);
            }
            if (employee.getC_Project_ID() != 0) {
                whereClause.append(" AND (C_Project_ID = ? OR C_Project_ID IS NULL)");
                params.add(employee.getC_Project_ID());
                orderByClause.append(", C_Project_ID").append(ORDERVALUE);
            }
            if (employee.getAD_OrgTrx_ID() != 0) {
                whereClause.append(" AND (AD_OrgTrx_ID = ? OR AD_OrgTrx_ID IS NULL)");
                params.add(employee.getAD_OrgTrx_ID());
                orderByClause.append(", AD_OrgTrx_ID").append(ORDERVALUE);
            }
        }
        orderByClause.append(", Updated").append(ORDERVALUE);
        MHRAttribute attribute = (MHRAttribute)new Query(concept.getCtx(), "HR_Attribute", whereClause.toString(), concept.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy(orderByClause.toString()).first();
        return attribute;
    }

    public static MHRAttribute getByConceptIdAndPartnerId(Properties ctx, int conceptId, int partnerId, Timestamp validFrom, String trxName) {
        StringBuilder whereClause = new StringBuilder("(");
        whereClause.append("C_BPartner_ID").append("=? OR ").append("C_BPartner_ID").append(" IS NULL) AND ");
        whereClause.append("ValidFrom").append("<=? AND ").append("EXISTS (SELECT 1 FROM HR_Concept c WHERE HR_Attribute.HR_Concept_ID = c.HR_Concept_ID AND c.HR_Concept_ID=?)");
        return (MHRAttribute)new Query(ctx, "HR_Attribute", whereClause.toString(), trxName).setParameters(new Object[]{partnerId, validFrom, conceptId}).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
    }

    public static MHRAttribute getByConceptValueAndPartnerId(Properties ctx, String conceptValue, int partnerId, Timestamp startDate, String trxName) {
        if (Util.isEmpty((String)conceptValue, (boolean)true)) {
            return null;
        }
        int clientId = Env.getAD_Client_ID((Properties)ctx);
        String whereClause = "C_BPartner_ID=? AND AD_Client_ID IN (?,?)  AND ValidFrom<=? AND EXISTS (SELECT 1 FROM HR_Concept c WHERE HR_Attribute.HR_Concept_ID = c.HR_Concept_ID AND c.Value=?)";
        MHRAttribute attribute = (MHRAttribute)new Query(ctx, "HR_Attribute", "C_BPartner_ID=? AND AD_Client_ID IN (?,?)  AND ValidFrom<=? AND EXISTS (SELECT 1 FROM HR_Concept c WHERE HR_Attribute.HR_Concept_ID = c.HR_Concept_ID AND c.Value=?)", trxName).setParameters(new Object[]{partnerId, 0, clientId, startDate, conceptValue}).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        return attribute;
    }

    public static MHRAttribute getByConceptValueAndPartnerId(Properties ctx, String conceptValue, int partnerId, Timestamp startDate, Timestamp endDate, String trxName) {
        if (Util.isEmpty((String)conceptValue, (boolean)true)) {
            return null;
        }
        if (endDate == null) {
            return MHRAttribute.getByConceptValueAndPartnerId(ctx, conceptValue, partnerId, startDate, trxName);
        }
        int clientId = Env.getAD_Client_ID((Properties)ctx);
        String whereClause = "C_BPartner_ID=? AND AD_Client_ID IN (?,?)  AND ValidFrom<=? AND ValidTo>=? AND EXISTS (SELECT 1 FROM HR_Concept c WHERE HR_Attribute.HR_Concept_ID = c.HR_Concept_ID AND c.Value=?)";
        MHRAttribute attribute = (MHRAttribute)new Query(ctx, "HR_Attribute", "C_BPartner_ID=? AND AD_Client_ID IN (?,?)  AND ValidFrom<=? AND ValidTo>=? AND EXISTS (SELECT 1 FROM HR_Concept c WHERE HR_Attribute.HR_Concept_ID = c.HR_Concept_ID AND c.Value=?)", trxName).setParameters(new Object[]{partnerId, 0, clientId, startDate, endDate, conceptValue}).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        return attribute;
    }

    public MHRAttribute(Properties ctx, int HR_Attribute_ID, String trxName) {
        super(ctx, HR_Attribute_ID, trxName);
    }

    public MHRAttribute(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRAttribute(X_I_HR_Attribute importAttribute) {
        super(importAttribute.getCtx(), 0, importAttribute.get_TrxName());
        this.setAD_Org_ID(importAttribute.getAD_Org_ID());
        this.setHR_Employee_ID(importAttribute.getHR_Employee_ID());
        this.setC_BPartner_ID(importAttribute.getC_BPartner_ID());
        this.setC_Charge_ID(importAttribute.getC_Charge_ID());
        this.setHR_Concept_ID(importAttribute.getHR_Concept_ID());
        this.setDescription(importAttribute.getDescription());
        this.setIsPrinted(importAttribute.isPrinted());
    }

    @Override
    public I_HR_Concept getHR_Concept() {
        return MHRConcept.getById(this.getCtx(), this.getHR_Concept_ID(), this.get_TrxName());
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getHR_Concept().isEmployee() && this.getC_BPartner_ID() <= 0) {
            throw new AdempiereException("@HR_Employee_ID@ @NotFound@");
        }
        if (!this.getHR_Concept().isEmployee()) {
            this.setHR_Employee_ID(-1);
        }
        return true;
    }
}

