/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import org.compiere.model.MCalendar;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class TimeUtil {
    public static final String TRUNC_DAY = "D";
    public static final String TRUNC_WEEK = "W";
    public static final String TRUNC_MONTH = "MM";
    public static final String TRUNC_QUARTER = "Q";
    public static final String TRUNC_YEAR = "Y";
    public static final String DURATIONUNIT_Year = "Y";
    public static final String DURATIONUNIT_Month = "M";
    public static final String DURATIONUNIT_Week = "W";
    public static final String DURATIONUNIT_Day = "D";
    public static final String DURATIONUNIT_Hour = "h";
    public static final String DURATIONUNIT_Minute = "m";
    public static final String DURATIONUNIT_Second = "s";

    public static Timestamp getDay(long time) {
        if (time == 0L) {
            time = System.currentTimeMillis();
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getDay(Timestamp dayTime) {
        if (dayTime == null) {
            return TimeUtil.getDay(System.currentTimeMillis());
        }
        return TimeUtil.getDay(dayTime.getTime());
    }

    public static Timestamp getDay(int year, int month, int day) {
        if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid Month: " + month);
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid Day: " + month);
        }
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Calendar getToday() {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Timestamp getNextDay(Timestamp day) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(day.getTime());
        cal.add(6, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getMonthLastDay(Timestamp day) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(day.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(6, -1);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getDayTime(Timestamp day, Timestamp time) {
        GregorianCalendar cal_1 = new GregorianCalendar();
        cal_1.setTimeInMillis(day.getTime());
        GregorianCalendar cal_2 = new GregorianCalendar();
        cal_2.setTimeInMillis(time.getTime());
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.set(cal_1.get(1), cal_1.get(2), cal_1.get(5), cal_2.get(11), cal_2.get(12), cal_2.get(13));
        cal.set(14, 0);
        Timestamp retValue = new Timestamp(cal.getTimeInMillis());
        return retValue;
    }

    public static boolean inRange(Timestamp start_1, Timestamp end_1, Timestamp start_2, Timestamp end_2) {
        if (end_1.before(start_1)) {
            throw new UnsupportedOperationException("TimeUtil.inRange End_1=" + end_1 + " before Start_1=" + start_1);
        }
        if (end_2.before(start_2)) {
            throw new UnsupportedOperationException("TimeUtil.inRange End_2=" + end_2 + " before Start_2=" + start_2);
        }
        if (!end_2.after(start_1)) {
            return false;
        }
        return start_2.before(end_1);
    }

    public static boolean inRange(Timestamp start, Timestamp end, boolean OnMonday, boolean OnTuesday, boolean OnWednesday, boolean OnThursday, boolean OnFriday, boolean OnSaturday, boolean OnSunday) {
        if (OnSaturday && OnSunday && OnMonday && OnTuesday && OnWednesday && OnThursday && OnFriday) {
            return false;
        }
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTimeInMillis(start.getTime());
        int dayStart = calStart.get(7);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTimeInMillis(end.getTime());
        calEnd.add(6, -1);
        int dayEnd = calEnd.get(7);
        if (calStart.get(1) == calEnd.get(1) && calStart.get(2) == calEnd.get(2) && calStart.get(5) == calEnd.get(5)) {
            return !OnSaturday && dayStart == 7 || !OnSunday && dayStart == 1 || !OnMonday && dayStart == 2 || !OnTuesday && dayStart == 3 || !OnWednesday && dayStart == 4 || !OnThursday && dayStart == 5 || !OnFriday && dayStart == 6;
        }
        BitSet days = new BitSet(8);
        if (dayEnd <= dayStart) {
            dayEnd += 7;
        }
        for (int i = dayStart; i < dayEnd; ++i) {
            int index = i;
            if (index > 7) {
                index -= 7;
            }
            days.set(index);
        }
        return !OnSaturday && days.get(7) || !OnSunday && days.get(1) || !OnMonday && days.get(2) || !OnTuesday && days.get(3) || !OnWednesday && days.get(4) || !OnThursday && days.get(5) || !OnFriday && days.get(6);
    }

    private static boolean isMatchingDay(int day, int ... matchingDays) {
        if (matchingDays == null || matchingDays.length == 0) {
            return true;
        }
        for (int i = 0; i < matchingDays.length; ++i) {
            if (day != matchingDays[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameDay(Timestamp one, Timestamp two) {
        GregorianCalendar calOne = new GregorianCalendar();
        if (one != null) {
            calOne.setTimeInMillis(one.getTime());
        }
        GregorianCalendar calTwo = new GregorianCalendar();
        if (two != null) {
            calTwo.setTimeInMillis(two.getTime());
        }
        return calOne.get(1) == calTwo.get(1) && calOne.get(2) == calTwo.get(2) && calOne.get(5) == calTwo.get(5);
    }

    public static boolean isSameHour(Timestamp one, Timestamp two) {
        GregorianCalendar calOne = new GregorianCalendar();
        if (one != null) {
            calOne.setTimeInMillis(one.getTime());
        }
        GregorianCalendar calTwo = new GregorianCalendar();
        if (two != null) {
            calTwo.setTimeInMillis(two.getTime());
        }
        return calOne.get(1) == calTwo.get(1) && calOne.get(2) == calTwo.get(2) && calOne.get(5) == calTwo.get(5) && calOne.get(11) == calTwo.get(11);
    }

    public static boolean isAllDay(Timestamp start, Timestamp end) {
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTimeInMillis(start.getTime());
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTimeInMillis(end.getTime());
        return calStart.get(11) == calEnd.get(11) && calStart.get(12) == calEnd.get(12) && calStart.get(13) == calEnd.get(13) && calStart.get(14) == calEnd.get(14) && calStart.get(11) == 0 && calStart.get(12) == 0 && calStart.get(13) == 0 && calStart.get(14) == 0 && start.before(end);
    }

    public static int getDaysBetween(Timestamp startingDate, Timestamp endingDate, int ... matchingDay) {
        return TimeUtil.getDaysBetween(startingDate, endingDate, false, matchingDay);
    }

    public static int getDaysBetween(Timestamp startingDate, Timestamp endingDate, boolean includeCurrentDay, int ... matchingDay) {
        boolean match;
        if (startingDate == null || endingDate == null) {
            return 0;
        }
        boolean negative = false;
        if (endingDate.before(startingDate)) {
            negative = true;
            Timestamp temp = startingDate;
            startingDate = endingDate;
            endingDate = temp;
        }
        GregorianCalendar testingDate = new GregorianCalendar();
        testingDate.setTime(startingDate);
        testingDate.set(11, 0);
        testingDate.set(12, 0);
        testingDate.set(13, 0);
        testingDate.set(14, 0);
        GregorianCalendar endCalendarDate = new GregorianCalendar();
        endCalendarDate.setTime(endingDate);
        endCalendarDate.set(11, 0);
        endCalendarDate.set(12, 0);
        endCalendarDate.set(13, 0);
        endCalendarDate.set(14, 0);
        if (testingDate.get(1) == endCalendarDate.get(1) && (matchingDay == null || matchingDay.length == 0)) {
            if (negative) {
                return (endCalendarDate.get(6) - testingDate.get(6)) * -1;
            }
            return endCalendarDate.get(6) - testingDate.get(6);
        }
        int counter = 0;
        if (includeCurrentDay && (match = TimeUtil.isMatchingDay(testingDate.get(7), matchingDay))) {
            ++counter;
        }
        while (endCalendarDate.after(testingDate)) {
            testingDate.add(6, 1);
            match = TimeUtil.isMatchingDay(testingDate.get(7), matchingDay);
            if (!match) continue;
            ++counter;
        }
        if (negative) {
            return counter * -1;
        }
        return counter;
    }

    public static int getNonBusinessDaysBetween(Timestamp start, Timestamp end, int ... includeDay) {
        return TimeUtil.getDaysBetweenWithCalendar(start, end, true, includeDay);
    }

    public static int getBusinessDaysBetween(Timestamp start, Timestamp end, int ... includeDay) {
        return TimeUtil.getDaysBetweenWithCalendar(start, end, false, includeDay);
    }

    private static int getDaysBetweenWithCalendar(Timestamp start, Timestamp end, boolean onlyMatchWithCalendar, int ... includeDay) {
        if (start == null || end == null) {
            return 0;
        }
        boolean negative = false;
        if (end.before(start)) {
            negative = true;
            Timestamp temp = start;
            start = end;
            end = temp;
        }
        MCalendar clientCalendar = MCalendar.getDefault((Properties)Env.getCtx());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        int counter = 0;
        while (calEnd.after(cal)) {
            cal.add(6, 1);
            boolean match = TimeUtil.isMatchingDay(cal.get(7), includeDay);
            boolean isNonBusinessDay = clientCalendar.isNonBusinessDay(cal.getTime());
            if (onlyMatchWithCalendar) {
                if (includeDay == null || includeDay.length == 0) {
                    match = false;
                }
                if (!match && !isNonBusinessDay) continue;
                ++counter;
                continue;
            }
            if (!match || isNonBusinessDay) continue;
            ++counter;
        }
        if (negative) {
            return counter * -1;
        }
        return counter;
    }

    public static Timestamp addBusinessDays(Timestamp day, int offset, int ... includeDay) {
        return TimeUtil.addDays(day, offset, false, includeDay);
    }

    public static Timestamp addDays(Timestamp day, int offset, boolean onlyMatchWithCalendar, int ... includeDay) {
        Calendar cal = Calendar.getInstance();
        if (day == null) {
            return day;
        }
        int days = 0;
        cal.setTimeInMillis(day.getTime());
        MCalendar clientCalendar = MCalendar.getDefault((Properties)Env.getCtx());
        while (days < offset || days == offset && !TimeUtil.isMatchingDay(cal.get(7), includeDay) || clientCalendar.isNonBusinessDay(cal.getTime()) && onlyMatchWithCalendar) {
            boolean match = TimeUtil.isMatchingDay(cal.get(7), includeDay);
            boolean isNonBusinessDay = clientCalendar.isNonBusinessDay(cal.getTime());
            if (match) {
                ++days;
            } else {
                cal.add(5, 1);
                continue;
            }
            if (isNonBusinessDay && !onlyMatchWithCalendar) {
                --days;
            }
            cal.add(5, 1);
        }
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp addDays(Timestamp day, int offset) {
        if (offset == 0) {
            return day;
        }
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (offset == 0) {
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.add(6, offset);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp addMinutess(Timestamp dateTime, int offset) {
        if (dateTime == null) {
            dateTime = new Timestamp(System.currentTimeMillis());
        }
        if (offset == 0) {
            return dateTime;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dateTime);
        cal.add(12, offset);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static String formatElapsed(Timestamp start, Timestamp end) {
        long startTime = 0L;
        startTime = start == null ? System.currentTimeMillis() : start.getTime();
        long endTime = 0L;
        endTime = end == null ? System.currentTimeMillis() : end.getTime();
        return TimeUtil.formatElapsed(endTime - startTime);
    }

    public static String formatElapsed(Timestamp start) {
        if (start == null) {
            return "NoStartTime";
        }
        long startTime = start.getTime();
        long endTime = System.currentTimeMillis();
        return TimeUtil.formatElapsed(endTime - startTime);
    }

    public static String formatElapsed(long elapsedMS) {
        if (elapsedMS == 0L) {
            return "0";
        }
        StringBuffer sb = new StringBuffer();
        if (elapsedMS < 0L) {
            elapsedMS = -elapsedMS;
            sb.append("-");
        }
        long miliSeconds = elapsedMS % 1000L;
        long seconds = (elapsedMS /= 1000L) % 60L;
        long minutes = (elapsedMS /= 60L) % 60L;
        long hours = (elapsedMS /= 60L) % 24L;
        long days = elapsedMS / 24L;
        if (days != 0L) {
            sb.append(days).append("'");
        }
        if (hours != 0L) {
            sb.append(TimeUtil.get2digits(hours)).append(":");
        } else if (days != 0L) {
            sb.append("00:");
        }
        if (minutes != 0L) {
            sb.append(TimeUtil.get2digits(minutes)).append(":");
        } else if (hours != 0L || days != 0L) {
            sb.append("00:");
        }
        sb.append(TimeUtil.get2digits(seconds)).append(".").append(miliSeconds);
        return sb.toString();
    }

    private static String get2digits(long no) {
        String s = String.valueOf(no);
        if (s.length() > 1) {
            return s;
        }
        return "0" + s;
    }

    public static boolean isValid(Timestamp validFrom, Timestamp validTo) {
        return TimeUtil.isValid(validFrom, validTo, new Timestamp(System.currentTimeMillis()));
    }

    public static boolean isValid(Timestamp validFrom, Timestamp validTo, Timestamp testDate) {
        if (testDate == null) {
            return true;
        }
        if (validFrom == null && validTo == null) {
            return true;
        }
        if (validFrom != null && validFrom.after(testDate)) {
            return false;
        }
        return validTo == null || !validTo.before(testDate);
    }

    public static Timestamp max(Timestamp ts1, Timestamp ts2) {
        if (ts1 == null) {
            return ts2;
        }
        if (ts2 == null) {
            return ts1;
        }
        if (ts2.after(ts1)) {
            return ts2;
        }
        return ts1;
    }

    public static Timestamp trunc(Timestamp dayTime, String trunc) {
        if (dayTime == null) {
            dayTime = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(dayTime.getTime());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        if (trunc == null || trunc.equals("D")) {
            return new Timestamp(cal.getTimeInMillis());
        }
        if (trunc.equals("W")) {
            cal.set(7, cal.getFirstDayOfWeek());
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.set(5, 1);
        if (trunc.equals(TRUNC_MONTH)) {
            return new Timestamp(cal.getTimeInMillis());
        }
        if (trunc.equals(TRUNC_QUARTER)) {
            int mm = cal.get(2);
            mm = mm < 4 ? 1 : (mm < 7 ? 4 : (mm < 10 ? 7 : 10));
            cal.set(2, mm);
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.set(6, 1);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getDayBorder(Timestamp dateTime, Timestamp timeSlot, boolean end) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(dateTime.getTime());
        dateTime.setNanos(0);
        if (timeSlot != null) {
            timeSlot.setNanos(0);
            GregorianCalendar gcTS = new GregorianCalendar();
            gcTS.setTimeInMillis(timeSlot.getTime());
            gc.set(11, gcTS.get(11));
            gc.set(12, gcTS.get(12));
            gc.set(13, gcTS.get(13));
            gc.set(14, gcTS.get(14));
        } else if (end) {
            gc.set(11, 23);
            gc.set(12, 59);
            gc.set(13, 59);
            gc.set(14, 999);
        } else {
            gc.set(14, 0);
            gc.set(13, 0);
            gc.set(12, 0);
            gc.set(11, 0);
        }
        return new Timestamp(gc.getTimeInMillis());
    }

    public static Calendar getCalendar(Timestamp date) {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        if (date != null) {
            cal.setTimeInMillis(date.getTime());
        }
        return cal;
    }

    public static Timestamp getMonthFirstDay(Timestamp day) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        Calendar cal = TimeUtil.getCalendar(day);
        cal.setTimeInMillis(day.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp addMonths(Timestamp day, int offset) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (offset == 0) {
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.add(2, offset);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp addYears(Timestamp from, int offset) {
        if (from == null) {
            return from;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(from);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (offset == 0) {
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.add(1, offset);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp addDuration(Timestamp date, String durationUnit, BigDecimal duration) {
        return TimeUtil.addDuration(date, durationUnit, duration.intValue());
    }

    public static Timestamp addDuration(Timestamp date, String durationUnit, int duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if ("D".equals(durationUnit)) {
            calendar.add(6, duration);
        } else if (DURATIONUNIT_Second.equals(durationUnit)) {
            calendar.add(13, duration);
        } else if (DURATIONUNIT_Minute.equals(durationUnit)) {
            calendar.add(12, duration);
        } else if (DURATIONUNIT_Hour.equals(durationUnit)) {
            calendar.add(11, duration);
        } else if (DURATIONUNIT_Month.equals(durationUnit)) {
            calendar.add(2, duration);
        } else if ("W".equals(durationUnit)) {
            calendar.add(4, duration);
        } else if ("Y".equals(durationUnit)) {
            calendar.add(1, duration);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static double getTimeBetween(Timestamp dateFrom, Timestamp dateTo, String durationUnit) {
        if (Util.isEmpty((String)durationUnit) || dateFrom == null || dateTo == null) {
            return 0.0;
        }
        long durationInMillis = TimeUtil.getMillisecondsBetween(dateFrom, dateTo);
        return TimeUtil.getTimeFromDuration(durationInMillis, durationUnit);
    }

    public static int getDaysFromDuration(long durationInMillis) {
        return (int)TimeUtil.getTimeFromDuration(durationInMillis, "D");
    }

    public static double getHoursFromDuration(long durationInMillis) {
        return TimeUtil.getTimeFromDuration(durationInMillis, DURATIONUNIT_Hour);
    }

    public static int getMinutesFromDuration(long durationInMillis) {
        return (int)TimeUtil.getTimeFromDuration(durationInMillis, DURATIONUNIT_Minute);
    }

    public static int getSecondsFromDuration(long durationInMillis) {
        return (int)TimeUtil.getTimeFromDuration(durationInMillis, DURATIONUNIT_Second);
    }

    public static double getTimeFromDuration(long durationInMillis, String durationUnit) {
        if (Util.isEmpty((String)durationUnit) || durationInMillis == 0L) {
            return 0.0;
        }
        double time = 0.0;
        if ("D".equals(durationUnit)) {
            time = (double)durationInMillis / 8.64E7;
        } else if (DURATIONUNIT_Hour.equals(durationUnit)) {
            time = (double)durationInMillis / 3600000.0;
        } else if (DURATIONUNIT_Minute.equals(durationUnit)) {
            time = (double)durationInMillis / 60000.0;
        } else if (DURATIONUNIT_Second.equals(durationUnit)) {
            time = (double)durationInMillis / 1000.0;
        }
        return time;
    }

    public static double getHoursBetween(Timestamp dateFrom, Timestamp dateTo) {
        return TimeUtil.getTimeBetween(dateFrom, dateTo, DURATIONUNIT_Hour);
    }

    public static int getMinutesBetween(Timestamp dateFrom, Timestamp dateTo) {
        return (int)TimeUtil.getTimeBetween(dateFrom, dateTo, DURATIONUNIT_Minute);
    }

    public static int getSecondsBetween(Timestamp dateFrom, Timestamp dateTo) {
        return (int)TimeUtil.getTimeBetween(dateFrom, dateTo, DURATIONUNIT_Second);
    }

    public static long getMillisecondsBetween(Timestamp dateFrom, Timestamp dateTo) {
        if (dateFrom == null || dateTo == null) {
            return 0L;
        }
        return dateTo.getTime() - dateFrom.getTime();
    }

    public static int getDayOfWeek(Timestamp attendanceTime) {
        Timestamp truncatedDay = TimeUtil.getDay(attendanceTime);
        Calendar calendar = TimeUtil.getCalendar(truncatedDay);
        return calendar.get(7);
    }

    public static int getMonthsBetween(Timestamp start, Timestamp end) {
        boolean negative = false;
        if (end.before(start)) {
            negative = true;
            Timestamp temp = start;
            start = end;
            end = temp;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        if (cal.get(1) == calEnd.get(1)) {
            int months = 0;
            if (negative) {
                months = (calEnd.get(2) - cal.get(2)) * -1;
                if ((calEnd.get(5) - cal.get(5)) * -1 < 0) {
                    --months;
                }
            } else {
                months = calEnd.get(2) - cal.get(2);
                if (calEnd.get(5) - cal.get(5) < 0) {
                    --months;
                }
            }
            return months;
        }
        int counter = 0;
        while (calEnd.after(cal)) {
            cal.add(2, 1);
            ++counter;
            if (calEnd.get(2) != cal.get(2) || cal.get(1) != calEnd.get(1)) continue;
        }
        if (negative) {
            counter *= -1;
            if ((calEnd.get(5) - cal.get(5)) * -1 < 0) {
                --counter;
            }
        } else if (calEnd.get(5) - cal.get(5) < 0) {
            --counter;
        }
        return counter;
    }

    public static int getYearsBetween(Timestamp from, Timestamp to) {
        Calendar dateFrom = Calendar.getInstance();
        dateFrom.setTime(from);
        Calendar dateTo = Calendar.getInstance();
        dateTo.setTime(to);
        int yearDiff = dateTo.get(1) - dateFrom.get(1);
        int monthDiff = dateTo.get(2) - dateFrom.get(2);
        int dayDiff = dateTo.get(5) - dateFrom.get(5);
        if (monthDiff < 0 || monthDiff == 0 && dayDiff < 0) {
            --yearDiff;
        }
        return yearDiff;
    }

    public static int getWeeksBetween(Timestamp from, Timestamp to) {
        Calendar dateFrom = Calendar.getInstance();
        dateFrom.set(11, 0);
        dateFrom.set(12, 0);
        dateFrom.set(13, 0);
        dateFrom.set(14, 0);
        dateFrom.setTime(from);
        Calendar dateTo = Calendar.getInstance();
        dateTo.set(11, 0);
        dateTo.set(12, 0);
        dateTo.set(13, 0);
        dateTo.set(14, 0);
        dateTo.setTime(to);
        long diff = dateTo.getTimeInMillis() - dateFrom.getTimeInMillis();
        double longWeeks = (double)diff / 6.048E8;
        int weeks = (int)longWeeks;
        if (longWeeks > (double)weeks) {
            ++weeks;
        }
        return weeks;
    }

    public static int getYearFromTimestamp(Timestamp date) {
        Timestamp time = Objects.requireNonNull(date);
        Calendar todayCal = Calendar.getInstance();
        todayCal.setTimeZone(TimeZone.getTimeZone("GMT"));
        todayCal.setTimeInMillis(time.getTime());
        return todayCal.get(1);
    }
}

