/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ws.support.kafka;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.spin.model.MADAppRegistration;
import org.spin.tools.kafka.util.MapDeserializer;
import org.spin.util.event.WeightScaleEvent;
import org.spin.util.event.WeightScaleEventListener;
import org.spin.ws.support.WeightScaleMeasure;

public class WeightScaleRunner
implements Runnable {
    private String topicName = null;
    private String completeUrl = null;
    private boolean running = false;
    private Map<String, WeightScaleEventListener> listeners = new HashMap<String, WeightScaleEventListener>();
    private Thread worker;
    private CLogger log = CLogger.getCLogger(WeightScaleRunner.class);
    private static long defaultWaitingTime = 4000L;
    private static long defaultRetrieveTime = 1000L;
    private static long defaultRefreshTime = 0L;

    public WeightScaleRunner(MADAppRegistration weightScale, Map<String, WeightScaleEventListener> listeners) {
        String refreshTimeAsString;
        String retrieveTimeAsString;
        this.listeners = listeners;
        int port = weightScale.getPort();
        String host = weightScale.getHost();
        this.topicName = weightScale.getValue();
        this.completeUrl = host + ":" + port;
        String waitingTimeAsString = weightScale.getParameterValue("default_waiting_time_ms");
        if (waitingTimeAsString != null) {
            try {
                defaultWaitingTime = Long.parseLong(waitingTimeAsString);
            }
            catch (Exception e) {
                this.log.severe(e.getLocalizedMessage());
            }
        }
        if ((retrieveTimeAsString = weightScale.getParameterValue("default_retrieve_time_ms")) != null) {
            try {
                defaultRetrieveTime = Long.parseLong(retrieveTimeAsString);
            }
            catch (Exception e) {
                this.log.severe(e.getLocalizedMessage());
            }
        }
        if ((refreshTimeAsString = weightScale.getParameterValue("default_refresh_time_ms")) != null) {
            try {
                defaultRefreshTime = Long.parseLong(refreshTimeAsString);
            }
            catch (Exception e) {
                this.log.severe(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void run() {
        this.running = true;
        try {
            String noDataMessage = Msg.parseTranslation((Properties)Env.getCtx(), (String)("@ECA06.NoDeviceData@: " + this.topicName));
            String clientName = MClient.get((Properties)Env.getCtx()).getValue() + " - " + Adempiere.getVersion() + " - " + CConnection.get().getDbHost() + " - " + CConnection.get().getDbName();
            clientName = clientName.replaceAll("[^a-zA-Z0-9. ]", "-");
            Properties config = new Properties();
            config.put("client.id", InetAddress.getLocalHost().getHostName());
            config.put("group.id", clientName);
            config.put("bootstrap.servers", this.completeUrl);
            config.put("auto.offset.reset", "latest");
            config.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            config.put("value.deserializer", MapDeserializer.class.getName());
            KafkaConsumer consumer = new KafkaConsumer(config);
            consumer.subscribe(Arrays.asList(this.topicName));
            AtomicInteger errors = new AtomicInteger();
            AtomicInteger readed = new AtomicInteger();
            AtomicLong lastReadedTime = new AtomicLong(System.currentTimeMillis());
            AtomicLong lastRefreshTime = new AtomicLong(System.currentTimeMillis());
            while (this.running) {
                long startTime = System.currentTimeMillis();
                ConsumerRecords records = consumer.poll(Duration.ofMillis(defaultRetrieveTime));
                records.forEach(record -> {
                    if (record != null) {
                        try {
                            Map value = (Map)record.value();
                            AtomicReference<BigDecimal> weight = new AtomicReference<BigDecimal>();
                            String displayWeight = (String)value.get("display_weight");
                            if (value.get("weight") instanceof Double) {
                                Double weightAsDouble = (Double)value.get("weight");
                                weight.set(BigDecimal.valueOf(Optional.ofNullable(weightAsDouble).orElse(new Double(0.0))));
                            } else if (value.get("weight") instanceof Integer) {
                                Integer weightAsInteger = (Integer)value.get("weight");
                                weight.set(BigDecimal.valueOf(Optional.ofNullable(weightAsInteger).orElse(new Integer(0)).intValue()));
                            } else {
                                String weightAsString = (String)value.get("weight");
                                weight.set(BigDecimal.valueOf(Optional.ofNullable(new Double(weightAsString)).orElse(new Double(0.0))));
                            }
                            readed.addAndGet(1);
                            long currentTime = System.currentTimeMillis();
                            lastReadedTime.set(currentTime);
                            if (currentTime - lastRefreshTime.get() >= defaultRefreshTime) {
                                lastRefreshTime.set(currentTime);
                                this.listeners.values().forEach(listener -> {
                                    WeightScaleMeasure measure = new WeightScaleMeasure(this.topicName, (BigDecimal)weight.get(), displayWeight);
                                    WeightScaleEvent event = new WeightScaleEvent(measure);
                                    listener.messageReceived(event);
                                });
                            }
                        }
                        catch (Exception e) {
                            errors.addAndGet(1);
                            this.log.severe(e.getLocalizedMessage());
                        }
                    }
                });
                consumer.commitSync();
                long endTime = System.currentTimeMillis();
                if (endTime - lastReadedTime.get() >= defaultWaitingTime) {
                    lastReadedTime.set(endTime);
                    this.listeners.values().forEach(listener -> {
                        WeightScaleMeasure measure = new WeightScaleMeasure(this.topicName, Env.ZERO, noDataMessage);
                        WeightScaleEvent event = new WeightScaleEvent(measure);
                        listener.messageReceived(event);
                    });
                }
                SimpleDateFormat format = DisplayType.getDateFormat((int)16);
                String message = "Records: " + readed.get() + " Errors: " + errors.get() + " StartTime: " + format.format(new Timestamp(startTime)) + " EndTime: " + format.format(new Timestamp(startTime)) + " Duration" + TimeUtil.formatElapsed((long)(startTime - endTime));
                this.log.fine(message);
            }
            consumer.unsubscribe();
            consumer.close(Duration.ofSeconds(1L));
            this.worker.interrupt();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
    }

    public void stop() {
        this.log.fine("Service Worker Stoping...");
        this.listeners.clear();
        this.running = false;
    }

    public void start() {
        this.log.fine("Service Worker Starting...");
        this.worker = new Thread(this);
        this.worker.start();
    }
}

