/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ws.support.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.model.MADAppRegistration;
import org.spin.util.event.WeightScaleEventListener;
import org.spin.ws.support.IWeightScale;
import org.spin.ws.support.kafka.WeightScaleRunner;

public class WeightScaleReader
implements IWeightScale {
    private int registrationId = 0;
    private Map<String, WeightScaleEventListener> listeners = new HashMap<String, WeightScaleEventListener>();
    private CLogger log = CLogger.getCLogger(WeightScaleReader.class);
    private WeightScaleRunner runner;

    public String testConnection() {
        return null;
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void start() {
        this.log.fine("Start service");
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.runner = new WeightScaleRunner(registration, this.listeners);
        this.runner.start();
    }

    @Override
    public void stop() {
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
        this.log.fine("Stop service");
    }

    @Override
    public void addListener(WeightScaleEventListener listener) {
        if (listener != null) {
            this.listeners.put(listener.toString(), listener);
        }
    }

    @Override
    public void removeListener(WeightScaleEventListener listener) {
        if (listener != null && this.listeners.containsKey(listener.toString())) {
            this.listeners.remove(listener.toString());
        }
    }
}

