/*
 * Decompiled with CFR 0.152.
 */
package org.spin.rw.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;

public class WeightReadedHandler {
    public static final String COLUMNNAME_GetWeightFromScale = "GetWeightFromScale";
    public static final String COLUMNNAME_ScaleReference_ID = "ScaleReference_ID";
    public static final String COLUMNNAME_WeightRegistered = "WeightRegistered";
    private static List<String> tablesForGetWeight = Arrays.asList("M_Production", "M_ProductionLine", "WM_InOutBoundLine");

    public static boolean isValidTable(String tableName) {
        return tablesForGetWeight.stream().filter(tableNameToFind -> tableNameToFind.equals(tableName)).findAny().isPresent();
    }

    public static void loadTablesForGetWeight(ModelValidationEngine engine, ModelValidator listener) {
        tablesForGetWeight.forEach(tableName -> engine.addModelChange(tableName, listener));
    }

    public static void setFromWeightRegistered(PO entity) {
        if (!WeightReadedHandler.isValidTable(entity.get_TableName())) {
            return;
        }
        if (entity.is_ValueChanged(COLUMNNAME_WeightRegistered)) {
            BigDecimal weightRegistered = Optional.ofNullable((BigDecimal)entity.get_Value(COLUMNNAME_WeightRegistered)).orElse(Env.ZERO);
            if (entity.get_TableName().equals("M_Production")) {
                entity.set_ValueOfColumn("ProductionQty", (Object)weightRegistered);
            } else if (entity.get_TableName().equals("M_ProductionLine")) {
                entity.set_ValueOfColumn("QtyUsed", (Object)weightRegistered);
            } else if (entity.get_TableName().equals("WM_InOutBoundLine")) {
                MWMInOutBoundLine inOutBoundLine = (MWMInOutBoundLine)entity;
                MWMInOutBound inOutBound = inOutBoundLine.getParent();
                if (inOutBound.isSOTrx()) {
                    entity.set_ValueOfColumn("PickedQty", (Object)weightRegistered);
                } else {
                    entity.set_ValueOfColumn("MovementQty", (Object)weightRegistered);
                }
            }
        }
    }
}

