/*
 * Decompiled with CFR 0.152.
 */
package org.spin.app.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.compiere.apps.ADialog;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.model.MSysConfig;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.spin.app.form.GetWeight;

public class VGetWeight
extends GetWeight
implements FormPanel,
ActionListener {
    protected int windowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private CLabel displayLabel = new CLabel();
    private CTextField displayField = new CTextField();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private FormFrame frame = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int windowNo, FormFrame frame) {
        this.windowNo = windowNo;
        frame.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"GetWeightFromScale"));
        this.frame = frame;
        try {
            this.setFromPO(frame.getProcessInfo());
            this.loadWeightScale();
            if (!this.dynInit()) {
                return;
            }
            boolean openPortAutomacically = MSysConfig.getBooleanValue((String)"OPEN_PORT_AUTOMATIC_IN_GETWEIGHT", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            if (openPortAutomacically) {
                this.startService();
            }
        }
        catch (Exception e) {
            if (Util.isEmpty((String)this.getMessage())) {
                this.addMessage(e.getMessage());
            }
            this.log.log(Level.SEVERE, this.getMessage());
        }
        finally {
            String message = this.getMessage();
            if (!Util.isEmpty((String)message)) {
                String translatedMessage = this.getTranslatedMessage();
                if (!Util.isEmpty((String)translatedMessage)) {
                    message = translatedMessage;
                }
                ADialog.warn((int)windowNo, (Container)frame.getContainer(), (String)"Error", (String)message);
            }
        }
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("dynInit()");
        this.jbInit();
        this.confirmPanel.addActionListener((ActionListener)this);
        return true;
    }

    private String getTranslatedMessage() {
        return Msg.parseTranslation((Properties)Env.getCtx(), (String)this.getMessage());
    }

    private void jbInit() throws Exception {
        this.log.info("jbInit()");
        this.loadButtons();
        CPanel displayPane = new CPanel();
        GridBagLayout displayLayout = new GridBagLayout();
        displayPane.setLayout((LayoutManager)displayLayout);
        this.displayLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"Weight"));
        this.displayLabel.setFont(new Font("Tahoma", 0, 42));
        this.displayField.setReadWrite(false);
        this.displayField.setFont(new Font("Tahoma", 0, 42));
        this.displayField.setHorizontalAlignment(4);
        this.displayField.setText(this.getDefaultText());
        displayPane.add((Component)this.displayLabel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        displayPane.add((Component)this.displayField, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        CPanel southPanel = new CPanel();
        BorderLayout southLayout = new BorderLayout();
        southPanel.setLayout((LayoutManager)southLayout);
        southPanel.add((Component)this.confirmPanel, (Object)"Center");
        BorderLayout manLayout = new BorderLayout();
        CPanel mainPanel = new CPanel();
        mainPanel.setLayout((LayoutManager)manLayout);
        mainPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        CompiereColor.setBackground((JComponent)mainPanel);
        mainPanel.add((Component)displayPane, (Object)"North");
        mainPanel.add((Component)southPanel, (Object)"South");
        this.frame.getContainer().add((Component)mainPanel, "Center");
    }

    private void loadButtons() throws Exception {
        this.log.info("loadButtons()");
        List<ValueNamePair> weightScaleList = this.getWeightScaleList();
        weightScaleList.stream().forEach(weightScale -> {
            AppsAction action = new AppsAction(weightScale.getID(), null, weightScale.getName());
            action.setDelegate((ActionListener)this);
            CButton button = (CButton)action.getButton();
            this.confirmPanel.addComponent((Component)button);
            this.log.fine("MFTAWeightScale " + weightScale.toString());
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.log.info("actionPerformed(ActionEvent e) " + event);
        if (event.getActionCommand().equals("Ok")) {
            this.log.fine("Action Comand OK");
            this.frame.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
            try {
                Trx.run((TrxRunnable)new TrxRunnable(){

                    public void run(String transactionName) {
                        VGetWeight.this.processValue();
                        VGetWeight.this.stopService();
                        VGetWeight.this.dispose();
                    }
                });
            }
            catch (Exception ex) {
                this.log.severe(ex.getLocalizedMessage());
                this.dispose();
            }
            finally {
                this.frame.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
            }
        } else if (event.getActionCommand().equals("Cancel")) {
            this.log.fine("Action Comand CANCEL");
            this.dispose();
        } else {
            this.log.fine("Action Comand Any");
            this.frame.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
            this.stopService();
            this.setCurrentWeightScale(event.getActionCommand());
            boolean ok = this.startService();
            this.frame.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
            if (!ok) {
                this.dispose();
            }
        }
    }

    public void dispose() {
        this.log.fine("Closed Window");
        this.stopService();
        this.frame.dispose();
    }

    @Override
    public void refreshDisplay(String value) {
        this.displayField.setText(value);
    }
}

